# Paragraphs Title Manager

## Overview
The **Paragraphs Title Manager** module provides a centralized, automated, and highly flexible system for controlling text alignment of *title-like* fields within any Paragraph type across your Drupal site. It enhances editorial control, ensures visual consistency, and eliminates the need for manual template overrides or per-field styling.
--
variable sample : `{{ field_machine_name_alignment_class }}`
--

This module automatically detects fields whose machine names contain the substring **"title"**—for example:

- `title`
- `sub_title`
- `title_one`
- `header_title`
- `page_title_text`

If a Paragraph type contains no such field, the module automatically displays a descriptive notice and excludes it from alignment configuration.

---

## Key Features

- 🔍 **Automatic detection** of all title-related fields in Paragraphs  
- 🧠 **Works only with fields containing “title”** (machine name)  
- 🎛️ **Global Title Alignment Settings UI**  
- 📐 Supports dynamic alignment values stored in the database  
- 🌍 **Select All / Deselect All** field toggling  
- 📱 **Responsive, mobile-friendly configuration layout**  
- 🧩 **Per-field enabling/disabling**  
- 🔒 **Safe try/catch handling** to prevent DB-related crashes  
- ✨ Automatically updates whenever new title fields are created  
- 🎨 Adds CSS classes to control alignment on the frontend  
- 🔧 Works with any custom Paragraph types without coding  

---

## Installation

1. Place the module in:
   ```
   /modules/custom/paragraphs_title_manager
   ```

2. Enable the module:
   ```
   drush en paragraphs_title_manager
   ```

3. Clear cache:
   ```
   drush cr
   ```

---

## How It Works

### 1. Auto-Detection of Title Fields  
The module inspects all Paragraph types and identifies fields whose machine names contain:

```
title
```

Examples detected:
- `title`
- `sub_title`
- `title_one`
- `my_custom_title`

Examples ignored:
- `subtitle` (no explicit “title” substring)
- `heading`
- `label`
- `header`

This ensures the module only configures fields intended as titles.

---

### 2. Global Alignment Controls

Visit:

```
/admin/config/content/paragraph-title-settings
```

There you can:

- Enable/disable alignment for each title field  
- Apply alignment choices (left, center, right, justify, start, end)  
- Bulk select or deselect all fields  
- Use the dynamic alignment selector to mass-apply alignment  

Alignment options are stored in the database and loaded dynamically using the module helper.

---

### 3. UI Messages

The module displays helpful UI messages:

#### 🔹 If no DB settings exist yet  
A general notice explains how to begin using the module.

#### 🔹 If a Paragraph type has no title fields  
A message appears inside the Paragraph’s configuration block.

#### 🔹 If no Paragraph type on the site has title fields  
A full-page message appears explaining how to add them.

#### 🔹 If title fields are detected  
You’ll see:
```
Detected fields: title_one, title, sub_title
```
🔐 Permissions

This module provides one permission:

Manage Paragraphs Title Alignment

Users with this permission can:

Access the Paragraph Title Manager configuration page

Enable/disable alignment for title fields

Apply bulk or individual alignment settings

Location to assign permissions:

/admin/people/permissions
---

## Frontend Styling

Each field with enabled alignment gets a CSS class:

```
.ptm-title-align-left
.ptm-title-align-center
.ptm-title-align-right
.ptm-title-align-justify
.ptm-title-align-start
.ptm-title-align-end
```

These classes are applied via a preprocess hook before rendering.

---

## Responsive Admin UI

The configuration screen uses:

- Grid layout  
- Responsive collapsible sections  
- Clean alignment controls  
- Mobile-friendly spacing and readability  

The UI is designed for site builders and editors on any device.

---

## Limitations

- Only affects Paragraph fields with `"title"` in the machine name  
- Does not modify WYSIWYG content headings  
- Does not impact node fields  
- Theme overrides with stricter CSS may override alignment classes  

---

## FAQ

### Q: My field does not appear — why?  
Because its machine name does not include `"title"`. Rename the field accordingly.

### Q: Can I add new alignment types?  
Yes. Add values to the database table:
```
paragraphs_title_manager_alignment_options
```

### Q: Does it work with Layout Builder?  
Yes, as long as Paragraphs are used normally.

### Q: Will this override theme styling?  
Only if your theme does not force its own alignment with higher specificity.

---

## Developer Notes

- Includes reusable DB helper class  
- Strict try/catch protection around DB operations  
- Automatic "first-time setup" messages  
- Lightweight, no external dependencies  
- No service definitions required  
- Preprocess hook adds alignment classes at runtime  

---

## File Structure

```
paragraphs_title_manager/
│
├── paragraphs_title_manager.info.yml
├── paragraphs_title_manager.install
├── paragraphs_title_manager.module
├── paragraphs_title_manager.libraries.yml
│
├── js/
│   └── paragraphs_title_manager.js
│
├── css/
│   └── paragraphs_title_manager.css
│
├── src/
│   ├── Form/
│   │   └── ParagraphsTitleManagerForm.php
│   └── Helper/
│       └── ParagraphsTitleManagerHelper.php
```

---

## Screenshots (optional)

You may add these:

```
/screenshots/settings-page.png
/screenshots/detected-fields.png
/screenshots/global-message.png
```

---

## Conclusion

The **Paragraphs Title Manager** module streamlines global title alignment control in Paragraphs-based Drupal sites. With auto-detection, dynamic alignment options, responsive UI, and safe DB handling, it is ideal for content-heavy websites requiring consistent typography across a wide range of Paragraphs.

For developers and site builders alike, this module saves time, reduces duplication, and provides a clean unified interface for managing title field presentation.

