<?php

namespace Drupal\param_verify;

use Adaddinsane\ParamVerify\ParamVerifyException;
use Adaddinsane\ParamVerify\ParamVerifyFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Class ParamVerifyUtils.
 */
class ParamVerifyUtils implements ParamVerifyUtilsInterface {

  use StringTranslationTrait;

  /**
   * Constructs a new ParamVerifyUtils object.
   */
  public function __construct(
    protected ParamVerifyFactoryInterface $verifyFactory,
    protected LoggerChannelInterface $logger
  ) {}

  /**
   * @inheritDoc
   */
  public function verify(array $configuration, array $values, bool $throwExceptionOnFail = FALSE): bool {
    // Throws an exception if the configuration is bad.
    $taskConfigVerifier = $this->verifyFactory->make($configuration);

    $errors = [];
    $taskConfigVerifier->verify($values, $errors);

    if ($errors) {
      foreach ($errors as $error) {
        $this->logger->error($error);
      }
      if ($throwExceptionOnFail) {
        throw new ParamVerifyValueException($this->formatPlural(
          count($errors),
          'Unable to verify supplied values. There was one error, check logs for details.',
          'Unable to verify supplied values. There were @count errors, check logs for details.'
        ));
      }
    }

    return empty($errors);
  }

}
