<?php

namespace Drupal\param_verify;

use Adaddinsane\ParamVerify\ParamVerifyException;

/**
 * Interface ParamVerifyUtilsInterface.
 */
interface ParamVerifyUtilsInterface {

  /**
   * Performs the whole process of verifying the supplied values.
   *
   * It first verifies the config itself, then runs that against the values.
   *
   * It logs errors and throws exceptions as appropriate.
   *  - An exception is always thrown if the configuration fails to verify.
   *  - Errors in the values are logged, you can choose whether to throw
   *    an exception on value errors or simply return false.
   *
   * @param array $configuration
   * @param array $values
   * @param bool $throwExceptionOnFail
   *
   * @return bool
   *
   * @throws ParamVerifyValueException
   * @throws ParamVerifyException
   */
  public function verify(array $configuration, array $values, bool $throwExceptionOnFail = FALSE): bool;


}
