<?php

namespace Drupal\parameters\Plugin\Parameter;

use Drupal\Core\Form\FormStateInterface;

/**
 * Legacy Content plugin class.
 *
 * This plugin got moved into the "parameters_content" sub-module. Therefore it
 * must be installed for being able to use it. Otherwise, this class here just
 * returns nothing.
 *
 * @internal
 * @see \Drupal\parameters_content\Plugin\Parameter\Content
 * @todo Remove this part on a major version upgrade such as 2.x.
 */
class Content extends NullObject {

  /**
   * {@inheritdoc}
   */
  public function __construct($configuration = [], $plugin_id = 'null', $plugin_definition = [], string $name = '') {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $name);
    \Drupal::logger('parameters')->error("A \"Content\" parameter is in use but cannot be loaded due to an invalid state of this site. Please run database updates and make sure the \"parameters_content\" module is installed.");
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    \Drupal::messenger()->addError(t('This plugin cannot be loaded due to an invalid state of this site. Please run database updates and make sure the "parameters_content" module is installed.'));
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    throw new \RuntimeException("Cannot save a broken parameter. Please see the logged errors for details.");
  }

}
