<?php

namespace Drupal\parameters_content;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\parameters_content\Internals\ContentSerializationCompilerPass;

/**
 * Provider for dynamically provided services by Parameters Content.
 */
class ParametersContentServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container) {
    // Add a compiler pass for adding Normalizers and Encoders to the Parameters
    // content serializer.
    $container->addCompilerPass(new ContentSerializationCompilerPass());
  }

}
