<?php

declare(strict_types=1);

namespace Drupal\parli_protect;

use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\HttpFoundation\IpUtils;

/**
 * Parliament Protect manager.
 */
class ParliProtectManager {

  /**
   * Constructs a Manager object.
   */
  public function __construct(
    private readonly ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Determine if the current IP is from Parliament.
   *
   * @param string $ip
   *   IP range or individual IP address.
   */
  public function isParliament(string $ip): bool {
    // Override the IP in debug mode.
    $parli_protect_config = $this->configFactory->get('parli_protect.settings');
    $debug = $parli_protect_config->get('debug_enable');
    if ($debug) {
      $ip = $parli_protect_config->get('debug_ip_address');
    }
    $ips = $parli_protect_config->get('ip_ranges');
    $ip_array = explode("\r\n", $ips);
    return IpUtils::checkIp($ip, $ip_array);
  }

}
