<?php

declare(strict_types=1);

namespace Drupal\parli_protect\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for Parliament Protect routes.
 */
class ProtectionController extends ControllerBase {

  /**
   * The Parliament Protect configuration.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $parliProtectConfig;

  /**
   * The controller constructor.
   */
  public function __construct() {
    $this->parliProtectConfig = $this->config('parli_protect.settings');
  }

  /**
   * Builds the response.
   */
  public function __invoke(): array {
    $protection = $this->parliProtectConfig->get('protection');

    switch ($protection) {
      case 'form':
        $build['form'] = $this->formBuilder()->getForm('\Drupal\parli_protect\Form\VerificationForm');
        break;

      case 'message':
        $build['content'] = [
          '#type' => 'processed_text',
          '#text' => $this->parliProtectConfig->get('message.value'),
          '#format' => $this->parliProtectConfig->get('message.format'),
          '#cache' => [
            'tags' => [
              'parli_protect',
            ],
          ],
        ];
        break;
    }

    return $build;
  }

  /**
   * Title callback for the protection route.
   */
  public function title() {
    return $this->parliProtectConfig->get('title');
  }

}
