/**
 * @file
 * Parse inline JSON and initialize the drupalSettings global object.
 */

(function () {
  const config = drupalSettings.partytown.config;

  // Transform regex literal strings into RegExp instances.
  const parseRegex = (string) => {
    // Match strings with surrounding forward slashes
    const match = string.match(/^\/(.*)\/$/);
    if (match) {
      return new RegExp(match[1]);
    }
    return string;
  };

  window.partytown = {
    debug: config.debug.enabled,
    ...config.debug.logging,
    forward: config.forward,
    loadScriptsOnMainThread: config.load_scripts_on_main_thread.map(r => parseRegex(r)),
    fallbackTimeout: parseInt(config.fallback_timeout) || 9999,
    lib: "/libraries/partytown/lib/"
  };
})();
