> [PartyTown](https://partytown.qwik.dev/) is a lazy-loaded library to help relocate resource intensive scripts into a web worker, and off of the main thread. Its goal is to help speed up sites by dedicating the main thread to your code, and offloading third-party scripts to a web worker.

This module aims to make it easy to use PartyTown with Drupal sites by taking care of attaching PartyTown scripts and providing a UI for [PartyTown configuration](https://partytown.qwik.dev/configuration/).

## Getting started

## Installing the PartyTown library

### Composer Merge Plugin (recommended)

1. If not already installed, install Merge Plugin: `composer require wikimedia/composer-merge-plugin`
1. Merge the PartyTown library from the module's composer.json: composer config extra.merge-plugin.include --json '\[ "web/modules/contrib/partytown/composer.libraries.json" \]'

### Composer repository

1. Add the following to your composer.json `repositories`
```json
partytown": {
    "type": "package",
    "package": {
        "name": "quickdev/partytown",
        "version": "0.11.0",
        "type": "drupal-library",
        "dist": {
            "url": "https://registry.npmjs.org/@qwik.dev/partytown/-/partytown-0.11.0.tgz",
            "type": "tar"
        },
        "license": "MIT"
    }
}
```
1. Require the PartyTown library: `composer require quickdev/partytown`

## PartyTown-ing your scripts 🎉

### Google Tag Manager

If you're using [Google Tag](https://www.drupal.org/project/google_tag) **1.x** then the PartyTown Google Tag sub-module will take care of PartyTown-ing the Tag Manager script. Once installed, you will probably want to configure the PartyTown module to forward `dataLayer.push`.

### Other scripts

Other scripts can be PartyTown-ed by setting the `type` to be `text\partytown`. Using a `*.libraries.yml` this can be acheived with something similiar to:

```yml
foo:
  js:
    js/foo.js: { attributes: { type: "text/partytown"} }
```