<?php

declare(strict_types=1);

namespace Drupal\partytown_google_tag\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure PartyTown Google Tag settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'partytown_google_tag_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['partytown_google_tag.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['datalayer_logging'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Datalayer logging'),
      '#default_value' => $this->config('partytown_google_tag.settings')->get('datalayer_logging'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('partytown_google_tag.settings')
      ->set('datalayer_logging', $form_state->getValue('datalayer_logging'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
