# Partytown Drupal
This module is a Drupal integration for Partytown, a lazy-loaded library to help relocate resource intensive scripts into a web worker, and off of the main thread. Its goal is to help speed up sites by dedicating the main thread to your code, and offloading third-party scripts to a web worker.

Partytown is a third-party library created by [https://qwik.dev](partytown.qwik.dev) that is considered beta-quality by its creators. This module will always package a stable release of Partytown, when available.

## No Longer Maintained
This project is no longer actively maintained. All development efforts will be shifted to the new Partytown module, found here: https://www.drupal.org/project/partytown. This new project has all of the same features as this existing module.
## Installation

Install as you would normally install a contributed Drupal module. For more information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration
Go to Administration » Configuration » System » Partytown Drupal Settings to modify Partytown's behavior. All settings set in the Drupal UI get fed into a `window.partytown` variable on the frontend.

If you are using an alternate UI, you may need to handle loading the `partytown.js` script on your own. Before the Partytown script, you should add a script tag that implements your settings. For example:

``` html
<script>
  partytown = {
    debug: true,
    lib: '/some/path/to/lib'
    ...
  };
</script>
```

For more information, read the developer's documentation about config [here](https://partytown.qwik.dev/configuration/).

## Features
Provides a third party library that loads and executes scripts using a service worker. Partytown is designed to keep your main thread clear for high-priority resources. In a working setup, this can help reduce page load time and improve vital SEO metrics like LCP and render blocking time.

This module will load the Partytown library for you and mount it on the page. There is also a configuration interface admins can use to tweak Partytown's settings.

## Post-Installation
For a simple setup, users need only enable the Partytown module and then change the MIME type of the scripts they want Partytown to handle.

``` html
<script type="text/partytown">...
```
