# Password Reset Code

A Drupal module that provides functionality for managing password reset codes and user authentication recovery.

## Features

- Generate and manage secure password reset codes
- Enhanced user authentication recovery
- Time-limited reset code validation
- Customizable reset code settings
- Seamless integration with Drupal's user management system

## Requirements

- Drupal 10.1, 11, or 12
- PHP 8.0 or higher

## Installation

### Using Composer

1. Navigate to your Drupal root directory
2. Run the following command:
   ```bash
   composer require drupal/password_reset_code
   ```
### Manual Installation

1. Download the module to your Drupal `modules` directory
2. Enable the module:
   ```bash
   drush en password_reset_code
   ```
   
   Or navigate to **Admin > Extend** and enable the module through the UI

## Configuration

After enabling the module, navigate to the module configuration page to:

- Set password reset code expiration time
- Configure email notifications
- Customize reset code generation parameters
- Manage user permissions

### Permissions

The module provides the following permissions:

- **Administer password reset codes** - Full access to password reset functionality
- Additional permissions may be configured based on your needs

## Usage

### For Users

1. Navigate to the password reset page
2. Enter your email address
3. Check your email for the password reset code
4. Follow the link to reset your password

### For Administrators

Access password reset code management from **Admin > Configuration** to:

- View active reset codes
- Revoke or extend reset codes
- Configure reset code policies

