(function (Drupal) {
  'use strict';

  Drupal.behaviors.passwordResetCodeInput = {
    attach: function (context) {
      var form = context.getElementById
        ? context.getElementById('password-reset-code-form')
        : context.querySelector('#password-reset-code-form');

      if (!form) return;

      var input = form.querySelector('input[name="code"]');
      // Check for either input[type="submit"] or button[type="submit"]
      var submit = form.querySelector('input[type="submit"], button[type="submit"]');

      if (!input || !submit) return;

      // Ensure only digits and at most 6 chars.
      function sanitise() {
        var v = input.value.replace(/\D+/g, '').slice(0, 6);
        if (input.value !== v) input.value = v;
        submit.toggleAttribute('disabled', v.length !== 6);
      }

      input.addEventListener('input', sanitise, { passive: true });
      // Initialize on attach.
      sanitise();
    }
  };
})(Drupal);
