<?php

namespace Drupal\password_reset_code\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class PasswordResetCodeSettingsForm extends ConfigFormBase {

  protected function getEditableConfigNames() {
    return ['password_reset_code.settings'];
  }

  public function getFormId() {
    return 'password_reset_code_settings_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('password_reset_code.settings');

    $form['general'] = [
      '#type' => 'details',
      '#title' => $this->t('General settings'),
      '#open' => TRUE,
    ];

    $form['general']['max_tries'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum code attempts'),
      '#default_value' => $config->get('max_tries') ?? 5,
      '#min' => 1,
      '#description' => $this->t('How many times a user can try the code before the request is invalidated.'),
    ];

    $form['general']['extend_minutes'] = [
      '#type' => 'number',
      '#title' => $this->t('Minutes to extend after code validation'),
      '#default_value' => $config->get('extend_minutes') ?? 5,
      '#min' => 1,
      '#description' => $this->t('After the code is validated, the validity window is extended by this many minutes to allow the user to set a new password.'),
    ];

    $form['messages'] = [
      '#type' => 'details',
      '#title' => $this->t('User messages'),
      '#open' => TRUE,
    ];

    $form['messages']['msg_already_used'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Already used message'),
      '#default_value' => $config->get('msg_already_used') ?? $this->t('This password reset code has already been used.'),
    ];
    $form['messages']['msg_expired'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Expired message'),
      '#default_value' => $config->get('msg_expired') ?? $this->t('Your password reset code has expired. Please request a new one.'),
    ];
    $form['messages']['msg_too_many_tries'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Too many tries message'),
      '#default_value' => $config->get('msg_too_many_tries') ?? $this->t('Too many incorrect attempts. Please request a new password reset.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('password_reset_code.settings')
      ->set('max_tries', (int) $form_state->getValue('max_tries'))
      ->set('extend_minutes', (int) $form_state->getValue('extend_minutes'))
      ->set('msg_already_used', (string) $form_state->getValue('msg_already_used'))
      ->set('msg_expired', (string) $form_state->getValue('msg_expired'))
      ->set('msg_too_many_tries', (string) $form_state->getValue('msg_too_many_tries'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
