<?php

declare(strict_types = 1);

namespace Drupal\patch_info\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;

/**
 * Returns responses for Patch info routes.
 */
final class PatchInfoController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function patchInfoMenuBlockPage(): array {
    $menu_manager = \Drupal::service('plugin.manager.menu.link');
    $definitions = $menu_manager->getDefinitions();

    $links = [];
    foreach ($definitions as $definition) {
      // Filter by your module.
      if ($definition['provider'] === 'patch_info') {

        // Skip system links if needed.
        if (!empty($definition['route_name']) && $definition['route_name'] !== 'patch_info.patch_info_home') {
          $links[] = [
            'title' => $definition['title'],
            'description' => $definition['description'] ?? '',
            'url' => Url::fromRoute($definition['route_name'], $definition['route_parameters'] ?? []),
          ];
        }
      }
    }

    return [
      '#theme' => 'admin_block_content',
      '#content' => $links,
    ];

  }

}
