<?php

namespace Drupal\patch_info\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * Provides a field to display status as Active/Inactive.
 *
 * @ViewsField("patch_info_status_label")
 */
class StatusLabel extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->addAdditionalFields(['status']);
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $value = $values->status ?? 0;
    $status_list = patch_info_status_options();
    return $status_list[$value] ?? t('Unknown');
  }

}
