<?php

declare(strict_types=1);

namespace Drupal\path_alias_views_cshs_filter\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Contains hook implementations for the Path alias views HS filter module.
 */
class ViewsHooks {

  /**
   * Implements hook_views_data_alter().
   */
  #[Hook('views_data_alter')]
  public function viewsDataAlter(array &$data) {
    // Alias filter by section.
    $data['path_alias']['alias']['filter']['id'] = 'path_alias_alias';
  }

}
