<?php

declare(strict_types=1);

namespace Drupal\path_alias_views\Handler;

use Drupal\views\EntityViewsData;

class PathAliasViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    // Status field.
    $data['path_alias']['status']['field']['label'] = $this->t('Published status');
    $data['path_alias']['status']['field']['default_formatter_settings'] = [
      'format' => 'custom',
      'format_custom_false' => $this->t('Unpublished'),
      'format_custom_true' => $this->t('Published'),
    ];

    $data['path_alias']['status']['filter']['label'] = $this->t('Published status');
    $data['path_alias']['status']['filter']['type'] = 'yes-no';
    // Use status = 1 instead of status <> 0 in WHERE statement.
    $data['path_alias']['status']['filter']['use_equal'] = TRUE;

    $data['path_alias']['status_extra'] = [
      'title' => $this->t('Published status or admin user'),
      'help' => $this->t('Filters out unpublished content if the current user cannot view it.'),
      'filter' => [
        'field' => 'status',
        'id' => 'node_status',
        'label' => $this->t('Published status or admin user'),
      ],
    ];

    // Add a relationship to each content entity type.
    foreach ($this->entityTypeManager->getDefinitions() as $target_entity_type_id => $target_entity_type) {
      if ($target_entity_type->getGroup() != 'content') {
        continue;
      }

      $target_base_table = $target_entity_type->getDataTable() ?: $target_entity_type->getBaseTable();

      // Get the canonical link template, and extract its root, so we can deduce
      // the amount to trim from the canonical link to an entity to get the ID
      // in the SQL JOIN.
      $canonical_link_template = $target_entity_type->getLinkTemplate('canonical');

      if (!$canonical_link_template) {
        // Skip this entity type if it has no canonical link template.
        continue;
      }
      if (!str_ends_with($canonical_link_template, '{' . $target_entity_type_id . '}')) {
        // Skip this entity type if its canonical link template doesn't end
        // with the entity placeholder.
        continue;
      }

      $canonical_link_template_root = str_replace('{' . $target_entity_type_id . '}', '', $canonical_link_template);

      if (str_contains($canonical_link_template_root, '{')) {
        // Skip this entity type if its canonical link template contains more
        // than one placeholder.
        continue;
      }

      $args = [
        '@label' => $target_entity_type->getLabel(),
      ];
      $data['path_alias']['system_path_' . $target_entity_type_id]['relationship'] = [
        'title' => $this->t('Target @label', $args),
        'label' => $this->t('Target @label', $args),
        'help' => $this->t('Relationship to @label entity that a path alias targets.', $args),
        'id' => 'standard',
        'join_id' => 'path_alias_target_entity',
        'base' => $target_base_table,
        'entity type' => $target_entity_type_id,
        'base field' => $target_entity_type->getKey('id'),
        'relationship field' => 'path',
        'canonical_template_root' => $canonical_link_template_root,
      ];
    }

    return $data;
  }

}
