<?php

declare(strict_types=1);

namespace Drupal\path_alias_views\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\path_alias_views\Handler\PathAliasViewsData;

/**
 * Contains hook implementations for the Path alias views module.
 */
class EntityHooks {

  /**
   * Implements hook_entity_type_alter().
   */
  #[Hook('entity_type_alter')]
  public function entityTypeAlter(array &$entity_types) {
    /** @var \Drupal\Core\Entity\EntityTypeInterface[] $entity_types */
    // Set a views data handler class for path_alias entities.
    $entity_types['path_alias']->setHandlerClass('views_data', PathAliasViewsData::class);
  }

}
