<?php

declare(strict_types=1);

namespace Drupal\path_alias_views\Plugin\views\join;

use Drupal\views\Attribute\ViewsJoin;
use Drupal\views\Plugin\views\join\JoinPluginBase;

/**
 * Views join plugin for joining the path_alias table to entity tables.
 */
#[ViewsJoin('path_alias_target_entity')]
class PathAliasTargetEntity extends JoinPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildJoin($select_query, $table, $view_query) {
    // Form a join with a condition of the form
    // 'ON substring(path) = ENTITY_TYPE AND substring(path) = ENTITY_ID'
    // We want to join on matching entity ID, and also limit the join to the
    // entity type, so we don't join '/file/42' to node 42.
    $left_table = $view_query->getTableInfo($this->leftTable);
    $left_table_alias = $left_table['alias'];
    $right_table = $this->table;

    $condition = "SUBSTRING({$left_table_alias}.path FROM 1 FOR :end_of_root) = :canonical_root AND SUBSTRING({$left_table_alias}.path FROM :start_of_id) = $table[alias].$this->field";
    $arguments = [
      ':end_of_root' => strlen($this->configuration['canonical_template_root']),
      ':start_of_id' => strlen($this->configuration['canonical_template_root']) + 1,
      ':canonical_root' => $this->configuration['canonical_template_root'],
    ];

    $select_query->addJoin($this->type, $right_table, $table['alias'], $condition, $arguments);
  }

}
