<?php

namespace Drupal\pathauto_entity_parent\Hook;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Entity base field info hooks.
 */
class EntityBaseFieldInfoHooks {

  use StringTranslationTrait;

  /**
   * Add pathauto_entity_parent field to nodes.
   */
  #[Hook('entity_base_field_info')]
  public function entityBaseFieldInfo(EntityTypeInterface $entity_type): array {
    $fields = [];
    if ($entity_type->id() === 'node') {
      $fields['pathauto_entity_parent'] = BaseFieldDefinition::create('entity_reference')
        ->setLabel($this->t('Parent', [], ['context' => 'Parent node']))
        ->setDescription($this->t('Specify a parent node for nesting routes @example', [
          '@example' => ', i.e., /parent-node/child-node',
        ]))
        ->setSetting('target_type', 'node')
        ->setSetting('handler', 'default')
        ->setDisplayConfigurable('form', TRUE)
        ->setDisplayOptions('form', [
          'type'     => 'entity_reference_autocomplete',
          'weight'   => 31,
          'settings' => [
            'match_operator' => 'CONTAINS',
            'size'           => '60',
            'placeholder'    => '',
          ],
        ]);
    }
    return $fields;
  }

}
