<?php

namespace Drupal\pathauto_entity_parent\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\ContentEntityFormInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\node\NodeInterface;
use Drupal\pathauto_entity_parent\Form\ConfigForm;

/**
 * Form alter hooks.
 */
class FormAlterHooks {

  public function __construct(protected ConfigFactoryInterface $configFactory) {}

  /**
   * Alter node add/edit form.
   */
  #[Hook('form_alter')]
  public function formAlter(array &$form, FormStateInterface $form_state, string $form_id): void {
    if (isset($form['pathauto_entity_parent']) && preg_match('/^node_(.*)(_form|_edit_form)$/', $form_id)) {
      $form_object = $form_state->getFormObject();
      if ($form_object instanceof ContentEntityFormInterface) {
        $entity = $form_object->getEntity();
        if ($entity instanceof NodeInterface) {
          $config            = $this->configFactory->get(ConfigForm::PATHAUTO_ENTITY_PARENT_SETTINGS);
          $available_bundles = $config->get('bundles') ?? [];
          if (in_array($entity->bundle(), $available_bundles, TRUE)) {
            // Disable field if "pathauto" is not checked.
            $form['pathauto_entity_parent']['widget'][0]['target_id']['#states']['disabled']['input[name="path[0][pathauto]"]'] = ['checked' => FALSE];
            // Move widget.
            $form['path']['widget'][0]['pathauto_entity_parent'] = $form['pathauto_entity_parent'];
            unset($form['pathauto_entity_parent']);
          }
          else {
            $form['pathauto_entity_parent']['#access'] = FALSE;
          }
        }
      }
    }
  }

}
