<?php

namespace Drupal\pathauto_entity_parent\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Help hooks.
 */
class HelpHooks {

  use StringTranslationTrait;

  /**
   * Provide help for the module.
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): string {
    $output = '';
    if ($route_name === 'help.page.pathauto_entity_parent') {
      $output = '<h3>' . $this->t('About') . '</h3>';
      $output .= '<p>' . $this->t('This module allows to nest node aliases N times. For example: <em>my-page/my-child-page-1/my-child-page-2</em>') . '</p>';
      $output .= '<p>' . $this->t('For more information, visit the module\'s <a href="@href" target="_blank">website</a>.', ['@href' => 'https://www.drupal.org/project/pathauto_entity_parent']) . '</p>';
    }
    return $output;
  }

}
