<?php

namespace Drupal\pathauto_entity_parent\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\node\Entity\Node;
use Drupal\node\NodeInterface;
use Drupal\path_alias\AliasRepositoryInterface;
use Drupal\pathauto\PathautoPatternInterface;
use Drupal\pathauto_entity_parent\Form\ConfigForm;

/**
 * Class Pathauto pattern alter hooks.
 */
class PathautoPatternAlterHooks {

  public function __construct(protected ConfigFactoryInterface $configFactory, protected AliasRepositoryInterface $aliasRepository) {}

  /**
   * Alter pathauto pattern to include parent node alias.
   */
  #[Hook('pathauto_pattern_alter')]
  public function pathautoPatternAlter(PathautoPatternInterface $pattern, array $context): void {
    if (isset($context['data']['node'])) {
      $node = $context['data']['node'];

      if ($node instanceof NodeInterface) {
        $config            = $this->configFactory->get(ConfigForm::PATHAUTO_ENTITY_PARENT_SETTINGS);
        $available_bundles = $config->get('bundles') ?? [];
        if ($node->hasField('pathauto_entity_parent') && in_array($node->bundle(), $available_bundles, TRUE) && !empty($parent_node_id = $node->get('pathauto_entity_parent')->getString())) {
          $parent_node = Node::load($parent_node_id);
          if ($parent_node instanceof NodeInterface) {
            $alias_repository = $this->aliasRepository->lookupBySystemPath('/node/' . $parent_node->id(), $node->language()->getId());
            if (!empty($alias_repository)) {
              $pattern->setPattern($alias_repository['alias'] . '/' . $pattern->getPattern());
            }
          }
        }
      }
    }
  }

}
