/*!
 * /**
 * * @name JSON Editor
 * * @description JSON Schema Based Editor
 * * This library is the continuation of jdorn's great work (see also https://github.com/jdorn/json-editor/issues/800)
 * * @version "2.15.2"
 * * @author Jeremy Dorn
 * * @see https://github.com/jdorn/json-editor/
 * * @see https://github.com/json-editor/json-editor
 * * @license MIT
 * * @example see README.md and docs/ for requirements, examples and usage info
 * * /
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/defaults.js":
/*!*************************!*\
  !*** ./src/defaults.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   defaults: () => (/* binding */ defaults)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _resolvers_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./resolvers.js */ "./src/resolvers.js");
/* harmony import */ var _editors_index_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./editors/index.js */ "./src/editors/index.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






















/* default theme */
var theme = 'html';

/* default template engine */
var template = 'default';

/* Global callback list */
var callbacks = {};
var themes = {};
var templates = {};
var iconlibs = {};
var languages = {};
// eslint-disable-next-line camelcase
var custom_validators = [];

/* Translation strings and default languages */
// eslint-disable-next-line camelcase
var default_language = 'en';
// eslint-disable-next-line camelcase
var language = default_language;
languages.en = {
  /**
   * When a property is not set
   */
  error_notset: 'Property must be set',
  /**
  * When a string must not be empty
  */
  error_notempty: 'Value required',
  /**
  * When a value is not one of the enumerated values
  */
  error_enum: 'Value must be one of the enumerated values',
  /**
  * When a value is not equal to the constant
  */
  error_const: 'Value must be the constant value',
  /**
  * When a value doesn't validate any schema of a 'anyOf' combination
  */
  error_anyOf: 'Value must validate against at least one of the provided schemas',
  /**
  * When a value doesn't validate
  * @variables This key takes one variable: The number of schemas the value does not validate
  */
  error_oneOf: 'Value must validate against exactly one of the provided schemas. It currently validates against {{0}} of the schemas.',
  /**
  * When a value does not validate a 'not' schema
  */
  error_not: 'Value must not validate against the provided schema',
  /**
  * When a value does not match any of the provided types
  */
  error_type_union: 'Value must be one of the provided types',
  /**
  * When a value does not match the given type
  * @variables This key takes one variable: The type the value should be of
  */
  error_type: 'Value must be of type {{0}}',
  /**
  *  When the value validates one of the disallowed types
  */
  error_disallow_union: 'Value must not be one of the provided disallowed types',
  /**
  *  When the value validates a disallowed type
  * @variables This key takes one variable: The type the value should not be of
  */
  error_disallow: 'Value must not be of type {{0}}',
  /**
  * When a value is not a multiple of or divisible by a given number
  * @variables This key takes one variable: The number mentioned above
  */
  error_multipleOf: 'Value must be a multiple of {{0}}',
  /**
  * When a value is greater than it's supposed to be (exclusive)
  * @variables This key takes one variable: The maximum
  */
  error_maximum_excl: 'Value must be less than {{0}}',
  /**
  * When a value is greater than it's supposed to be (inclusive
  * @variables This key takes one variable: The maximum
  */
  error_maximum_incl: 'Value must be at most {{0}}',
  /**
  * When a value is lesser than it's supposed to be (exclusive)
  * @variables This key takes one variable: The minimum
  */
  error_minimum_excl: 'Value must be greater than {{0}}',
  /**
  * When a value is lesser than it's supposed to be (inclusive)
  * @variables This key takes one variable: The minimum
  */
  error_minimum_incl: 'Value must be at least {{0}}',
  /**
  * When a value have too many characters
  * @variables This key takes one variable: The maximum character count
  */
  error_maxLength: 'Value must be at most {{0}} characters long',
  /**
   * When no array items validates the contains schema
   */
  error_contains: 'No items match contains',
  /**
   * When an array have too few items that validate agaist contains schema
   * @variables This key takes two variable: The valid items count and the minContains value
   */
  error_minContains: 'Contains match count {{0}} is less than minimum contains count of {{1}}',
  /**
   * When an array have too many items that validate agaist contains schema
   * @variables This key takes two variable: The valid items count and the maxContains value
   */
  error_maxContains: 'Contains match count {{0}} exceeds maximum contains count of {{1}}',
  /**
  * When a value does not have enough characters
  * @variables This key takes one variable: The minimum character count
  */
  error_minLength: 'Value must be at least {{0}} characters long',
  /**
  * When a value does not match a given pattern
  */
  error_pattern: 'Value must match the pattern {{0}}',
  /**
  * When an array has additional items whereas it is not supposed to
  */
  error_additionalItems: 'No additional items allowed in this array',
  /**
  * When there are to many items in an array
  * @variables This key takes one variable: The maximum item count
  */
  error_maxItems: 'Value must have at most {{0}} items',
  /**
  * When there are not enough items in an array
  * @variables This key takes one variable: The minimum item count
  */
  error_minItems: 'Value must have at least {{0}} items',
  /**
  * When an array is supposed to have unique items but has duplicates
  */
  error_uniqueItems: 'Array must have unique items',
  /**
  * When there are too many properties in an object
  * @variables This key takes one variable: The maximum property count
  */
  error_maxProperties: 'Object must have at most {{0}} properties',
  /**
  * When there are not enough properties in an object
  * @variables This key takes one variable: The minimum property count
  */
  error_minProperties: 'Object must have at least {{0}} properties',
  /**
  * When a required property is not defined
  * @variables This key takes one variable: The name of the missing property
  */
  error_required: "Object is missing the required property '{{0}}'",
  /**
  * When there is an additional property is set whereas there should be none
  * @variables This key takes one variable: The name of the additional property
  */
  error_additional_properties: 'No additional properties allowed, but property {{0}} is set',
  /**
  * When there is a propertyName that sets a max length and a property name exceeds the max length
  * @variables This key takes one variable: The name of the invalid property
  */
  error_property_names_exceeds_maxlength: 'Property name {{0}} exceeds maxLength',
  /**
  * When there is a propertyName that sets an enum and a property name matches none of the possible enum
  * @variables This key takes one variable: The name of the invalid property
  */
  error_property_names_enum_mismatch: 'Property name {{0}} does not match any enum values',
  /**
  * When there is a propertyName that sets a const and a property does not match the const value
  * @variables This key takes one variable: The name of the invalid property
  */
  error_property_names_const_mismatch: 'Property name {{0}} does not match the const value',
  /**
  * When there is a propertyName that sets a pattern and a property name does not match the pattern
  * @variables This key takes one variable: The name of the invalid property
  */
  error_property_names_pattern_mismatch: 'Property name {{0}} does not match pattern',
  /**
  * When the propertyName is set to false and there is at least one property
  * @variables This key takes one variable: The name of the invalid property
  */
  error_property_names_false: 'Property name {{0}} fails when propertyName is false',
  /**
  * When the propertyName specifies a maxLength that is not a number
  * @variables This key takes one variable: The name of the current property
  */
  error_property_names_maxlength: 'Property name {{0}} cannot match invalid maxLength',
  /**
  * When the propertyName specifies an enum that is not an array
  * @variables This key takes one variable: The name of the current property
  */
  error_property_names_enum: 'Property name {{0}} cannot match invalid enum',
  /**
  * When the propertyName specifies a pattern that is not a string
  * @variables This key takes one variable: The name of the current property
  */
  error_property_names_pattern: 'Property name {{0}} cannot match invalid pattern',
  /**
  * When the propertyName is unsupported
  * @variables This key takes one variable: The name of the invalid propertyName
  */
  error_property_names_unsupported: 'Unsupported propertyName {{0}}',
  /**
  * When a dependency is not resolved
  * @variables This key takes one variable: The name of the missing property for the dependency
  */
  error_dependency: 'Must have property {{0}}',
  /**
  * When a date is in incorrect format
  * @variables This key takes one variable: The valid format
  */
  error_date: 'Date must be in the format {{0}}',
  /**
  * When a time is in incorrect format
  * @variables This key takes one variable: The valid format
  */
  error_time: 'Time must be in the format {{0}}',
  /**
  * When a datetime-local is in incorrect format
  * @variables This key takes one variable: The valid format
  */
  error_datetime_local: 'Datetime must be in the format {{0}}',
  /**
  * When a integer date is less than 1 January 1970
  */
  error_invalid_epoch: 'Date must be greater than 1 January 1970',
  /**
  * When an IPv4 is in incorrect format
  */
  error_ipv4: 'Value must be a valid IPv4 address in the form of 4 numbers between 0 and 255, separated by dots',
  /**
  * When an IPv6 is in incorrect format
  */
  error_ipv6: 'Value must be a valid IPv6 address',
  /**
  * When a hostname is in incorrect format
  */
  error_hostname: 'The hostname has the wrong format',
  /**
   * When uploads max size limit is exceeded
   */
  upload_max_size: 'Filesize too large. Max size is ',
  /**
   * When the mime type does not match the type of the file
   */
  upload_wrong_file_format: 'Wrong file format. Allowed format(s): ',
  /**
  * Text/Title on Save button
  */
  button_save: 'Save',
  /**
  * Text/Title on Copy button
  */
  button_copy: 'Copy',
  /**
  * Text/Title on Cancel button
  */
  button_cancel: 'Cancel',
  /**
  * Text/Title on Add button
  */
  button_add: 'Add',
  /**
  * Text on Delete All buttons
  */
  button_delete_all: 'All',
  /**
  * Title on Delete All buttons
  */
  button_delete_all_title: 'Delete All',
  /**
  * Text on Delete Last buttons
  * @variable This key takes one variable: The title of object to delete
  */
  button_delete_last: 'Last {{0}}',
  /**
  * Title on Delete Last buttons
  * @variable This key takes one variable: The title of object to delete
  */
  button_delete_last_title: 'Delete Last {{0}}',
  /**
  * Title on Add Row buttons
  * @variable This key takes one variable: The title of object to add
  */
  button_add_row_title: 'Add {{0}}',
  /**
  * Title on Move Down buttons
  */
  button_move_down_title: 'Move down',
  /**
  * Title on Move Up buttons
  */
  button_move_up_title: 'Move up',
  /**
  * Text on Object Properties buttons
  */
  button_properties: 'Properties',
  /**
  * Title on Object Properties buttons
  */
  button_object_properties: 'Object Properties',
  /**
  * Title on Copy Row button
  * @variable This key takes one variable: The title of object to delete
  */
  button_copy_row_title: 'Copy {{0}}',
  /**
  * Title on Delete Row buttons
  * @variable This key takes one variable: The title of object to delete
  */
  button_delete_row_title: 'Delete {{0}}',
  /**
  * Title on Delete Row buttons, short version (no parameter with the object title)
  */
  button_delete_row_title_short: 'Delete',
  /**
  * Title on Copy Row buttons, short version (no parameter with the object title)
  */
  button_copy_row_title_short: 'Copy',
  /**
  * Title on Collapse buttons
  */
  button_collapse: 'Collapse',
  /**
  * Title on Expand buttons
  */
  button_expand: 'Expand',
  /**
  * Title on Edit JSON buttons
  */
  button_edit_json: 'Edit JSON',
  /**
  * Text/Title on Upload buttons
  */
  button_upload: 'Upload',
  /**
  * Title on Flatpickr toggle buttons
  */
  flatpickr_toggle_button: 'Toggle',
  /**
  * Title on Flatpickr clear buttons
  */
  flatpickr_clear_button: 'Clear',
  /**
  * Choices input field placeholder text
  */
  choices_placeholder_text: 'Start typing to add value',
  /**
  * Default title for array items
  */
  default_array_item_title: 'item',
  /**
  * Warning when deleting a node
  */
  button_delete_node_warning: 'Are you sure you want to remove this item?',
  /**
   * Warning when deleting a node
   */
  table_controls: 'Controls',
  /**
   * Warning when paste and  length exceeded maxLength
   */
  paste_max_length_reached: 'Pasted text exceeded maximum length of {{0}} and will be clipped.'
};

/* Default per-editor options */
Object.entries(_editors_index_js__WEBPACK_IMPORTED_MODULE_20__.editors).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
    i = _ref2[0],
    editor = _ref2[1];
  _editors_index_js__WEBPACK_IMPORTED_MODULE_20__.editors[i].options = editor.options || {};
});

/* Default upload handler */
function upload(type, file, cbs) {
  // eslint-disable-next-line no-console
  console.log('Upload handler required for upload editor');
}

/* String translate function */
function translate(key, variables, schema) {
  var schemaMessages = {};
  if (schema && schema.options && schema.options.error_messages && schema.options.error_messages[defaults.language]) {
    schemaMessages = schema.options.error_messages[defaults.language];
  }
  var lang = defaults.languages[defaults.language];
  if (!lang) throw new Error("Unknown language ".concat(defaults.language));
  var string = schemaMessages[key] || lang[key] || defaults.languages[default_language][key] || key;
  if (variables) {
    for (var i = 0; i < variables.length; i++) {
      string = string.replace(new RegExp("\\{\\{".concat(i, "}}"), 'g'), variables[i]);
    }
  }
  return string;
}

/* Text element translate function */

function translateProperty(text, variables) {
  return text;
}

/* Default options when initializing JSON Editor */
var options = {
  upload: upload,
  use_name_attributes: true,
  prompt_before_delete: true,
  use_default_values: true,
  max_depth: 0,
  button_state_mode: 1,
  case_sensitive_property_search: true,
  show_errors: 'interaction',
  prompt_paste_max_length_reached: false,
  remove_false_properties: false,
  enforce_const: false,
  opt_in_widget: 'checkbox'
};

/* This assignment was previously in index.js but makes more sense here */
var defaults = {
  options: options,
  theme: theme,
  template: template,
  themes: themes,
  callbacks: callbacks,
  templates: templates,
  iconlibs: iconlibs,
  editors: _editors_index_js__WEBPACK_IMPORTED_MODULE_20__.editors,
  languages: languages,
  resolvers: _resolvers_js__WEBPACK_IMPORTED_MODULE_19__.resolvers,
  custom_validators: custom_validators,
  default_language: default_language,
  language: language,
  translate: translate,
  translateProperty: translateProperty
};

/***/ }),

/***/ "./src/editor.js":
/*!***********************!*\
  !*** ./src/editor.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractEditor: () => (/* binding */ AbstractEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ "./node_modules/core-js/modules/es.array.index-of.js");
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.array.some.js */ "./node_modules/core-js/modules/es.array.some.js");
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.object.values.js */ "./node_modules/core-js/modules/es.object.values.js");
/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.string.starts-with.js */ "./node_modules/core-js/modules/es.string.starts-with.js");
/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./utilities.js */ "./src/utilities.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }

































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/**
 * All editors should extend from this class
 */
var AbstractEditor = /*#__PURE__*/function () {
  function AbstractEditor(options, defaults) {
    var _this$options$enforce, _this$options$opt_in_;
    _classCallCheck(this, AbstractEditor);
    this.defaults = defaults;
    this.jsoneditor = options.jsoneditor;
    this.theme = this.jsoneditor.theme;
    this.template_engine = this.jsoneditor.template;
    this.iconlib = this.jsoneditor.iconlib;
    this.translate = this.jsoneditor.translate || this.defaults.translate;
    this.translateProperty = this.jsoneditor.translateProperty || this.defaults.translateProperty;
    this.original_schema = options.schema;
    this.schema = this.jsoneditor.expandSchema(this.original_schema);
    this.active = true;
    this.isUiOnly = false;
    this.options = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_33__.extend)({}, this.options || {}, this.schema.options || {}, options.schema.options || {}, options);
    this.enforceConstEnabled = (_this$options$enforce = this.options.enforce_const) !== null && _this$options$enforce !== void 0 ? _this$options$enforce : this.jsoneditor.options.enforce_const;
    this.formname = this.jsoneditor.options.form_name_root || 'root';
    if (!options.path && !this.schema.id) this.schema.id = this.formname;
    this.path = options.path || this.formname;
    this.formname = options.formname || this.path.replace(/\.([^.]+)/g, '[$1]');
    this.parent = options.parent;
    this.key = this.parent !== undefined ? this.path.split('.').slice(this.parent.path.split('.').length).join('.') : this.path;
    this.link_watchers = [];
    this.watchLoop = false;
    this.optInWidget = (_this$options$opt_in_ = this.options.opt_in_widget) !== null && _this$options$opt_in_ !== void 0 ? _this$options$opt_in_ : this.jsoneditor.options.opt_in_widget;
    if (options.container) this.setContainer(options.container);
    this.registerDependencies();
  }
  return _createClass(AbstractEditor, [{
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      this.onChange(true, false, eventData);
    }
  }, {
    key: "notify",
    value: function notify() {
      if (this.path) this.jsoneditor.notifyWatchers(this.path);
    }
  }, {
    key: "change",
    value: function change(eventData) {
      if (this.parent) this.parent.onChildEditorChange(this, eventData);else if (this.jsoneditor) this.jsoneditor.onChange(eventData);
    }
  }, {
    key: "onChange",
    value: function onChange(bubble, fromTemplate, eventData) {
      this.notify();
      if (!fromTemplate) {
        if (this.watch_listener) this.watch_listener();
      }
      if (bubble) this.change(eventData);
    }
  }, {
    key: "register",
    value: function register() {
      this.jsoneditor.registerEditor(this);
      if (this.input && !this.label) {
        var ariaLabel = this.getTitle() || this.formname;
        this.input.setAttribute('aria-label', ariaLabel);
      }
      this.onChange();
    }
  }, {
    key: "unregister",
    value: function unregister() {
      if (!this.jsoneditor) return;
      this.jsoneditor.unregisterEditor(this);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 12;
    }
  }, {
    key: "isActive",
    value: function isActive() {
      return this.active;
    }
  }, {
    key: "activate",
    value: function activate() {
      this.active = true;
      this.optInCheckbox.checked = true;
      this.enable();
      this.change();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      /* only non required properties can be deactivated. */
      if (!this.isRequired()) {
        this.active = false;
        this.optInCheckbox.checked = false;
        this.disable();
        this.change();
      }
    }
  }, {
    key: "registerDependencies",
    value: function registerDependencies() {
      var _this = this;
      this.dependenciesFulfilled = true;
      var deps = this.options.dependencies;
      if (!deps) {
        return;
      }
      Object.keys(deps).forEach(function (dependency) {
        var path;
        var isFullPath = dependency.startsWith(_this.jsoneditor.root.path);
        if (isFullPath) {
          path = dependency;
        } else {
          path = _this.path.split('.');
          path[path.length - 1] = dependency;
          path = path.join('.');
        }
        _this.jsoneditor.watch(path, function () {
          _this.evaluateDependencies();
        });
      });
    }
  }, {
    key: "evaluateDependencies",
    value: function evaluateDependencies() {
      var _this2 = this;
      var wrapper = this.container || this.control;
      if (!wrapper || this.jsoneditor === null) {
        return;
      }
      var deps = this.options.dependencies;
      if (!deps) {
        return;
      }

      // Assume true and set to false if any unmet dependencies are found
      var previousStatus = this.dependenciesFulfilled;
      this.dependenciesFulfilled = true;
      Object.keys(deps).forEach(function (dependency) {
        var path;
        var isFullPath = dependency.startsWith(_this2.jsoneditor.root.path);
        if (isFullPath) {
          path = dependency;
        } else {
          path = _this2.path.split('.');
          path[path.length - 1] = dependency;
          path = path.join('.');
        }
        var choices = deps[dependency];
        _this2.checkDependency(path, choices);
      });
      if (this.dependenciesFulfilled !== previousStatus) {
        this.notify();
      }
      var displayMode = this.dependenciesFulfilled ? 'block' : 'none';
      if (this.options.hidden) {
        displayMode = 'none';
      }
      if (wrapper.tagName === 'TD') {
        Object.keys(wrapper.childNodes).forEach(function (child) {
          return wrapper.childNodes[child].style.display = displayMode;
        });
      } else wrapper.style.display = displayMode;
    }
  }, {
    key: "checkDependency",
    value: function checkDependency(path, choices) {
      var _this3 = this;
      if (this.path === path || this.jsoneditor === null) {
        return;
      }
      var editor = this.jsoneditor.getEditor(path);
      var value = editor ? editor.getValue() : undefined;
      if (!editor || !editor.dependenciesFulfilled || !value) {
        this.dependenciesFulfilled = false;
      } else if (Array.isArray(choices)) {
        this.dependenciesFulfilled = choices.some(function (choice) {
          if (JSON.stringify(value) === JSON.stringify(choice)) {
            return true;
          }
        });
      } else if (_typeof(choices) === 'object') {
        if (_typeof(value) !== 'object') {
          this.dependenciesFulfilled = choices === value;
        } else {
          Object.keys(choices).some(function (key) {
            if (!(0,_utilities_js__WEBPACK_IMPORTED_MODULE_33__.hasOwnProperty)(choices, key)) {
              return false;
            }
            if (!(0,_utilities_js__WEBPACK_IMPORTED_MODULE_33__.hasOwnProperty)(value, key) || choices[key] !== value[key]) {
              _this3.dependenciesFulfilled = false;
              return true;
            }
          });
        }
      } else if (typeof choices === 'string' || typeof choices === 'number') {
        this.dependenciesFulfilled = this.dependenciesFulfilled && value === choices;
      } else if (typeof choices === 'boolean') {
        if (choices) {
          this.dependenciesFulfilled = this.dependenciesFulfilled && (value || value.length > 0);
        } else {
          this.dependenciesFulfilled = this.dependenciesFulfilled && (!value || value.length === 0);
        }
      }
    }
  }, {
    key: "setContainer",
    value: function setContainer(container) {
      this.container = container;
      this.setContainerAttributes();
      if (this.schema.id) this.container.setAttribute('data-schemaid', this.schema.id);
      if (this.schema.type && typeof this.schema.type === 'string') this.container.setAttribute('data-schematype', this.schema.type);
      this.container.setAttribute('data-schemapath', this.path);
    }
  }, {
    key: "setOptInCheckbox",
    value: function setOptInCheckbox() {
      var _this4 = this;
      var optIn;
      if (this.optInWidget === 'switch') {
        optIn = this.theme.getOptInSwitch(this.formname);
      } else {
        optIn = this.theme.getOptInCheckbox(this.formname);
      }
      this.optInCheckbox = optIn.checkbox;
      this.optInContainer = optIn.container;
      this.optInCheckbox.addEventListener('click', function () {
        if (_this4.isActive()) {
          _this4.deactivate();
        } else {
          _this4.activate();
        }
      });

      /* append active/deactive checkbox if show_opt_in is true */
      var globalOptIn = this.jsoneditor.options.show_opt_in;
      var parentOptInDefined = typeof this.parent.options.show_opt_in !== 'undefined';
      var parentOptInEnabled = parentOptInDefined && this.parent.options.show_opt_in === true;
      var parentOptInDisabled = parentOptInDefined && this.parent.options.show_opt_in === false;
      if (parentOptInEnabled || !parentOptInDisabled && globalOptIn || !parentOptInDefined && globalOptIn) {
        /* and control to type object editors if they are not required */
        if (this.parent && this.parent.schema.type === 'object' && !this.isRequired() && this.header) {
          this.header.insertBefore(this.optInContainer, this.header.firstChild);
          this.optInAppended = true;
        }
      }
    }
  }, {
    key: "preBuild",
    value: function preBuild() {}
  }, {
    key: "build",
    value: function build() {}
  }, {
    key: "postBuild",
    value: function postBuild() {
      this.setupWatchListeners();
      this.addLinks();
      this.register();
      this.setValue(this.getDefault(), true);
      this.updateHeaderText();
      this.onWatchedFieldChange();
      if (this.options.titleHidden) {
        this.theme.visuallyHidden(this.label);
        this.theme.visuallyHidden(this.header);
      }
      if (this.enforceConstEnabled && this.schema["const"]) {
        this.disable();
      }
    }
  }, {
    key: "setupWatchListeners",
    value: function setupWatchListeners() {
      var _this5 = this;
      /* Watched fields */
      this.watched = {};
      if (this.schema.vars) this.schema.watch = this.schema.vars;
      this.watched_values = {};
      this.watch_listener = function () {
        if (_this5.refreshWatchedFieldValues()) {
          _this5.onWatchedFieldChange();
        }
      };
      if ((0,_utilities_js__WEBPACK_IMPORTED_MODULE_33__.hasOwnProperty)(this.schema, 'watch')) {
        var path;
        var pathParts;
        var first;
        var root;
        var adjustedPath;
        var myPath = this.container.getAttribute('data-schemapath');
        Object.keys(this.schema.watch).forEach(function (name) {
          path = _this5.schema.watch[name];
          if (Array.isArray(path)) {
            if (path.length < 2) return;
            pathParts = [path[0]].concat(path[1].split('.'));
          } else {
            pathParts = path.split('.');
            if (!_this5.theme.closest(_this5.container, "[data-schemaid=\"".concat(pathParts[0], "\"]"))) pathParts.unshift('#');
          }
          first = pathParts.shift();
          if (first === '#') first = _this5.jsoneditor.schema.id || _this5.jsoneditor.root.formname;

          /* Find the root node for this template variable */
          root = _this5.theme.closest(_this5.container, "[data-schemaid=\"".concat(first, "\"]"));
          if (!root) throw new Error("Could not find ancestor node with id ".concat(first));

          /* Keep track of the root node and path for use when rendering the template */
          adjustedPath = "".concat(root.getAttribute('data-schemapath'), ".").concat(pathParts.join('.'));
          if (myPath.startsWith(adjustedPath)) _this5.watchLoop = true;
          _this5.jsoneditor.watch(adjustedPath, _this5.watch_listener);
          _this5.watched[name] = adjustedPath;
        });
      }

      /* Dynamic header */
      if (this.schema.headerTemplate) {
        this.header_template = this.jsoneditor.compileTemplate(this.schema.headerTemplate, this.template_engine);
      }
    }
  }, {
    key: "addLinks",
    value: function addLinks() {
      /* Add links */
      if (!this.no_link_holder) {
        this.link_holder = this.theme.getLinksHolder();
        /* if description element exists, insert the link before */
        if (typeof this.description !== 'undefined') this.description.parentNode.insertBefore(this.link_holder, this.description);
        /* otherwise just insert link at bottom of container */else this.container.appendChild(this.link_holder);
        if (this.schema.links) {
          for (var i = 0; i < this.schema.links.length; i++) {
            this.addLink(this.getLink(this.schema.links[i]));
          }
        }
      }
    }
  }, {
    key: "onMove",
    value: function onMove() {}
  }, {
    key: "getButton",
    value: function getButton(text, icon, title) {
      var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
      var btnClass = "json-editor-btn-".concat(icon);
      if (!this.iconlib) icon = null;else icon = this.iconlib.getIcon(icon);
      text = this.translate(text, args);
      title = this.translate(title, args);
      if (!icon && title) {
        text = title;
        title = null;
      }
      var btn = this.theme.getButton(text, icon, title);
      btn.classList.add(btnClass);
      return btn;
    }
  }, {
    key: "setButtonText",
    value: function setButtonText(button, text, icon, title) {
      var args = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
      if (!this.iconlib) icon = null;else icon = this.iconlib.getIcon(icon);
      text = this.translate(text, args);
      title = this.translate(title, args);
      if (!icon && title) {
        text = title;
        title = null;
      }
      return this.theme.setButtonText(button, text, icon, title);
    }
  }, {
    key: "addLink",
    value: function addLink(link) {
      if (this.link_holder) this.link_holder.appendChild(link);
    }
  }, {
    key: "getLink",
    value: function getLink(data) {
      var holder;
      var link;

      /* Get mime type of the link */
      var mime = data.mediaType || 'application/javascript';
      var type = mime.split('/')[0];

      /* Template to generate the link href */
      var href = this.jsoneditor.compileTemplate(data.href, this.template_engine);
      var relTemplate = this.jsoneditor.compileTemplate(data.rel ? data.rel : data.href, this.template_engine);

      /* Template to generate the link's download attribute */
      var download = null;
      if (data.download) download = data.download;
      if (download && download !== true) {
        download = this.jsoneditor.compileTemplate(download, this.template_engine);
      }

      /* Image links */
      if (type === 'image') {
        holder = this.theme.getBlockLinkHolder();
        link = document.createElement('a');
        link.setAttribute('target', '_blank');
        var image = document.createElement('img');
        this.theme.createImageLink(holder, link, image);

        /* When a watched field changes, update the url */
        this.link_watchers.push(function (vars) {
          var url = href(vars);
          var rel = relTemplate(vars);
          link.setAttribute('href', url);
          link.setAttribute('title', rel || url);
          image.setAttribute('src', url);
        });
        /* Audio/Video links */
      } else if (['audio', 'video'].includes(type)) {
        holder = this.theme.getBlockLinkHolder();
        link = this.theme.getBlockLink();
        link.setAttribute('target', '_blank');
        var media = document.createElement(type);
        media.setAttribute('controls', 'controls');
        this.theme.createMediaLink(holder, link, media);

        /* When a watched field changes, update the url */
        this.link_watchers.push(function (vars) {
          var url = href(vars);
          var rel = relTemplate(vars);
          link.setAttribute('href', url);
          link.textContent = rel || url;
          media.setAttribute('src', url);
        });
        /* Text links or blank link */
      } else {
        link = holder = this.theme.getBlockLink();
        holder.setAttribute('target', '_blank');
        holder.textContent = data.rel;
        holder.style.display = 'none'; /* Prevent blank links from showing up when using custom view */

        /* When a watched field changes, update the url */
        this.link_watchers.push(function (vars) {
          var url = href(vars);
          var rel = relTemplate(vars);
          if (url) holder.style.display = '';
          holder.setAttribute('href', url);
          holder.textContent = rel || url;
        });
      }
      if (download && link) {
        if (download === true) {
          link.setAttribute('download', '');
        } else {
          this.link_watchers.push(function (vars) {
            link.setAttribute('download', download(vars));
          });
        }
      }
      if (data["class"]) {
        var classNames = data["class"].split(' ');
        classNames.forEach(function (className) {
          link.classList.add(className);
        });
      }
      return holder;
    }
  }, {
    key: "refreshWatchedFieldValues",
    value: function refreshWatchedFieldValues() {
      var _this6 = this;
      if (!this.watched_values) return;
      var watched = {};
      var changed = false;
      if (this.watched) {
        Object.keys(this.watched).forEach(function (name) {
          var editor = _this6.jsoneditor.getEditor(_this6.watched[name]);
          var val = editor ? editor.getValue() : null;
          if (_this6.watched_values[name] !== val) changed = true;
          watched[name] = val;
        });
      }
      watched.self = this.getValue();
      if (this.watched_values.self !== watched.self) changed = true;
      this.watched_values = watched;
      return changed;
    }
  }, {
    key: "getWatchedFieldValues",
    value: function getWatchedFieldValues() {
      return this.watched_values;
    }
  }, {
    key: "updateHeaderText",
    value: function updateHeaderText() {
      if (this.header) {
        var headerText = this.getHeaderText();
        /* If the header has children, only update the text node's value */
        if (this.header.children.length) {
          for (var i = 0; i < this.header.childNodes.length; i++) {
            if (this.header.childNodes[i].nodeType === 3) {
              this.header.childNodes[i].nodeValue = this.cleanText(headerText);
              break;
            }
          }
          /* Otherwise, just update the entire node */
        } else {
          if (window.DOMPurify) this.header.innerHTML = window.DOMPurify.sanitize(headerText);else this.header.textContent = this.cleanText(headerText);
        }
      }
    }
  }, {
    key: "getHeaderText",
    value: function getHeaderText(titleOnly) {
      if (this.header_text) return this.header_text;else if (titleOnly) return this.translateProperty(this.schema.title);else return this.getTitle();
    }
  }, {
    key: "getPathDepth",
    value: function getPathDepth() {
      return this.path.split('.').length;
    }
  }, {
    key: "cleanText",
    value: function cleanText(txt) {
      /* Clean out HTML tags from txt */
      var tmp = document.createElement('div');
      tmp.innerHTML = txt;
      return tmp.textContent || tmp.innerText;
    }
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var _this7 = this;
      var vars;
      if (this.header_template) {
        vars = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_33__.extend)(this.getWatchedFieldValues(), {
          key: this.key,
          i: this.key,
          i0: this.key * 1,
          i1: this.key * 1 + 1,
          title: this.getTitle()
        });

        // object properties
        if (this.editors && Object.keys(this.editors).length) {
          vars.properties = {};
          Object.keys(this.editors).forEach(function (key) {
            var editor = _this7.editors[key];
            if (editor.schema && editor.schema["enum"] && editor.schema.options && editor.schema.options.enum_titles) {
              var enumIndex = editor.schema["enum"].indexOf(editor.value);
              var enumTitle = editor.options.enum_titles[enumIndex];
              vars.properties[key] = {
                enumTitle: enumTitle
              };
            }
          });
        }
        var headerText = this.header_template(vars);
        if (headerText !== this.header_text) {
          this.header_text = headerText;
          this.updateHeaderText();
          this.notify();
          /* this.fireChangeHeaderEvent(); */
        }
      }
      if (this.link_watchers.length) {
        vars = this.getWatchedFieldValues();
        for (var i = 0; i < this.link_watchers.length; i++) {
          this.link_watchers[i](vars);
        }
      }
    }
  }, {
    key: "setValue",
    value: function setValue(value) {
      value = this.applyConstFilter(value);
      this.value = value;
    }
  }, {
    key: "applyConstFilter",
    value: function applyConstFilter(value) {
      if (this.enforceConstEnabled && typeof this.schema["const"] !== 'undefined') {
        value = this.schema["const"];
      }
      return value;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      return this.value;
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {}
  }, {
    key: "getChildEditors",
    value: function getChildEditors() {
      return false;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var _this8 = this;
      this.unregister(this);
      if (this.watched) {
        Object.values(this.watched).forEach(function (adjustedPath) {
          return _this8.jsoneditor.unwatch(adjustedPath, _this8.watch_listener);
        });
      }
      this.watched = null;
      this.watched_values = null;
      this.watch_listener = null;
      this.header_text = null;
      this.header_template = null;
      this.value = null;
      if (this.container && this.container.parentNode) this.container.parentNode.removeChild(this.container);
      this.container = null;
      this.jsoneditor = null;
      this.schema = null;
      this.path = null;
      this.key = null;
      this.parent = null;
    }
  }, {
    key: "isDefaultRequired",
    value: function isDefaultRequired() {
      return this.isRequired() || !!this.jsoneditor.options.use_default_values;
    }
  }, {
    key: "getDefault",
    value: function getDefault() {
      if (this.enforceConstEnabled && this.schema["const"]) {
        return this.schema["const"];
      }
      if (typeof this.schema["default"] !== 'undefined') {
        return this.schema["default"];
      }
      if (typeof this.schema["enum"] !== 'undefined') {
        return this.schema["enum"][0];
      }
      var type = this.schema.type || this.schema.oneOf;
      if (type && Array.isArray(type)) type = type[0];
      if (type && _typeof(type) === 'object') type = type.type;
      if (type && Array.isArray(type)) type = type[0];
      if (typeof type === 'string') {
        if (type === 'number') return this.isDefaultRequired() ? 0.0 : undefined;
        if (type === 'boolean') return this.isDefaultRequired() ? false : undefined;
        if (type === 'integer') return this.isDefaultRequired() ? 0 : undefined;
        if (type === 'string') return this.isDefaultRequired() ? '' : undefined;
        if (type === 'null') return null;
        if (type === 'object') return {};
        if (type === 'array') return [];
      }
      return undefined;
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return this.translateProperty(this.schema.title || this.key || this.formname);
    }
  }, {
    key: "enable",
    value: function enable() {
      this.disabled = false;
    }
  }, {
    key: "disable",
    value: function disable() {
      this.disabled = true;
    }
  }, {
    key: "isEnabled",
    value: function isEnabled() {
      return !this.disabled;
    }
  }, {
    key: "isRequired",
    value: function isRequired() {
      if (typeof this.schema.required === 'boolean') return this.schema.required;else if (this.parent && this.parent.schema && Array.isArray(this.parent.schema.required)) return this.parent.schema.required.includes(this.key);else if (this.jsoneditor.options.required_by_default) return true;else return false;
    }
  }, {
    key: "getDisplayText",
    value: function getDisplayText(arr) {
      var disp = [];
      var used = {};

      /* Determine how many times each attribute name is used. */
      /* This helps us pick the most distinct display text for the schemas. */
      arr.forEach(function (el) {
        if (el.title) {
          used[el.title] = used[el.title] || 0;
          used[el.title]++;
        }
        if (el.description) {
          used[el.description] = used[el.description] || 0;
          used[el.description]++;
        }
        if (el.format) {
          used[el.format] = used[el.format] || 0;
          used[el.format]++;
        }
        if (el.type) {
          used[el.type] = used[el.type] || 0;
          used[el.type]++;
        }
      });

      /* Determine display text for each element of the array */
      arr.forEach(function (el) {
        var name;

        /* If it's a simple string */
        if (typeof el === 'string') name = el;
        /* Object */else if (el.title && used[el.title] <= 1) name = el.title;else if (el.format && used[el.format] <= 1) name = el.format;else if (el.type && used[el.type] <= 1) name = el.type;else if (el.description && used[el.description] <= 1) name = el.description;else if (el.title) name = el.title;else if (el.format) name = el.format;else if (el.type) name = el.type;else if (el.description) name = el.description;else if (JSON.stringify(el).length < 500) name = JSON.stringify(el);else name = 'type';
        disp.push(name);
      });

      /* Replace identical display text with "text 1", "text 2", etc. */
      var inc = {};
      disp.forEach(function (name, i) {
        inc[name] = inc[name] || 0;
        inc[name]++;
        if (used[name] > 1) disp[i] = "".concat(name, " ").concat(inc[name]);
      });
      return disp;
    }

    /* Replace space(s) with "-" to create valid id value */
  }, {
    key: "getValidId",
    value: function getValidId(id) {
      id = id === undefined ? '' : id.toString();
      return id.replace(/\s+/g, '-');
    }
  }, {
    key: "setInputAttributes",
    value: function setInputAttributes(inputAttribute, input) {
      if (this.schema.options && this.schema.options.inputAttributes) {
        var inputAttributes = this.schema.options.inputAttributes;
        var protectedAttributes = ['name', 'type'].concat(inputAttribute);
        var workingInput = input || this.input;
        Object.keys(inputAttributes).forEach(function (key) {
          if (!protectedAttributes.includes(key.toLowerCase())) {
            workingInput.setAttribute(key, inputAttributes[key]);
          }
        });
      }
    }
  }, {
    key: "setContainerAttributes",
    value: function setContainerAttributes() {
      var _this9 = this;
      if (this.schema.options && this.schema.options.containerAttributes) {
        var containerAttributes = this.schema.options.containerAttributes;
        var protectedAttributes = ['data-schemapath', 'data-schematype', 'data-schemaid'];
        Object.keys(containerAttributes).forEach(function (key) {
          if (!protectedAttributes.includes(key.toLowerCase())) {
            _this9.container.setAttribute(key, containerAttributes[key]);
          }
        });
      }
    }
  }, {
    key: "expandCallbacks",
    value: function expandCallbacks(scope, options) {
      var _this10 = this;
      var callback = this.defaults.callbacks[scope];
      Object.entries(options).forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];
        if (value === Object(value)) {
          options[key] = _this10.expandCallbacks(scope, value);
        } else if (typeof value === 'string' && _typeof(callback) === 'object' && typeof callback[value] === 'function') {
          options[key] = callback[value].bind(null, _this10);
        }
      });
      return options;
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {}
  }]);
}();

/***/ }),

/***/ "./src/editors/ace.js":
/*!****************************!*\
  !*** ./src/editors/ace.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AceEditor: () => (/* binding */ AceEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var AceEditor = /*#__PURE__*/function (_StringEditor) {
  function AceEditor() {
    _classCallCheck(this, AceEditor);
    return _callSuper(this, AceEditor, arguments);
  }
  _inherits(AceEditor, _StringEditor);
  return _createClass(AceEditor, [{
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      var res = _get(_getPrototypeOf(AceEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
      if (res !== undefined && res.changed && this.ace_editor_instance) {
        this.ace_editor_instance.setValue(res.value);
        this.ace_editor_instance.session.getSelection().clearSelection();
        this.ace_editor_instance.resize();
      }
    }
  }, {
    key: "build",
    value: function build() {
      this.options.format = 'textarea'; /* Force format into "textarea" */
      _get(_getPrototypeOf(AceEditor.prototype), "build", this).call(this);
      this.input_type = this.schema.format; /* Restore original format */
      this.input.setAttribute('data-schemaformat', this.input_type);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.ace) {
        var mode = this.input_type;
        /* aliases for c/cpp */
        if (mode === 'cpp' || mode === 'c++' || mode === 'c') mode = 'c_cpp';

        /* Get options, either global options from "this.defaults.options.ace" or */
        /* single property options from schema "options.ace" */
        options = this.expandCallbacks('ace', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.extend)({}, {
          selectionStyle: 'text',
          minLines: 30,
          maxLines: 30
        }, this.defaults.options.ace || {}, this.options.ace || {}, {
          mode: "ace/mode/".concat(mode)
        }));
        this.ace_container = document.createElement('div');
        this.ace_container.style.width = '100%';
        this.ace_container.style.position = 'relative';
        /* this.ace_container.style.height = '400px'; */
        this.input.parentNode.insertBefore(this.ace_container, this.input);
        this.input.style.display = 'none';
        this.ace_editor_instance = window.ace.edit(this.ace_container, options);
        this.ace_editor_instance.setValue(this.getValue());
        this.ace_editor_instance.session.getSelection().clearSelection();
        this.ace_editor_instance.resize();
        if (this.schema.readOnly || this.schema.readonly || this.schema.template) {
          this.ace_editor_instance.setReadOnly(true);
        }

        /* Listen for changes */
        this.ace_editor_instance.on('change', function () {
          _this.input.value = _this.ace_editor_instance.getValue();
          _this.refreshValue();
          _this.is_dirty = true;
          _this.onChange(true);
        });
        this.theme.afterInputReady(this.input);
      } else _get(_getPrototypeOf(AceEditor.prototype), "afterInputReady", this).call(this); /* Library not loaded, so just treat this as a string */
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 6;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.ace_editor_instance) this.ace_editor_instance.setReadOnly(false);
      _get(_getPrototypeOf(AceEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.ace_editor_instance) this.ace_editor_instance.setReadOnly(true);
      _get(_getPrototypeOf(AceEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.ace_editor_instance) {
        this.ace_editor_instance.destroy();
        this.ace_editor_instance = null;
      }
      _get(_getPrototypeOf(AceEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_18__.StringEditor);

/***/ }),

/***/ "./src/editors/array.css.js":
/*!**********************************!*\
  !*** ./src/editors/array.css.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ".json-editor-btntype-toggle": "margin:0%2010px%200%200",
  ".je-array-control-btn": "width:100%25;text-align:left;margin-bottom:3px"
});
/* eslint-enable */

/***/ }),

/***/ "./src/editors/array.js":
/*!******************************!*\
  !*** ./src/editors/array.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrayEditor: () => (/* binding */ ArrayEditor),
/* harmony export */   supportDragDrop: () => (/* binding */ supportDragDrop)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.find.js */ "./node_modules/core-js/modules/es.array.find.js");
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.array.some.js */ "./node_modules/core-js/modules/es.array.some.js");
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
/* harmony import */ var _array_css_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./array.css.js */ "./src/editors/array.css.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






























function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }



var ArrayEditor = /*#__PURE__*/function (_AbstractEditor) {
  function ArrayEditor() {
    _classCallCheck(this, ArrayEditor);
    return _callSuper(this, ArrayEditor, arguments);
  }
  _inherits(ArrayEditor, _AbstractEditor);
  return _createClass(ArrayEditor, [{
    key: "askConfirmation",
    value: function askConfirmation() {
      if (this.jsoneditor.options.prompt_before_delete === true) {
        if (window.confirm(this.translate('button_delete_node_warning')) === false) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(ArrayEditor.prototype), "register", this).call(this);
      if (this.rows) {
        this.rows.forEach(function (row) {
          return row.register();
        });
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(ArrayEditor.prototype), "unregister", this).call(this);
      if (this.rows) {
        this.rows.forEach(function (row) {
          return row.unregister();
        });
      }
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      var info = this.getItemInfo(0);
      /* Tabs require extra horizontal space */
      if (this.tabs_holder && this.schema.format !== 'tabs-top') {
        return Math.max(Math.min(12, info.width + 2), 4);
      }
      return info.width;
    }
  }, {
    key: "enable",
    value: function enable() {
      var _this = this;
      if (!this.always_disabled) {
        this.setAvailability(this, false);
        if (this.rows) {
          this.rows.forEach(function (row) {
            row.enable();
            _this.setAvailability(row, false);
          });
        }
        _get(_getPrototypeOf(ArrayEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      var _this2 = this;
      if (alwaysDisabled) this.always_disabled = true;
      this.setAvailability(this, true);
      if (this.rows) {
        this.rows.forEach(function (row) {
          row.disable(alwaysDisabled);
          _this2.setAvailability(row, true);
        });
      }
      _get(_getPrototypeOf(ArrayEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "setAvailability",
    value: function setAvailability(element, val) {
      if (element.add_row_button) element.add_row_button.disabled = val;
      if (element.remove_all_rows_button) element.remove_all_rows_button.disabled = val;
      if (element.delete_last_row_button) element.delete_last_row_button.disabled = val;
      if (element.copy_button) element.copy_button.disabled = val;
      if (element.delete_button) element.delete_button.disabled = val;
      if (element.moveup_button) element.moveup_button.disabled = val;
      if (element.movedown_button) element.movedown_button.disabled = val;
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      _get(_getPrototypeOf(ArrayEditor.prototype), "preBuild", this).call(this);
      this.rows = [];
      this.row_cache = [];
      this.hide_delete_buttons = this.options.disable_array_delete || this.jsoneditor.options.disable_array_delete;
      this.hide_delete_all_rows_buttons = this.hide_delete_buttons || this.options.disable_array_delete_all_rows || this.jsoneditor.options.disable_array_delete_all_rows;
      this.hide_delete_last_row_buttons = this.hide_delete_buttons || this.options.disable_array_delete_last_row || this.jsoneditor.options.disable_array_delete_last_row;
      this.hide_move_buttons = this.options.disable_array_reorder || this.jsoneditor.options.disable_array_reorder;
      this.hide_add_button = this.options.disable_array_add || this.jsoneditor.options.disable_array_add;
      this.show_copy_button = this.options.enable_array_copy || this.jsoneditor.options.enable_array_copy;
      this.array_controls_top = this.options.array_controls_top || this.jsoneditor.options.array_controls_top;
    }
  }, {
    key: "build",
    value: function build() {
      if (!this.options.compact) {
        this.header = document.createElement('span');
        this.header.textContent = this.getTitle();
        this.title = this.theme.getHeader(this.header, this.getPathDepth());
        this.container.appendChild(this.title);
        if (this.options.infoText) {
          this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
          this.container.appendChild(this.infoButton);
        }
        this.title_controls = this.theme.getHeaderButtonHolder();
        this.title.appendChild(this.title_controls);
        if (this.schema.description) {
          this.description = this.theme.getDescription(this.translateProperty(this.schema.description));
          this.container.appendChild(this.description);
        }
        this.error_holder = document.createElement('div');
        this.container.appendChild(this.error_holder);
        if (this.schema.format === 'tabs-top') {
          this.controls = this.theme.getHeaderButtonHolder();
          this.title.appendChild(this.controls);
          this.tabs_holder = this.theme.getTopTabHolder(this.getValidId(this.getItemTitle()));
          this.container.appendChild(this.tabs_holder);
          this.row_holder = this.theme.getTopTabContentHolder(this.tabs_holder);
          this.active_tab = null;
        } else if (this.schema.format === 'tabs') {
          this.controls = this.theme.getHeaderButtonHolder();
          this.title.appendChild(this.controls);
          this.tabs_holder = this.theme.getTabHolder(this.getValidId(this.getItemTitle()));
          this.container.appendChild(this.tabs_holder);
          this.row_holder = this.theme.getTabContentHolder(this.tabs_holder);
          this.active_tab = null;
        } else {
          this.panel = this.theme.getIndentedPanel();
          this.container.appendChild(this.panel);
          this.row_holder = document.createElement('div');
          this.panel.appendChild(this.row_holder);
          this.controls = this.theme.getButtonHolder();
          if (this.array_controls_top) {
            this.title.appendChild(this.controls);
          } else {
            this.panel.appendChild(this.controls);
          }
        }
      } else {
        /* compact mode */
        this.title = this.theme.getHeader('', this.getPathDepth());
        this.container.appendChild(this.title);
        this.panel = this.theme.getIndentedPanel();
        this.container.appendChild(this.panel);
        this.title_controls = this.theme.getHeaderButtonHolder();
        this.title.appendChild(this.title_controls);
        this.controls = this.theme.getHeaderButtonHolder();
        this.title.appendChild(this.controls);
        this.row_holder = document.createElement('div');
        this.panel.appendChild(this.row_holder);
      }

      /* Add controls */
      this.addControls();
    }
  }, {
    key: "postBuild",
    value: function postBuild() {
      _get(_getPrototypeOf(ArrayEditor.prototype), "postBuild", this).call(this);
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable();
      }
    }
  }, {
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      this.refreshValue();
      this.refreshTabs(true);
      this.is_dirty = true;
      _get(_getPrototypeOf(ArrayEditor.prototype), "onChildEditorChange", this).call(this, editor, eventData);
    }
  }, {
    key: "getItemTitle",
    value: function getItemTitle() {
      if (!this.item_title) {
        if (this.schema.items && !Array.isArray(this.schema.items)) {
          var tmp = this.jsoneditor.expandRefs(this.schema.items);
          this.item_title = this.translateProperty(tmp.title) || this.translate('default_array_item_title');
        } else {
          this.item_title = this.translate('default_array_item_title');
        }
      }
      return this.cleanText(this.item_title);
    }
  }, {
    key: "getItemSchema",
    value: function getItemSchema(i) {
      if (Array.isArray(this.schema.items)) {
        if (i >= this.schema.items.length) {
          if (this.schema.additionalItems === true) {
            return {};
          } else if (this.schema.additionalItems) {
            return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.extend)({}, this.schema.additionalItems);
          }
        } else {
          return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.extend)({}, this.schema.items[i]);
        }
      } else if (this.schema.items) {
        return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.extend)({}, this.schema.items);
      } else {
        return {};
      }
    }
  }, {
    key: "getItemInfo",
    value: function getItemInfo(i) {
      var schema = this.getItemSchema(i);

      /* Check if it's cached */
      this.item_info = this.item_info || {};
      var stringified = JSON.stringify(schema);
      if (typeof this.item_info[stringified] !== 'undefined') return this.item_info[stringified];

      /* Get the schema for this item */
      schema = this.jsoneditor.expandRefs(schema);
      this.item_info[stringified] = {
        title: this.translateProperty(schema.title) || this.translate('default_array_item_title'),
        "default": schema["default"],
        width: 12,
        child_editors: schema.properties || schema.items
      };
      return this.item_info[stringified];
    }
  }, {
    key: "getElementEditor",
    value: function getElementEditor(i) {
      var itemInfo = this.getItemInfo(i);
      var schema = this.getItemSchema(i);
      schema = this.jsoneditor.expandRefs(schema);
      schema.title = "".concat(itemInfo.title, " ").concat(i + 1);
      var editor = this.jsoneditor.getEditorClass(schema);
      var holder;
      if (this.tabs_holder) {
        if (this.schema.format === 'tabs-top') {
          holder = this.theme.getTopTabContent();
        } else {
          holder = this.theme.getTabContent();
        }
        holder.id = "".concat(this.path, ".").concat(i);
      } else if (itemInfo.child_editors) {
        holder = this.theme.getChildEditorHolder();
      } else {
        holder = this.theme.getIndentedPanel();
      }
      this.row_holder.appendChild(holder);
      var ret = this.jsoneditor.createEditor(editor, {
        jsoneditor: this.jsoneditor,
        schema: schema,
        container: holder,
        path: "".concat(this.path, ".").concat(i),
        parent: this,
        required: true
      });
      ret.preBuild();
      ret.build();
      ret.postBuild();
      if (!ret.title_controls) {
        ret.array_controls = this.theme.getButtonHolder();
        holder.appendChild(ret.array_controls);
      }
      return ret;
    }
  }, {
    key: "checkParent",
    value: function checkParent(elem) {
      return elem && elem.parentNode;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.empty(true);
      if (this.checkParent(this.title)) this.title.parentNode.removeChild(this.title);
      if (this.checkParent(this.description)) this.description.parentNode.removeChild(this.description);
      if (this.checkParent(this.row_holder)) this.row_holder.parentNode.removeChild(this.row_holder);
      if (this.checkParent(this.controls)) this.controls.parentNode.removeChild(this.controls);
      if (this.checkParent(this.panel)) this.panel.parentNode.removeChild(this.panel);
      this.rows = this.row_cache = this.title = this.description = this.row_holder = this.panel = this.controls = null;
      _get(_getPrototypeOf(ArrayEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "empty",
    value: function empty(hard) {
      var _this3 = this;
      if (this.rows === null) return;
      this.rows.forEach(function (row, i) {
        if (hard) {
          if (_this3.checkParent(row.tab)) row.tab.parentNode.removeChild(row.tab);
          _this3.destroyRow(row, true);
          _this3.row_cache[i] = null;
        }
        _this3.rows[i] = null;
      });
      if (hard) {
        for (var j = this.rows.length; j < this.row_cache.length; j++) {
          this.destroyRow(this.row_cache[j], true);
          this.row_cache[j] = null;
        }
      }
      this.rows = [];
      if (hard) this.row_cache = [];
    }
  }, {
    key: "destroyRow",
    value: function destroyRow(row, hard) {
      var holder = row.container;
      if (hard) {
        row.destroy();
        if (holder.parentNode) holder.parentNode.removeChild(holder);
        if (this.checkParent(row.tab)) row.tab.parentNode.removeChild(row.tab);
      } else {
        if (row.tab) row.tab.style.display = 'none';
        holder.style.display = 'none';
        row.unregister();
      }
    }
  }, {
    key: "getMax",
    value: function getMax() {
      if (Array.isArray(this.schema.items) && this.schema.additionalItems === false) {
        return Math.min(this.schema.items.length, this.schema.maxItems || Infinity);
      }
      return this.schema.maxItems || Infinity;
    }
  }, {
    key: "refreshTabs",
    value: function refreshTabs(refreshHeaders) {
      var _this4 = this;
      this.rows.forEach(function (row) {
        if (!row.tab) return;
        if (refreshHeaders) {
          row.tab_text.textContent = row.getHeaderText();
        } else if (row.tab === _this4.active_tab) {
          _this4.theme.markTabActive(row);
        } else {
          _this4.theme.markTabInactive(row);
        }
      });
    }
  }, {
    key: "ensureArraySize",
    value: function ensureArraySize(value) {
      if (!Array.isArray(value)) value = [value];
      if (this.schema.minItems) {
        while (value.length < this.schema.minItems) {
          value.push(this.getItemInfo(value.length)["default"]);
        }
      }
      if (this.getMax() && value.length > this.getMax()) {
        value = value.slice(0, this.getMax());
      }
      return value;
    }
  }, {
    key: "setValue",
    value: function setValue() {
      var _this5 = this;
      var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var initial = arguments.length > 1 ? arguments[1] : undefined;
      value = this.applyConstFilter(value);
      /* Make sure value has between minItems and maxItems items in it */
      value = this.ensureArraySize(value);
      var serialized = JSON.stringify(value);
      if (serialized === this.serialized) {
        if (initial) {
          this.refreshValue(initial);
        }
        return;
      }
      value.forEach(function (val, i) {
        if (_this5.rows[i]) {
          /* TODO: don't set the row's value if it hasn't changed */
          _this5.rows[i].setValue(val, initial);
        } else if (_this5.row_cache[i]) {
          _this5.rows[i] = _this5.row_cache[i];
          _this5.rows[i].setValue(val, initial);
          _this5.rows[i].container.style.display = '';
          if (_this5.rows[i].tab) _this5.rows[i].tab.style.display = '';
          _this5.rows[i].register();
          _this5.jsoneditor.trigger('addRow', _this5.rows[i]);
        } else {
          var editor = _this5.addRow(val, initial);
          _this5.jsoneditor.trigger('addRow', editor);
        }
      });
      for (var j = value.length; j < this.rows.length; j++) {
        this.destroyRow(this.rows[j]);
        this.rows[j] = null;
      }
      this.rows = this.rows.slice(0, value.length);

      /* Set the active tab */
      var row = this.rows.find(function (row) {
        return row.tab === _this5.active_tab;
      });
      var newActiveTab = typeof row !== 'undefined' ? row.tab : null;
      if (!newActiveTab && this.rows.length) newActiveTab = this.rows[0].tab;
      this.active_tab = newActiveTab;
      this.refreshValue(initial);
      this.refreshTabs(true);
      this.refreshTabs();
      this.onChange();

      /* TODO: sortable */
    }
  }, {
    key: "setButtonState",
    value: function setButtonState(element, display) {
      var buttonStateMode = this.options.button_state_mode || this.jsoneditor.options.button_state_mode;
      switch (buttonStateMode) {
        case 1:
          element.style.display = display ? '' : 'none';
          break;
        case 2:
          element.disabled = !display;
          break;
        default:
          element.style.display = display ? '' : 'none';
      }
    }
  }, {
    key: "setupButtons",
    value: function setupButtons(minItems) {
      var controlsNeeded = [];
      if (!this.value.length) {
        this.setButtonState(this.delete_last_row_button, false);
        this.setButtonState(this.remove_all_rows_button, false);
      } else if (this.value.length === 1) {
        this.setButtonState(this.remove_all_rows_button, false);

        /* If there are minItems items in the array, or configured to hide the delete_last_row button, hide the delete button beneath the rows */
        var _display = !(minItems || this.hide_delete_last_row_buttons);
        this.setButtonState(this.delete_last_row_button, _display);
        controlsNeeded.push(_display);
      } else {
        var display1 = !(minItems || this.hide_delete_last_row_buttons);
        this.setButtonState(this.delete_last_row_button, display1);
        controlsNeeded.push(display1);
        var display2 = !(minItems || this.hide_delete_all_rows_buttons);
        this.setButtonState(this.remove_all_rows_button, display2);
        controlsNeeded.push(display2);
      }

      /* If there are maxItems in the array, hide the add button beneath the rows */
      var display = !(this.getMax() && this.getMax() <= this.rows.length || this.hide_add_button);
      this.setButtonState(this.add_row_button, display);
      controlsNeeded.push(display);
      return controlsNeeded.some(function (e) {
        return e;
      });
    }
  }, {
    key: "refreshValue",
    value: function refreshValue(force) {
      var _this6 = this;
      var oldi = this.value ? this.value.length : 0;
      /* Get the value for this editor */
      this.value = this.rows.map(function (editor) {
        return editor.getValue();
      });
      if (oldi !== this.value.length || force) {
        /* If we currently have minItems items in the array */
        var minItems = this.schema.minItems && this.schema.minItems >= this.rows.length;
        this.rows.forEach(function (editor, i) {
          /* Hide the move down button for the last row */
          if (editor.movedown_button) {
            var display = i !== _this6.rows.length - 1;
            _this6.setButtonState(editor.movedown_button, display);
          }

          /* Hide the delete button if we have minItems items */
          if (editor.delete_button) {
            _this6.setButtonState(editor.delete_button, !minItems);
          }

          /* Get the value for this editor */
          _this6.value[i] = editor.getValue();
        });
        if (this.setupButtons(minItems) && !this.collapsed) {
          this.controls.style.display = 'inline-block';
        } else {
          this.controls.style.display = 'none';
        }
      }
      this.serialized = JSON.stringify(this.value);
    }
  }, {
    key: "addRow",
    value: function addRow(value, initial) {
      var _this7 = this;
      var i = this.rows.length;
      this.rows[i] = this.getElementEditor(i);
      this.row_cache[i] = this.rows[i];
      if (this.tabs_holder) {
        this.rows[i].tab_text = document.createElement('span');
        this.rows[i].tab_text.textContent = this.rows[i].getHeaderText();
        if (this.schema.format === 'tabs-top') {
          this.rows[i].tab = this.theme.getTopTab(this.rows[i].tab_text, this.getValidId(this.rows[i].path));
          this.theme.addTopTab(this.tabs_holder, this.rows[i].tab);
        } else {
          this.rows[i].tab = this.theme.getTab(this.rows[i].tab_text, this.getValidId(this.rows[i].path));
          this.theme.addTab(this.tabs_holder, this.rows[i].tab);
        }
        this.rows[i].tab.addEventListener('click', function (e) {
          _this7.active_tab = _this7.rows[i].tab;
          _this7.refreshTabs();
          e.preventDefault();
          e.stopPropagation();
        });
        this._supportDragDrop(this.rows[i].tab);
      } else {
        this._supportDragDrop(this.rows[i].container, true);
      }
      var controlsHolder = this.rows[i].title_controls || this.rows[i].array_controls;

      /* Buttons to delete row, move row up, and move row down */
      if (!this.hide_delete_buttons) {
        this.rows[i].delete_button = this._createDeleteButton(i, controlsHolder);
      }

      /* Button to copy an array element and add it as last element */
      if (this.show_copy_button) {
        this.rows[i].copy_button = this._createCopyButton(i, controlsHolder);
      }
      if (i && !this.hide_move_buttons) {
        this.rows[i].moveup_button = this._createMoveUpButton(i, controlsHolder);
      }
      if (!this.hide_move_buttons) {
        this.rows[i].movedown_button = this._createMoveDownButton(i, controlsHolder);
      }
      if (typeof value !== 'undefined') this.rows[i].setValue(value, initial);
      this.refreshTabs();
      return this.rows[i];
    }
  }, {
    key: "_createDeleteButton",
    value: function _createDeleteButton(i, holder) {
      var _this8 = this;
      var button = this.getButton(this.getItemTitle(), 'delete', 'button_delete_row_title', [this.getItemTitle()]);
      button.classList.add('delete', 'json-editor-btntype-delete');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this8.askConfirmation()) {
          return false;
        }
        var i = e.currentTarget.getAttribute('data-i') * 1;
        var newval = _this8.getValue().filter(function (row, j) {
          return j !== i;
        });
        var newActiveTab = null;
        var editor = _this8.rows[i];
        var editorValue = editor.getValue();
        _this8.setValue(newval);
        if (_this8.rows[i]) {
          newActiveTab = _this8.rows[i].tab;
        } else if (_this8.rows[i - 1]) {
          newActiveTab = _this8.rows[i - 1].tab;
        }
        if (newActiveTab) {
          _this8.active_tab = newActiveTab;
          _this8.refreshTabs();
        }
        _this8.onChange(true);
        _this8.jsoneditor.trigger('deleteRow', editorValue);
      });
      if (holder) {
        holder.appendChild(button);
      }
      return button;
    }
  }, {
    key: "_createCopyButton",
    value: function _createCopyButton(i, holder) {
      var _this9 = this;
      var button = this.getButton(this.getItemTitle(), 'copy', 'button_copy_row_title', [this.getItemTitle()]);
      var schema = this.schema;
      button.classList.add('copy', 'json-editor-btntype-copy');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        var value = _this9.getValue();
        e.preventDefault();
        e.stopPropagation();
        var i = e.currentTarget.getAttribute('data-i') * 1;
        value.forEach(function (row, j) {
          if (j === i) {
            /* Force generation of new UUID if the item has been cloned. */
            if (schema.items.type === 'string' && schema.items.format === 'uuid') {
              row = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.generateUUID)();
            } else if (schema.items.type === 'object' && schema.items.properties) {
              for (var _i = 0, _Object$keys = Object.keys(row); _i < _Object$keys.length; _i++) {
                var key = _Object$keys[_i];
                if (schema.items.properties && schema.items.properties[key] && schema.items.properties[key].format === 'uuid') {
                  row[key] = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.generateUUID)();
                }
              }
            }
            value.push(row);
          }
        });
        _this9.setValue(value);
        _this9.refreshValue(true);
        _this9.onChange(true);
        _this9.jsoneditor.trigger('copyRow', _this9.rows[i - 1]);
      });
      holder.appendChild(button);
      return button;
    }
  }, {
    key: "_createMoveUpButton",
    value: function _createMoveUpButton(i, holder) {
      var _this10 = this;
      var button = this.getButton('', this.schema.format === 'tabs-top' ? 'moveleft' : 'moveup', 'button_move_up_title');
      button.classList.add('moveup', 'json-editor-btntype-move');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var i = e.currentTarget.getAttribute('data-i') * 1;
        if (i <= 0) return;
        var rows = _this10.getValue();
        var tmp = rows[i - 1];
        rows[i - 1] = rows[i];
        rows[i] = tmp;
        _this10.setValue(rows);
        _this10.active_tab = _this10.rows[i - 1].tab;
        _this10.refreshTabs();
        _this10.onChange(true);
        _this10.jsoneditor.trigger('moveRow', _this10.rows[i - 1]);
      });
      if (holder) {
        holder.appendChild(button);
      }
      return button;
    }
  }, {
    key: "_createMoveDownButton",
    value: function _createMoveDownButton(i, holder) {
      var _this11 = this;
      var button = this.getButton('', this.schema.format === 'tabs-top' ? 'moveright' : 'movedown', 'button_move_down_title');
      button.classList.add('movedown', 'json-editor-btntype-move');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var i = e.currentTarget.getAttribute('data-i') * 1;
        var rows = _this11.getValue();
        if (i >= rows.length - 1) return;
        var tmp = rows[i + 1];
        rows[i + 1] = rows[i];
        rows[i] = tmp;
        _this11.setValue(rows);
        _this11.active_tab = _this11.rows[i + 1].tab;
        _this11.refreshTabs();
        _this11.onChange(true);
        _this11.jsoneditor.trigger('moveRow', _this11.rows[i + 1]);
      });
      if (holder) {
        holder.appendChild(button);
      }
      return button;
    }
  }, {
    key: "_supportDragDrop",
    value: function _supportDragDrop(tab, useTrigger) {
      var _this12 = this;
      supportDragDrop(tab, function (i, j) {
        var rows = _this12.getValue();
        var tmp = rows[i];
        rows.splice(i, 1);
        rows.splice(j, 0, tmp);
        _this12.setValue(rows);
        _this12.active_tab = _this12.rows[j].tab;
        _this12.refreshTabs();
        _this12.onChange(true);
        _this12.jsoneditor.trigger('moveRow', _this12.rows[j]);
      }, {
        useTrigger: useTrigger
      });
    }
  }, {
    key: "addControls",
    value: function addControls() {
      this.collapsed = false;
      this.toggle_button = this._createToggleButton();

      /* If it should start collapsed */
      if (this.options.collapsed) {
        (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.trigger)(this.toggle_button, 'click');
      }

      /* Collapse button disabled */
      if (this.schema.options && typeof this.schema.options.disable_collapse !== 'undefined') {
        if (this.schema.options.disable_collapse) this.toggle_button.style.display = 'none';
      } else if (this.jsoneditor.options.disable_collapse) {
        this.toggle_button.style.display = 'none';
      }

      /* Add "new row" and "delete last" buttons below editor */
      this.add_row_button = this._createAddRowButton();
      this.delete_last_row_button = this._createDeleteLastRowButton();
      this.remove_all_rows_button = this._createRemoveAllRowsButton();
      if (this.tabs) {
        this.add_row_button.classList.add('je-array-control-btn');
        this.delete_last_row_button.classList.add('je-array-control-btn');
        this.remove_all_rows_button.classList.add('je-array-control-btn');
      }
    }
  }, {
    key: "_createToggleButton",
    value: function _createToggleButton() {
      var _this13 = this;
      var button = this.getButton('', 'collapse', 'button_collapse');
      button.classList.add('json-editor-btntype-toggle');
      this.title.insertBefore(button, this.title.childNodes[0]);
      var rowHolderDisplay = this.row_holder.style.display;
      var controlsDisplay = this.controls.style.display;
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (_this13.panel) _this13.setButtonState(_this13.panel, _this13.collapsed);
        if (_this13.tabs_holder) _this13.setButtonState(_this13.tabs_holder, _this13.collapsed);
        if (_this13.collapsed) {
          _this13.collapsed = false;
          _this13.row_holder.style.display = rowHolderDisplay;
          _this13.controls.style.display = controlsDisplay;
          _this13.setButtonText(e.currentTarget, '', 'collapse', 'button_collapse');
        } else {
          _this13.collapsed = true;
          _this13.row_holder.style.display = 'none';
          _this13.controls.style.display = 'none';
          _this13.setButtonText(e.currentTarget, '', 'expand', 'button_expand');
        }
      });
      return button;
    }
  }, {
    key: "_createAddRowButton",
    value: function _createAddRowButton() {
      var _this14 = this;
      var button = this.getButton(this.getItemTitle(), 'add', 'button_add_row_title', [this.getItemTitle()]);
      button.classList.add('json-editor-btntype-add');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var i = _this14.rows.length;
        var editor;
        if (_this14.row_cache[i]) {
          editor = _this14.rows[i] = _this14.row_cache[i];
          _this14.rows[i].setValue(_this14.rows[i].getDefault(), true);
          // override cached value, so optional properties are not checked.
          if (typeof _this14.rows[i].deactivateNonRequiredProperties === 'function') {
            _this14.rows[i].deactivateNonRequiredProperties(true);
          }
          _this14.rows[i].container.style.display = '';
          if (_this14.rows[i].tab) _this14.rows[i].tab.style.display = '';
          _this14.rows[i].register();
        } else {
          editor = _this14.addRow();
        }
        _this14.active_tab = _this14.rows[i].tab;
        _this14.refreshTabs();
        _this14.refreshValue();
        _this14.onChange(true);
        _this14.jsoneditor.trigger('addRow', editor);
      });
      this.controls.appendChild(button);
      return button;
    }
  }, {
    key: "_createDeleteLastRowButton",
    value: function _createDeleteLastRowButton() {
      var _this15 = this;
      var button = this.getButton('button_delete_last', 'subtract', 'button_delete_last_title', [this.getItemTitle()]);
      button.classList.add('json-editor-btntype-deletelast');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this15.askConfirmation()) {
          return false;
        }
        var rows = _this15.getValue();
        var newActiveTab = null;
        var editorValue = rows.pop();
        _this15.setValue(rows);
        if (_this15.rows[_this15.rows.length - 1]) {
          newActiveTab = _this15.rows[_this15.rows.length - 1].tab;
        }
        if (newActiveTab) {
          _this15.active_tab = newActiveTab;
          _this15.refreshTabs();
        }
        _this15.onChange(true);
        _this15.jsoneditor.trigger('deleteRow', editorValue);
      });
      this.controls.appendChild(button);
      return button;
    }
  }, {
    key: "_createRemoveAllRowsButton",
    value: function _createRemoveAllRowsButton() {
      var _this16 = this;
      var button = this.getButton('button_delete_all', 'delete', 'button_delete_all_title');
      button.classList.add('json-editor-btntype-deleteall');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this16.askConfirmation()) {
          return false;
        }
        var values = _this16.getValue();
        _this16.empty(true);
        _this16.setValue([]);
        _this16.onChange(true);
        _this16.jsoneditor.trigger('deleteAllRows', values);
      });
      this.controls.appendChild(button);
      return button;
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this17 = this;
      /* Get all the errors that pertain to this editor */
      var myErrors = [];
      var otherErrors = [];
      errors.forEach(function (error) {
        if (error.path === _this17.path) {
          myErrors.push(error);
        } else {
          otherErrors.push(error);
        }
      });

      /* Show errors for this editor */
      if (this.error_holder) {
        if (myErrors.length) {
          this.error_holder.innerHTML = '';
          this.error_holder.style.display = '';
          myErrors.forEach(function (error) {
            _this17.error_holder.appendChild(_this17.theme.getErrorMessage(error.message));
          });
          /* Hide error area */
        } else {
          this.error_holder.style.display = 'none';
        }
      }

      /* Show errors for child editors */
      this.rows.forEach(function (row) {
        return row.showValidationErrors(otherErrors);
      });
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_30__.AbstractEditor);
ArrayEditor.rules = _array_css_js__WEBPACK_IMPORTED_MODULE_32__["default"];

// drag/drop array item to adjust order
// handler(fromIdx, toIdx, fromDom, toDom), opt={useTrigger}
// useTrigger=true: pressing ctrl to enable drag
function supportDragDrop(tab, handler) {
  var opt = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (opt.useTrigger) {
    tab.addEventListener('mousedown', function (e) {
      if (e.ctrlKey) {
        // window.console.log('enable drag')
        tab.draggable = true;
        var fn = function fn(e) {
          tab.draggable = false;
          // window.console.log('disable drag')
          document.removeEventListener('dragend', fn);
          document.removeEventListener('mouseup', fn);
        };
        document.addEventListener('dragend', fn);
        document.addEventListener('mouseup', fn);
      }
    });
  } else {
    tab.draggable = true;
  }
  tab.addEventListener('dragstart', function (e) {
    window.curDrag = tab;
  });
  tab.addEventListener('dragover', function (e) {
    if (window.curDrag === null || window.curDrag === tab || window.curDrag.parentElement !== tab.parentElement) {
      e.dataTransfer.dropEffect = 'none';
    } else {
      e.dataTransfer.dropEffect = 'move';
    }
    e.preventDefault();
  });
  tab.addEventListener('drop', function (e) {
    e.preventDefault();
    e.stopPropagation();
    if (window.curDrag === null || window.curDrag === tab || window.curDrag.parentElement !== tab.parentElement) {
      return;
    }
    var getPos = function getPos(item) {
      var i = 0;
      var a = item.parentElement.firstElementChild;
      while (a !== item && a !== null) {
        a = a.nextSibling;
        ++i;
      }
      return i;
    };
    var i = getPos(window.curDrag);
    var j = getPos(tab);
    handler(i, j, window.curDrag, tab);
    window.curDrag = null;
  });
}

/***/ }),

/***/ "./src/editors/array/choices.js":
/*!**************************************!*\
  !*** ./src/editors/array/choices.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrayChoicesEditor: () => (/* binding */ ArrayChoicesEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _multiselect_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../multiselect.js */ "./src/editors/multiselect.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var ArrayChoicesEditor = /*#__PURE__*/function (_MultiSelectEditor) {
  function ArrayChoicesEditor() {
    _classCallCheck(this, ArrayChoicesEditor);
    return _callSuper(this, ArrayChoicesEditor, arguments);
  }
  _inherits(ArrayChoicesEditor, _MultiSelectEditor);
  return _createClass(ArrayChoicesEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      if (this.choices_instance) {
        value = this.applyConstFilter(value);
        /* Make sure we are dealing with an array of strings so we can check for strict equality */
        value = [].concat(value).map(function (e) {
          return "".concat(e);
        });
        this.updateValue(value); /* Sets this.value to sanitized value */

        this.choices_instance.removeActiveItems(); /* Remove existing selection */
        this.choices_instance.setChoiceByValue(this.value); /* Set new selection */

        this.onChange(true);
      } else _get(_getPrototypeOf(ArrayChoicesEditor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      if (window.Choices && !this.choices_instance) {
        /* Get options, either global options from "this.defaults.options.choices" or */
        /* single property options from schema "options.choices" */
        var options = this.expandCallbacks('choices', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.extend)({}, {
          removeItems: true,
          removeItemButton: true
        }, this.defaults.options.choices || {}, this.options.choices || {}, {
          addItems: true,
          editItems: false,
          duplicateItemsAllowed: false
        }));

        /* New items are allowed if option "addItems" is true and items type is "string" */
        /* this.newEnumAllowed = options.addItems = !!options.addItems && this.schema.items && this.schema.items.type == 'string'; */

        /* Choices doesn't support adding new items to select type input */
        this.newEnumAllowed = false;
        this.choices_instance = new window.Choices(this.input, options);

        /* Remove change handler set in parent class (src/multiselect.js) */
        this.control.removeEventListener('change', this.multiselectChangeHandler);

        /* Create a new change handler */
        this.multiselectChangeHandler = function (e) {
          var value = _this.choices_instance.getValue(true);
          _this.updateValue(value);
          _this.onChange(true);
        };
        this.control.addEventListener('change', this.multiselectChangeHandler, false);
      }
      _get(_getPrototypeOf(ArrayChoicesEditor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      value = [].concat(value);
      var changed = false;
      var newValue = [];
      for (var i = 0; i < value.length; i++) {
        if (!this.select_values["".concat(value[i])]) {
          changed = true;
          if (this.newEnumAllowed) {
            if (!this.addNewOption(value[i])) continue;
          } else continue;
        }
        var sanitized = this.sanitize(this.select_values[value[i]]);
        newValue.push(sanitized);
        if (sanitized !== value[i]) changed = true;
      }
      this.value = newValue;
      return changed;
    }
  }, {
    key: "addNewOption",
    value: function addNewOption(value) {
      /* Add new value and label */
      this.option_keys.push("".concat(value));
      this.option_titles.push("".concat(value));
      this.select_values["".concat(value)] = value;
      /* Update Schema enum to prevent triggering "Value must be one of the enumerated values" */
      this.schema.items["enum"].push(value);
      /* Add new value and label to choices */
      this.choices_instance.setChoices([{
        value: "".concat(value),
        label: "".concat(value)
      }], 'value', 'label', false);
      return true;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.choices_instance) this.choices_instance.enable();
      _get(_getPrototypeOf(ArrayChoicesEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.choices_instance) this.choices_instance.disable();
      _get(_getPrototypeOf(ArrayChoicesEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.choices_instance) {
        this.choices_instance.destroy();
        this.choices_instance = null;
      }
      _get(_getPrototypeOf(ArrayChoicesEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_multiselect_js__WEBPACK_IMPORTED_MODULE_20__.MultiSelectEditor);

/***/ }),

/***/ "./src/editors/array/select2.js":
/*!**************************************!*\
  !*** ./src/editors/array/select2.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArraySelect2Editor: () => (/* binding */ ArraySelect2Editor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _multiselect_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../multiselect.js */ "./src/editors/multiselect.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var ArraySelect2Editor = /*#__PURE__*/function (_MultiSelectEditor) {
  function ArraySelect2Editor() {
    _classCallCheck(this, ArraySelect2Editor);
    return _callSuper(this, ArraySelect2Editor, arguments);
  }
  _inherits(ArraySelect2Editor, _MultiSelectEditor);
  return _createClass(ArraySelect2Editor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      if (this.select2_instance) {
        /* Make sure we are dealing with an array of strings so we can check for strict equality */
        value = [].concat(value).map(function (e) {
          return "".concat(e);
        });
        this.updateValue(value); /* Sets this.value to sanitized value */

        if (this.select2v4) this.select2_instance.val(this.value).change();else this.select2_instance.select2('val', this.value);
        this.onChange(true);
      } else _get(_getPrototypeOf(ArraySelect2Editor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.jQuery && window.jQuery.fn && window.jQuery.fn.select2 && !this.select2_instance) {
        /* Get options, either global options from "this.defaults.options.select2" or */
        /* single property options from schema "options.select2" */
        options = this.expandCallbacks('select2', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.extend)({}, {
          tags: true,
          width: '100%'
        }, this.defaults.options.select2 || {}, this.options.select2 || {}));

        /* New items are allowed if option "tags" is true and items type is "string" */
        this.newEnumAllowed = options.tags = !!options.tags && this.schema.items && this.schema.items.type === 'string';
        this.select2_instance = window.jQuery(this.input).select2(options);
        this.select2v4 = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.hasOwnProperty)(this.select2_instance.select2, 'amd');
        this.selectChangeHandler = function () {
          var value = _this.select2v4 ? _this.select2_instance.val() : _this.select2_instance.select2('val');
          _this.updateValue(value);
          _this.onChange(true);
        };

        /* Add event handler. */
        /* Note: Must use the "on()" method and not addEventListener() */
        this.select2_instance.on('select2-blur', this.selectChangeHandler);
        this.select2_instance.on('change', this.selectChangeHandler);
      }
      _get(_getPrototypeOf(ArraySelect2Editor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      value = [].concat(value);
      var changed = false;
      var newValue = [];
      for (var i = 0; i < value.length; i++) {
        /*      if (!this.select_options[value[i]+'']) { */
        if (!this.select_values["".concat(value[i])]) {
          changed = true;
          if (this.newEnumAllowed) {
            if (!this.addNewOption(value[i])) continue;
          } else continue;
        }
        var sanitized = this.sanitize(this.select_values[value[i]]);
        newValue.push(sanitized);
        if (sanitized !== value[i]) changed = true;
      }
      this.value = newValue;
      return changed;
    }
  }, {
    key: "addNewOption",
    value: function addNewOption(value) {
      /* Add new value and label */
      this.option_keys.push("".concat(value));
      this.option_titles.push("".concat(value));
      this.select_values["".concat(value)] = value;
      /* Update Schema enum to prevent triggering "Value must be one of the enumerated values" */
      this.schema.items["enum"].push(value);
      var optionTag = this.input.querySelector("option[value=\"".concat(value, "\"]"));
      /* Remove data attribute to make option tag permanent. (user input) */
      if (optionTag) optionTag.removeAttribute('data-select2-tag');
      /* Create new option tag (setValue) */else this.input.appendChild(new Option(value, value, false, false)).trigger('change');
      return true;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.select2_instance) {
        if (this.select2v4) this.select2_instance.prop('disabled', false);else this.select2_instance.select2('enable', true);
      }
      _get(_getPrototypeOf(ArraySelect2Editor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.select2_instance) {
        if (this.select2v4) this.select2_instance.prop('disabled', true);else this.select2_instance.select2('enable', false);
      }
      _get(_getPrototypeOf(ArraySelect2Editor.prototype), "disable", this).call(this);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.select2_instance) {
        this.select2_instance.select2('destroy');
        this.select2_instance = null;
      }
      _get(_getPrototypeOf(ArraySelect2Editor.prototype), "destroy", this).call(this);
    }
  }]);
}(_multiselect_js__WEBPACK_IMPORTED_MODULE_20__.MultiSelectEditor);

/***/ }),

/***/ "./src/editors/array/selectize.js":
/*!****************************************!*\
  !*** ./src/editors/array/selectize.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArraySelectizeEditor: () => (/* binding */ ArraySelectizeEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _multiselect_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../multiselect.js */ "./src/editors/multiselect.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var ArraySelectizeEditor = /*#__PURE__*/function (_MultiSelectEditor) {
  function ArraySelectizeEditor() {
    _classCallCheck(this, ArraySelectizeEditor);
    return _callSuper(this, ArraySelectizeEditor, arguments);
  }
  _inherits(ArraySelectizeEditor, _MultiSelectEditor);
  return _createClass(ArraySelectizeEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      if (this.selectize_instance) {
        /* Make sure we are dealing with an array of strings so we can check for strict equality */
        value = [].concat(value).map(function (e) {
          return "".concat(e);
        });
        this.updateValue(value); /* Sets this.value to sanitized value */

        this.selectize_instance.setValue(this.value);
        this.onChange(true);
      } else _get(_getPrototypeOf(ArraySelectizeEditor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.jQuery && window.jQuery.fn && window.jQuery.fn.selectize && !this.selectize_instance) {
        /* Get options, either global options from "this.defaults.options.selectize" or */
        /* single property options from schema "options.selectize" */
        options = this.expandCallbacks('selectize', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.extend)({}, {
          plugins: ['remove_button'],
          delimiter: false,
          createOnBlur: true,
          create: true
        }, this.defaults.options.selectize || {}, this.options.selectize || {}));

        /* New items are allowed if option "create" is true and items type is "string" */
        this.newEnumAllowed = options.create = !!options.create && this.schema.items && this.schema.items.type === 'string';
        this.selectize_instance = window.jQuery(this.input).selectize(options)[0].selectize;

        /* Remove change handler set in parent class (src/multiselect.js) */
        this.control.removeEventListener('change', this.multiselectChangeHandler);

        /* Create a new change handler */
        this.multiselectChangeHandler = function (e) {
          var value = _this.selectize_instance.getValue();
          _this.updateValue(value);
          _this.onChange(true);
        };

        /* Add new event handler. */
        /* Note: Must use the "on()" method and not addEventListener() */
        this.selectize_instance.on('change', this.multiselectChangeHandler);
        var label = this.theme.getHiddenLabel(this.formname);
        this.input.setAttribute('id', this.formname + '-hidden-input');
        label.setAttribute('for', this.formname + '-hidden-input');
        this.input.parentNode.insertBefore(label, this.input);
        var selectizeControl = this.selectize_instance.$control[0];
        if (selectizeControl) {
          var selectizeLabel = this.theme.getHiddenLabel(this.formname);
          selectizeLabel.setAttribute('for', this.formname + '-selectized');
          selectizeControl.appendChild(selectizeLabel);
        }
      }
      _get(_getPrototypeOf(ArraySelectizeEditor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      value = [].concat(value);
      var changed = false;
      var newValue = [];
      for (var i = 0; i < value.length; i++) {
        /*      if (!this.select_options[value[i]+'']) { */
        if (!this.select_values["".concat(value[i])]) {
          changed = true;
          if (this.newEnumAllowed) {
            if (!this.addNewOption(value[i])) continue;
          } else continue;
        }
        var sanitized = this.sanitize(this.select_values[value[i]]);
        newValue.push(sanitized);
        if (sanitized !== value[i]) changed = true;
      }
      this.value = newValue;
      return changed;
    }
  }, {
    key: "addNewOption",
    value: function addNewOption(value) {
      /* Add new value and label */
      this.option_keys.push("".concat(value));
      this.option_titles.push("".concat(value));
      this.select_values["".concat(value)] = value;
      /* Add new value and label to selectize */
      this.selectize_instance.addOption({
        text: value,
        value: value
      });
      return true;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.selectize_instance) this.selectize_instance.unlock();
      _get(_getPrototypeOf(ArraySelectizeEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.selectize_instance) this.selectize_instance.lock();
      _get(_getPrototypeOf(ArraySelectizeEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.selectize_instance) {
        this.selectize_instance.destroy();
        this.selectize_instance = null;
      }
      _get(_getPrototypeOf(ArraySelectizeEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_multiselect_js__WEBPACK_IMPORTED_MODULE_20__.MultiSelectEditor);

/***/ }),

/***/ "./src/editors/autocomplete.js":
/*!*************************************!*\
  !*** ./src/editors/autocomplete.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutocompleteEditor: () => (/* binding */ AutocompleteEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var AutocompleteEditor = /*#__PURE__*/function (_StringEditor) {
  function AutocompleteEditor() {
    _classCallCheck(this, AutocompleteEditor);
    return _callSuper(this, AutocompleteEditor, arguments);
  }
  _inherits(AutocompleteEditor, _StringEditor);
  return _createClass(AutocompleteEditor, [{
    key: "postBuild",
    value: function postBuild() {
      if (window.Autocomplete) {
        /* create wrapper container */
        this.autocomplete_wrapper = document.createElement('div');

        /* insert wrapper after this.input in the DOM tree */
        this.input.parentNode.insertBefore(this.autocomplete_wrapper, this.input.nextSibling);

        /* move this.input into wrapper */
        this.autocomplete_wrapper.appendChild(this.input);

        /* create dropdown container */
        this.autocomplete_dropdown = document.createElement('ul');

        /* insert dropdown after this.input in the DOM tree */
        this.input.parentNode.insertBefore(this.autocomplete_dropdown, this.input.nextSibling);
      }
      _get(_getPrototypeOf(AutocompleteEditor.prototype), "postBuild", this).call(this);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.Autocomplete && !this.autocomplete_instance) {
        /* Get options, either global options from "this.defaults.options.autocomplete" or */
        /* single property options from schema "options.autocomplete" */
        options = this.expandCallbacks('autocomplete', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.extend)({}, {
          search: function search(jseditor) {
            // eslint-disable-next-line no-console
            console.log("No \"search\" callback defined for autocomplete in property \"".concat(jseditor.key, "\""));
            return [];
          },
          onSubmit: function onSubmit() {
            _this.input.blur();
          },
          baseClass: 'autocomplete'
        }, this.defaults.options.autocomplete || {}, this.options.autocomplete || {}));
        this.autocomplete_wrapper.classList.add(options.baseClass);
        this.autocomplete_dropdown.classList.add("".concat(options.baseClass, "-result-list"));
        this.autocomplete_instance = new window.Autocomplete(this.autocomplete_wrapper, options);
      }
      _get(_getPrototypeOf(AutocompleteEditor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.autocomplete_instance) {
        if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
        if (this.autocomplete_dropdown && this.autocomplete_dropdown.parentNode) this.autocomplete_dropdown.parentNode.removeChild(this.autocomplete_dropdown);
        if (this.autocomplete_wrapper && this.autocomplete_wrapper.parentNode) this.autocomplete_wrapper.parentNode.removeChild(this.autocomplete_wrapper);
        this.autocomplete_instance = null;
      }
      _get(_getPrototypeOf(AutocompleteEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_18__.StringEditor);

/***/ }),

/***/ "./src/editors/base64.js":
/*!*******************************!*\
  !*** ./src/editors/base64.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Base64Editor: () => (/* binding */ Base64Editor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.parse-int.js */ "./node_modules/core-js/modules/es.parse-int.js");
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }

























function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Base64Editor = /*#__PURE__*/function (_AbstractEditor) {
  function Base64Editor() {
    _classCallCheck(this, Base64Editor);
    return _callSuper(this, Base64Editor, arguments);
  }
  _inherits(Base64Editor, _AbstractEditor);
  return _createClass(Base64Editor, [{
    key: "getNumColumns",
    value: function getNumColumns() {
      return 4;
    }
  }, {
    key: "setFileReaderListener",
    value: function setFileReaderListener(frMultiple) {
      var _this = this;
      frMultiple.addEventListener('load', function (event) {
        if (_this.count === _this.current_item_index) {
          /* Overwrite existing file by default, leave other properties unchanged */
          _this.value[_this.count][_this.key] = event.target.result;
        } else {
          var tempObject = {};
          /* Create empty object */
          for (var key in _this.parent.schema.properties) {
            tempObject[key] = '';
          }
          /* Set object media file */
          tempObject[_this.key] = event.target.result;
          _this.value.splice(_this.count, 0, tempObject); /* insert new file object */
        }

        /* Increment using the listener and not the 'for' loop as the listener will be processed asynchronously */
        _this.count += 1;
        /* When all files have been processed, update the value of the editor */
        if (_this.count === _this.total + _this.current_item_index) {
          _this.arrayEditor.setValue(_this.value);
        }
      });
    }
  }, {
    key: "build",
    value: function build() {
      var _this2 = this;
      if (!this.options.compact) this.title = this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));

      /* Input that holds the base64 string */
      this.input = this.theme.getFormInputField('hidden');
      this.container.appendChild(this.input);

      /* Don't show uploader if this is readonly */
      if (!this.schema.readOnly && !this.schema.readonly) {
        if (!window.FileReader) throw new Error('FileReader required for base64 editor');

        /* File uploader */
        this.uploader = this.theme.getFormInputField('file');
        this.uploader.style.display = 'none';

        /* Set attribute of file input field to 'multiple' if: */
        /* 'multiple' key has been set to 'true' in the schema */
        /* and the parent object is of type 'object' */
        /* and the parent of the parent type has been set to 'array' */
        if (this.schema.options && this.schema.options.multiple && this.schema.options.multiple === true && this.parent && this.parent.schema.type === 'object' && this.parent.parent && this.parent.parent.schema.type === 'array') {
          this.uploader.setAttribute('multiple', '');
        }
        this.uploader.addEventListener('change', function (e) {
          e.preventDefault();
          e.stopPropagation();
          if (e.currentTarget.files && e.currentTarget.files.length) {
            /* Check the amount of files uploaded. */
            /* If 1, use the regular upload, otherwise use the multiple upload method */
            if (e.currentTarget.files.length > 1 && _this2.schema.options && _this2.schema.options.multiple && _this2.schema.options.multiple === true && _this2.parent && _this2.parent.schema.type === 'object' && _this2.parent.parent && _this2.parent.parent.schema.type === 'array') {
              /* Load editor of parent.parent to get the array */
              _this2.arrayEditor = _this2.jsoneditor.getEditor(_this2.parent.parent.path);
              /* Check the current value of this editor */
              _this2.value = _this2.arrayEditor.getValue();
              /* Set variables for amount of files, index of current array item and */
              /* count value containing current status of processed files */
              _this2.total = e.currentTarget.files.length;
              _this2.current_item_index = parseInt(_this2.parent.key);
              _this2.count = _this2.current_item_index;
              for (var i = 0; i < _this2.total; i++) {
                var frMultiple = new FileReader();
                _this2.setFileReaderListener(frMultiple);
                frMultiple.readAsDataURL(e.currentTarget.files[i]);
              }
            } else {
              var fr = new FileReader();
              fr.onload = function (evt) {
                _this2.value = evt.target.result;
                _this2.refreshPreview();
                _this2.onChange(true);
                fr = null;
              };
              fr.readAsDataURL(e.currentTarget.files[0]);
            }
          }
        });
      }
      this.preview = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      this.container.appendChild(this.preview);
      this.control = this.theme.getFormControl(this.label, this.uploader || this.input, this.preview, this.infoButton);
      this.container.appendChild(this.control);
      var uploadButton = this.getButton('button_upload', 'upload', 'button_upload');
      uploadButton.addEventListener('click', function () {
        _this2.uploader.click();
      });
      this.control.appendChild(uploadButton);

      /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
      this.setInputAttributes(['multiple'], uploadButton);
    }
  }, {
    key: "refreshPreview",
    value: function refreshPreview() {
      if (this.last_preview === this.value) return;
      this.last_preview = this.value;
      this.preview.innerHTML = '';
      if (!this.value) return;
      var mime = this.value.match(/^data:([^;,]+)[;,]/);
      if (mime) mime = mime[1];
      if (!mime) {
        this.preview.innerHTML = '<em>Invalid data URI</em>';
      } else {
        this.preview.innerHTML = "<strong>Type:</strong> ".concat(mime, ", <strong>Size:</strong> ").concat(Math.floor((this.value.length - this.value.split(',')[0].length - 1) / 1.33333), " bytes");
        if (mime.substr(0, 5) === 'image') {
          this.preview.innerHTML += '<br>';
          var img = document.createElement('img');
          img.style.maxWidth = '100%';
          img.style.maxHeight = '100px';
          img.src = this.value;
          this.preview.appendChild(img);
        }
      }
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        if (this.uploader) this.uploader.disabled = false;
        _get(_getPrototypeOf(Base64Editor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      if (this.uploader) this.uploader.disabled = true;
      _get(_getPrototypeOf(Base64Editor.prototype), "disable", this).call(this);
    }
  }, {
    key: "setValue",
    value: function setValue(val) {
      val = this.applyConstFilter(val);
      if (this.value !== val) {
        if (this.schema.readOnly && this.schema["enum"] && !this.schema["enum"].includes(val)) this.value = this.schema["enum"][0];else this.value = val;
        this.input.value = this.value;
        this.refreshPreview();
        this.onChange();
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.preview && this.preview.parentNode) this.preview.parentNode.removeChild(this.preview);
      if (this.title && this.title.parentNode) this.title.parentNode.removeChild(this.title);
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      if (this.uploader && this.uploader.parentNode) this.uploader.parentNode.removeChild(this.uploader);
      _get(_getPrototypeOf(Base64Editor.prototype), "destroy", this).call(this);
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_25__.AbstractEditor);

/***/ }),

/***/ "./src/editors/button.js":
/*!*******************************!*\
  !*** ./src/editors/button.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ButtonEditor: () => (/* binding */ ButtonEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }





















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* Non-Active editor for displaying buttons in form */


var ButtonEditor = /*#__PURE__*/function (_AbstractEditor) {
  function ButtonEditor(options, defaults) {
    var _this;
    _classCallCheck(this, ButtonEditor);
    _this = _callSuper(this, ButtonEditor, [options, defaults]);
    _this.active = false;
    _this.isUiOnly = true;

    /* Set field to required in schema otherwise it will not be displayed */
    if (_this.parent && _this.parent.schema) {
      if (Array.isArray(_this.parent.schema.required)) {
        if (!_this.parent.schema.required.includes(_this.key)) {
          _this.parent.schema.required.push(_this.key);
        }
      } else {
        _this.parent.schema.required = [_this.key];
      }
    }
    return _this;
  }
  _inherits(ButtonEditor, _AbstractEditor);
  return _createClass(ButtonEditor, [{
    key: "build",
    value: function build() {
      var _this2 = this;
      this.options.compact = true;

      /* Get options, either global options from "this.defaults.options.button" or */
      /* single property options from schema "options.button" */
      var options = this.expandCallbacks('button', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_22__.extend)({}, {
        icon: '',
        validated: false,
        align: 'left',
        action: function action(jseditor, e) {
          window.alert("No button action defined for \"".concat(jseditor.path, "\""));
        }
      }, this.defaults.options.button || {}, this.options.button || {}));
      var title = this.translateProperty(options.text || this.schema.title) || this.key;
      this.input = this.getButton(title, options.icon, title);
      if (typeof options.action !== 'function') {
        window.alert("No button action defined for \"".concat(this.path, "\""));
      } else {
        this.input.addEventListener('click', options.action, false);
      }
      if (this.schema.readOnly || this.schema.readonly || this.schema.template) {
        this.disable(true);
        this.input.setAttribute('readonly', 'true');
      }

      /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
      this.setInputAttributes(['readonly']);
      this.control = this.theme.getFormButtonHolder(options.align);
      this.control.appendChild(this.input);
      this.container.appendChild(this.control);
      this.changeHandler = function () {
        if (_this2.jsoneditor.validate(_this2.jsoneditor.getValue()).length > 0) _this2.disable();else _this2.enable();
      };

      /* Enable/disable the button depending on form validation */
      if (options.validated) this.jsoneditor.on('change', this.changeHandler);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        this.input.disabled = false;
        _get(_getPrototypeOf(ButtonEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      this.input.disabled = true;
      _get(_getPrototypeOf(ButtonEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "activate",
    value: function activate() {
      this.active = false;
      this.enable();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      /* only non required properties can be deactivated. */
      if (!this.isRequired()) {
        this.active = false;
        this.disable();
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.jsoneditor.off('change', this.changeHandler);
      this.changeHandler = null;
      _get(_getPrototypeOf(ButtonEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_21__.AbstractEditor);

/***/ }),

/***/ "./src/editors/checkbox.js":
/*!*********************************!*\
  !*** ./src/editors/checkbox.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckboxEditor: () => (/* binding */ CheckboxEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var CheckboxEditor = /*#__PURE__*/function (_AbstractEditor) {
  function CheckboxEditor() {
    _classCallCheck(this, CheckboxEditor);
    return _callSuper(this, CheckboxEditor, arguments);
  }
  _inherits(CheckboxEditor, _AbstractEditor);
  return _createClass(CheckboxEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      value = !!value;
      var changed = this.getValue() !== value;
      this.value = value;
      this.input.checked = this.value;
      if (!initial) {
        this.is_dirty = true;
      }
      this.onChange(changed);
    }
  }, {
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(CheckboxEditor.prototype), "register", this).call(this);
      if (!this.input) return;
      if (this.jsoneditor.options.use_name_attributes) {
        this.input.setAttribute('name', this.formname);
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(CheckboxEditor.prototype), "unregister", this).call(this);
      if (!this.input) return;
      this.input.removeAttribute('name');
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return Math.min(12, Math.max(this.getTitle().length / 7, 2));
    }
  }, {
    key: "setOptInCheckbox",
    value: function setOptInCheckbox() {
      _get(_getPrototypeOf(CheckboxEditor.prototype), "setOptInCheckbox", this).call(this);
      if (this.optInAppended) {
        this.container.insertBefore(this.optInContainer, this.container.firstChild);
        this.optInContainer.style.verticalAlign = 'top';
        this.control.style.marginTop = '0';
      }
    }
  }, {
    key: "build",
    value: function build() {
      var _this = this;
      if (!this.parent.options.table_row) {
        this.label = this.header = this.theme.getCheckboxLabel(this.getTitle(), this.isRequired());
        this.label.htmlFor = this.formname;
      }
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText && !this.options.compact) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.compact) this.container.classList.add('compact');
      this.input = this.theme.getCheckbox();
      this.input.id = this.formname;
      this.control = this.theme.getFormControl(this.label, this.input, this.description, this.infoButton);
      this.control.style.display = 'inline-block';
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable(true);
        this.input.disabled = true;
      }
      this.input.addEventListener('change', function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this.value = e.currentTarget.checked;
        _this.is_dirty = true;
        _this.onChange(true);
      });
      this.container.appendChild(this.control);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        this.input.disabled = false;
        _get(_getPrototypeOf(CheckboxEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      this.input.disabled = true;
      _get(_getPrototypeOf(CheckboxEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      _get(_getPrototypeOf(CheckboxEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this2 = this;
      var showErrors = this.jsoneditor.options.show_errors;
      var changeOrInteraction = showErrors === 'change' || showErrors === 'interaction';
      var never = showErrors === 'never';
      if (never && !this.is_dirty) {
        return;
      }
      if (changeOrInteraction && !this.is_dirty) {
        return;
      }
      var addMessage = function addMessage(messages, error) {
        if (error.path === _this2.path) {
          messages.push(error.message);
        }
        return messages;
      };
      var messages = errors.reduce(addMessage, []);
      this.input.controlgroup = this.control;
      if (messages.length) {
        this.theme.addInputError(this.input, "".concat(messages.join('. '), "."));
      } else {
        this.theme.removeInputError(this.input);
      }
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_20__.AbstractEditor);

/***/ }),

/***/ "./src/editors/choices.css.js":
/*!************************************!*\
  !*** ./src/editors/choices.css.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ".choices > *": "box-sizing:border-box"
});
/* eslint-enable */

/***/ }),

/***/ "./src/editors/choices.js":
/*!********************************!*\
  !*** ./src/editors/choices.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChoicesEditor: () => (/* binding */ ChoicesEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ "./node_modules/core-js/modules/es.array.index-of.js");
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _select_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./select.js */ "./src/editors/select.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
/* harmony import */ var _choices_css_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./choices.css.js */ "./src/editors/choices.css.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }



var ChoicesEditor = /*#__PURE__*/function (_SelectEditor) {
  function ChoicesEditor() {
    _classCallCheck(this, ChoicesEditor);
    return _callSuper(this, ChoicesEditor, arguments);
  }
  _inherits(ChoicesEditor, _SelectEditor);
  return _createClass(ChoicesEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      if (this.choices_instance) {
        /* Sanitize value before setting it */
        var sanitized = this.typecast(value || '');
        if (!this.enum_values.includes(sanitized)) sanitized = this.enum_values[0];
        if (this.value === sanitized) return;
        if (initial) this.is_dirty = false;else if (this.jsoneditor.options.show_errors === 'change') this.is_dirty = true;
        this.input.value = this.enum_options[this.enum_values.indexOf(sanitized)];
        this.choices_instance.setChoiceByValue(this.input.value);
        this.value = sanitized;
        this.onChange();
      } else _get(_getPrototypeOf(ChoicesEditor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      if (window.Choices && !this.choices_instance) {
        /* Get options, either global options from "this.defaults.options.choices" or */
        /* single property options from schema "options.choices" */
        var options = this.expandCallbacks('choices', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_23__.extend)({}, this.defaults.options.choices || {}, this.options.choices || {}));
        this.choices_instance = new window.Choices(this.input, options);
      }
      _get(_getPrototypeOf(ChoicesEditor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var _this = this;
      _get(_getPrototypeOf(ChoicesEditor.prototype), "onWatchedFieldChange", this).call(this);
      if (this.choices_instance) {
        var choicesList = this.enum_options.map(function (v, i) {
          return {
            value: v,
            label: _this.enum_display[i]
          };
        });
        this.choices_instance.setChoices(choicesList, 'value', 'label', true);
        this.choices_instance.setChoiceByValue("".concat(this.value)); /* Set new selection */
      }
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.choices_instance) this.choices_instance.enable();
      _get(_getPrototypeOf(ChoicesEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.choices_instance) this.choices_instance.disable();
      _get(_getPrototypeOf(ChoicesEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.choices_instance) {
        this.choices_instance.destroy();
        this.choices_instance = null;
      }
      _get(_getPrototypeOf(ChoicesEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_select_js__WEBPACK_IMPORTED_MODULE_22__.SelectEditor);
ChoicesEditor.rules = _choices_css_js__WEBPACK_IMPORTED_MODULE_24__["default"];

/***/ }),

/***/ "./src/editors/colorpicker.js":
/*!************************************!*\
  !*** ./src/editors/colorpicker.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorEditor: () => (/* binding */ ColorEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }



















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/*

Edtended handling of  oolor type fields.

Has optional support for using https://github.com/Sphinxxxx/vanilla-picker.

*/


var ColorEditor = /*#__PURE__*/function (_StringEditor) {
  function ColorEditor() {
    _classCallCheck(this, ColorEditor);
    return _callSuper(this, ColorEditor, arguments);
  }
  _inherits(ColorEditor, _StringEditor);
  return _createClass(ColorEditor, [{
    key: "postBuild",
    value: function postBuild() {
      if (window.Picker) {
        this.input.type = 'text';
      }
      this.input.style.padding = '3px';
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      var res = _get(_getPrototypeOf(ColorEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
      if (this.picker_instance && this.picker_instance.domElement && res && res.changed) {
        this.picker_instance.setColor(res.value, true);
      }
      return res;
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      _get(_getPrototypeOf(ColorEditor.prototype), "afterInputReady", this).call(this);
      this.createPicker(true);
    }
  }, {
    key: "disable",
    value: function disable() {
      _get(_getPrototypeOf(ColorEditor.prototype), "disable", this).call(this);
      if (this.picker_instance && this.picker_instance.domElement) {
        /* Disable picker cursor dragging */
        this.picker_instance.domElement.style.pointerEvents = 'none';
        /* Disable picker buttons */
        var buttons = this.picker_instance.domElement.querySelectorAll('button');
        for (var i = 0; i < buttons.length; i++) {
          buttons[i].disabled = true;
        }
      }
    }
  }, {
    key: "enable",
    value: function enable() {
      _get(_getPrototypeOf(ColorEditor.prototype), "enable", this).call(this);
      if (this.picker_instance && this.picker_instance.domElement) {
        /* Enable picker cursor dragging */
        this.picker_instance.domElement.style.pointerEvents = 'auto';
        /* Enable picker buttons */
        var buttons = this.picker_instance.domElement.querySelectorAll('button');
        for (var i = 0; i < buttons.length; i++) {
          buttons[i].disabled = false;
        }
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.createPicker(false);
      _get(_getPrototypeOf(ColorEditor.prototype), "destroy", this).call(this);
    }

    /* helper functions */
  }, {
    key: "createPicker",
    value: function createPicker(create) {
      var _this = this;
      if (create) {
        /* create vanilla-picker */
        if (window.Picker && !this.picker_instance) {
          /* do when vanilla-picker loaded */
          var options = this.expandCallbacks('colorpicker', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_20__.extend)({}, {
            editor: false,
            /* default no editor */
            alpha: false,
            /* default no alpha */
            color: this.value,
            popup: 'bottom' /* show in the bottom */
          }, this.defaults.options.colorpicker || {}, this.options.colorpicker || {}, {
            parent: this.container
          }));
          var updateHandler = function updateHandler(color) {
            var format = _this.picker_instance.settings.editorFormat;
            var isAlpha = _this.picker_instance.settings.alpha;
            _this.setValue(format === 'hex' ? isAlpha ? color.hex : color.hex.slice(0, 7) : color["".concat(format + (isAlpha ? 'a' : ''), "String")]);
          };
          if (!options.popup && typeof options.onChange !== 'function') options.onChange = updateHandler;else if (options.popup && typeof options.onDone !== 'function') options.onDone = updateHandler;
          this.picker_instance = new window.Picker(options);
          /* this.picker_instance.openHandler() */
          if (!options.popup) {
            /* use inline colorPicker */
            this.input.style.display = 'none';
            this.theme.afterInputReady(this.picker_instance.domElement);
          }
        }
      } else {
        /* destroy vanilla-picker */
        if (this.picker_instance) {
          this.picker_instance.destroy();
          this.picker_instance = null;
          this.input.style.display = '';
        }
      }
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_19__.StringEditor);

/***/ }),

/***/ "./src/editors/datetime.js":
/*!*********************************!*\
  !*** ./src/editors/datetime.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DatetimeEditor: () => (/* binding */ DatetimeEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.parse-int.js */ "./node_modules/core-js/modules/es.parse-int.js");
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");























function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/*

Edtended handling of date, time and datetime-local type fields.

Works with both string and integer data types. (default only support string type)

Has optional support for using flatpickr datepicker.
All flatpickr options is supported with a few minor differences.
- "enableTime" and "noCalendar" are set automatically, based on the data type.
- Extra config option "errorDateFormat". If this is set, it will replace the format displayed in error messages.
- It is not possible to use "inline" and "wrap" options together.
- When using the "wrap" option, "toggle" and "clear" buttons are automatically added to markup. 2 extra boolean options ("showToggleButton" and "showClearButton") are available to control which buttons to display. Note: not all frameworks supports this. (Works in: Bootstrap and Foundation)
- When using the "inline" option, an extra boolean option ("inlineHideInput") is available to hide the original input field.
- If "mode" is set to either "multiple" or "range", only string data type is supported. Also the result from these is returned as a string not an array.

ToDo:
 - Improve Handling of flatpicker "multiple" and "range" modes. (Currently the values are just added as string values, but the optimal scenario would be to save those as array if possible)

*/

var DatetimeEditor = /*#__PURE__*/function (_StringEditor) {
  function DatetimeEditor() {
    _classCallCheck(this, DatetimeEditor);
    return _callSuper(this, DatetimeEditor, arguments);
  }
  _inherits(DatetimeEditor, _StringEditor);
  return _createClass(DatetimeEditor, [{
    key: "build",
    value: function build() {
      _get(_getPrototypeOf(DatetimeEditor.prototype), "build", this).call(this);
      if (!this.input) {
        return;
      }
      if (this.schema.max && typeof this.schema.max === 'string') {
        this.input.setAttribute('max', this.schema.max);
      }
      if (this.schema.min && typeof this.schema.max === 'string') {
        this.input.setAttribute('min', this.schema.min);
      }
      if (window.flatpickr && _typeof(this.options.flatpickr) === 'object') {
        /* Make sure that flatpickr settings matches the input type */
        this.options.flatpickr.enableTime = this.schema.format !== 'date';
        this.options.flatpickr.noCalendar = this.schema.format === 'time';

        /* Curently only string can contain range or multiple values */
        if (this.schema.type === 'integer') this.options.flatpickr.mode = 'single';

        /* Attribute for flatpicker */
        this.input.setAttribute('data-input', '');
        var input = this.input;
        if (this.options.flatpickr.wrap === true) {
          /* Create buttons for input group */
          var buttons = [];
          if (this.options.flatpickr.showToggleButton !== false) {
            var toggleButton = this.getButton('', this.schema.format === 'time' ? 'time' : 'calendar', 'flatpickr_toggle_button');
            /* Attribute for flatpicker */
            toggleButton.setAttribute('data-toggle', '');
            buttons.push(toggleButton);
          }
          if (this.options.flatpickr.showClearButton !== false) {
            var clearButton = this.getButton('', 'clear', 'flatpickr_clear_button');
            /* Attribute for flatpicker */
            clearButton.setAttribute('data-clear', '');
            buttons.push(clearButton);
          }

          /* Save position of input field */
          var parentNode = this.input.parentNode;
          var nextSibling = this.input.nextSibling;
          var buttonContainer = this.theme.getInputGroup(this.input, buttons);
          if (buttonContainer !== undefined) {
            /* Make sure "inline" option is turned off */
            this.options.flatpickr.inline = false;

            /* Insert container at same position as input field */
            parentNode.insertBefore(buttonContainer, nextSibling);
            input = buttonContainer;
          } else {
            this.options.flatpickr.wrap = false;
          }
        }
        this.flatpickr = window.flatpickr(input, this.options.flatpickr);
        if (this.options.flatpickr.inline === true && this.options.flatpickr.inlineHideInput === true) {
          this.input.setAttribute('type', 'hidden');
        }
      }
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      if (this.schema.type === 'string') {
        return this.value;
      }
      if (this.value === '' || this.value === undefined) {
        return undefined;
      }
      var value = this.schema.format === 'time' ? "1970-01-01 ".concat(this.value) : this.value;
      return parseInt(new Date(value).getTime() / 1000);
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      if (this.schema.type === 'string') {
        _get(_getPrototypeOf(DatetimeEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
        if (this.flatpickr) this.flatpickr.setDate(value);
      } else if (value > 0) {
        var dateObj = new Date(value * 1000);
        var year = dateObj.getFullYear();
        var month = this.zeroPad(dateObj.getMonth() + 1);
        var day = this.zeroPad(dateObj.getDate());
        var hour = this.zeroPad(dateObj.getHours());
        var min = this.zeroPad(dateObj.getMinutes());
        var sec = this.zeroPad(dateObj.getSeconds());
        var date = [year, month, day].join('-');
        var time = [hour, min, sec].join(':');
        var dateValue = "".concat(date, "T").concat(time);
        if (this.schema.format === 'date') dateValue = date;else if (this.schema.format === 'time') dateValue = time;
        this.input.value = dateValue;
        this.refreshValue();
        if (this.flatpickr) this.flatpickr.setDate(dateValue);
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.flatpickr) this.flatpickr.destroy();
      this.flatpickr = null;
      _get(_getPrototypeOf(DatetimeEditor.prototype), "destroy", this).call(this);
    }

    /* helper function */
  }, {
    key: "zeroPad",
    value: function zeroPad(value) {
      return "0".concat(value).slice(-2);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_23__.StringEditor);

/***/ }),

/***/ "./src/editors/describedby.js":
/*!************************************!*\
  !*** ./src/editors/describedby.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DescribedByEditor: () => (/* binding */ DescribedByEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* hyper-link describeBy Editor */


var DescribedByEditor = /*#__PURE__*/function (_AbstractEditor) {
  function DescribedByEditor() {
    _classCallCheck(this, DescribedByEditor);
    return _callSuper(this, DescribedByEditor, arguments);
  }
  _inherits(DescribedByEditor, _AbstractEditor);
  return _createClass(DescribedByEditor, [{
    key: "register",
    value: function register() {
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].unregister();
        }
        if (this.editors[this.currentEditor]) this.editors[this.currentEditor].register();
      }
      _get(_getPrototypeOf(DescribedByEditor.prototype), "register", this).call(this);
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(DescribedByEditor.prototype), "unregister", this).call(this);
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].unregister();
        }
      }
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      if (!this.editors[this.currentEditor]) return 4;
      return Math.max(this.editors[this.currentEditor].getNumColumns(), 4);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].enable();
        }
      }
      _get(_getPrototypeOf(DescribedByEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable() {
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].disable();
        }
      }
      _get(_getPrototypeOf(DescribedByEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "switchEditor",
    value: function switchEditor() {
      var _this = this;
      var vars = this.getWatchedFieldValues();
      if (!vars) return;

      /* var ref = this.template.fillFromObject(vars); */
      /* var ref = this.template(vars); */
      var ref = document.location.origin + document.location.pathname + this.template(vars);
      if (!this.editors[this.refs[ref]]) {
        this.buildChildEditor(ref);
      }
      this.currentEditor = this.refs[ref];
      this.register();
      this.editors.forEach(function (editor, ref) {
        if (!editor) return;
        if (_this.currentEditor === ref) {
          editor.container.style.display = '';
        } else {
          editor.container.style.display = 'none';
        }
      });
      this.refreshValue();
      this.onChange(true);
    }
  }, {
    key: "buildChildEditor",
    value: function buildChildEditor(ref) {
      this.refs[ref] = this.editors.length;
      var holder = this.theme.getChildEditorHolder();
      this.editor_holder.appendChild(holder);
      var schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_23__.extend)({}, this.schema, this.jsoneditor.refs[ref]);
      var editorClass = this.jsoneditor.getEditorClass(schema, this.jsoneditor);
      var editor = this.jsoneditor.createEditor(editorClass, {
        jsoneditor: this.jsoneditor,
        schema: schema,
        container: holder,
        path: this.path,
        parent: this,
        required: true
      });
      this.editors.push(editor);
      editor.preBuild();
      editor.build();
      editor.postBuild();
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      this.refs = {};
      this.editors = [];
      this.currentEditor = '';
      var i;
      for (i = 0; i < this.schema.links.length; i++) {
        if (this.schema.links[i].rel.toLowerCase() === 'describedby') {
          /* this.template = new UriTemplate(this.schema.links[i].href); */
          this.template = this.jsoneditor.compileTemplate(this.schema.links[i].href, this.template_engine);
          break;
        }
      }

      /* this.template.fill(function(varName) {
        this.schema.watch = this.schema.watch || {};
        this.schema.watch[varName] = varName;
        return '';
      }); */

      this.schema.links = this.schema.links.slice(0, i).concat(this.schema.links.slice(i + 1));
      if (this.schema.links.length === 0) delete this.schema.links;
      this.baseSchema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_23__.extend)({}, this.schema);
    }
  }, {
    key: "build",
    value: function build() {
      this.editor_holder = document.createElement('div');
      this.container.appendChild(this.editor_holder);
      this.switchEditor();
    }
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      this.switchEditor();
    }
  }, {
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      if (this.editors[this.currentEditor]) {
        this.refreshValue();
      }
      _get(_getPrototypeOf(DescribedByEditor.prototype), "onChildEditorChange", this).call(this, editor, eventData);
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      if (this.editors[this.currentEditor]) {
        this.value = this.editors[this.currentEditor].getValue();
      }
    }
  }, {
    key: "setValue",
    value: function setValue(val, initial) {
      val = this.applyConstFilter(val);
      if (this.editors[this.currentEditor]) {
        this.editors[this.currentEditor].setValue(val, initial);
        this.refreshValue();
        this.onChange();
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.editors.forEach(function (editor) {
        if (editor) editor.destroy();
      });
      if (this.editor_holder && this.editor_holder.parentNode) {
        this.editor_holder.parentNode.removeChild(this.editor_holder);
      }
      _get(_getPrototypeOf(DescribedByEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      this.editors.forEach(function (editor) {
        if (!editor) return;
        editor.showValidationErrors(errors);
      });
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_22__.AbstractEditor);

/***/ }),

/***/ "./src/editors/enum.js":
/*!*****************************!*\
  !*** ./src/editors/enum.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EnumEditor: () => (/* binding */ EnumEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ "./node_modules/core-js/modules/es.array.index-of.js");
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* Enum Editor (used for objects and arrays with enumerated values) */

var EnumEditor = /*#__PURE__*/function (_AbstractEditor) {
  function EnumEditor() {
    _classCallCheck(this, EnumEditor);
    return _callSuper(this, EnumEditor, arguments);
  }
  _inherits(EnumEditor, _AbstractEditor);
  return _createClass(EnumEditor, [{
    key: "getNumColumns",
    value: function getNumColumns() {
      return 4;
    }
  }, {
    key: "build",
    value: function build() {
      var _this = this;
      this.title = this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      this.container.appendChild(this.title);
      this.options.enum_titles = this.options.enum_titles || [];
      if (this.enforceConstEnabled && this.schema["const"]) {
        this["enum"] = [this.schema["const"]];
      } else {
        this["enum"] = this.schema["enum"];
      }
      this.selected = 0;
      this.select_options = [];
      this.html_values = [];
      for (var i = 0; i < this["enum"].length; i++) {
        this.select_options[i] = this.options.enum_titles[i] || "Value ".concat(i + 1);
        this.html_values[i] = this.getHTML(this["enum"][i]);
      }

      /* Switcher */
      this.switcher = this.theme.getSwitcher(this.select_options);
      this.container.appendChild(this.switcher);

      /* Display area */
      this.display_area = this.theme.getIndentedPanel();
      this.container.appendChild(this.display_area);
      if (this.options.hide_display) this.display_area.style.display = 'none';
      this.switcher.addEventListener('change', function (e) {
        _this.selected = _this.select_options.indexOf(e.currentTarget.value);
        _this.value = _this["enum"][_this.selected];
        _this.refreshValue();
        _this.onChange(true);
      });
      this.value = this["enum"][0];
      this.refreshValue();
      if (this["enum"].length === 1) this.switcher.style.display = 'none';
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      var _this2 = this;
      if (!this["enum"]) {
        return;
      }
      this.selected = -1;
      var stringified = JSON.stringify(this.value);
      this["enum"].forEach(function (el, i) {
        if (stringified === JSON.stringify(el)) {
          _this2.selected = i;
          return false;
        }
      });
      if (this.selected < 0) {
        this.setValue(this["enum"][0]);
        return;
      }
      this.switcher.value = this.select_options[this.selected];
      this.display_area.innerHTML = this.html_values[this.selected];
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        this.switcher.disabled = false;
        _get(_getPrototypeOf(EnumEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      this.switcher.disabled = true;
      _get(_getPrototypeOf(EnumEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "getHTML",
    value: function getHTML(el) {
      var _this3 = this;
      var each = function each(obj, callback) {
        if (Array.isArray(obj) || typeof obj.length === 'number' && obj.length > 0 && obj.length - 1 in obj) {
          Array.from(obj).forEach(function (e, i) {
            return callback(i, e);
          });
        } else {
          Object.entries(obj).forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];
            return callback(key, value);
          });
        }
      };
      if (el === null) {
        return '<em>null</em>';
        /* Array or Object */
      } else if (_typeof(el) === 'object') {
        /* TODO: use theme */
        var ret = '';
        var callback = function callback(i, child) {
          var html = _this3.getHTML(child);
          /* Add the keys to object children */
          if (!Array.isArray(el)) {
            /* TODO: use theme */
            html = "<div><em>".concat(i, "</em>: ").concat(html, "</div>");
          }
          /* TODO: use theme */
          ret += "<li>".concat(html, "</li>");
        };
        each(el, callback);
        if (Array.isArray(el)) ret = "<ol>".concat(ret, "</ol>");else ret = "<ul style='margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0;'>".concat(ret, "</ul>");
        return ret;
        /* Boolean */
      } else if (typeof el === 'boolean') {
        return el ? 'true' : 'false';
        /* String */
      } else if (typeof el === 'string') {
        return el.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        /* Number */
      }
      return el;
    }
  }, {
    key: "setValue",
    value: function setValue(val) {
      val = this.applyConstFilter(val);
      if (this.value !== val) {
        this.value = val;
        this.refreshValue();
        this.onChange();
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.display_area && this.display_area.parentNode) this.display_area.parentNode.removeChild(this.display_area);
      if (this.title && this.title.parentNode) this.title.parentNode.removeChild(this.title);
      if (this.switcher && this.switcher.parentNode) this.switcher.parentNode.removeChild(this.switcher);
      _get(_getPrototypeOf(EnumEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_32__.AbstractEditor);

/***/ }),

/***/ "./src/editors/hidden.js":
/*!*******************************!*\
  !*** ./src/editors/hidden.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HiddenEditor: () => (/* binding */ HiddenEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");



















function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/**
 * Created by Mehmet Baker on 12.04.2017
 */

var HiddenEditor = /*#__PURE__*/function (_AbstractEditor) {
  function HiddenEditor() {
    _classCallCheck(this, HiddenEditor);
    return _callSuper(this, HiddenEditor, arguments);
  }
  _inherits(HiddenEditor, _AbstractEditor);
  return _createClass(HiddenEditor, [{
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(HiddenEditor.prototype), "register", this).call(this);
      if (!this.input) return;
      if (this.jsoneditor.options.use_name_attributes) {
        this.input.setAttribute('name', this.formname);
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(HiddenEditor.prototype), "unregister", this).call(this);
      if (!this.input) return;
      this.input.removeAttribute('name');
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      if (this.template && !fromTemplate) {
        return;
      }
      if (value === null || typeof value === 'undefined') value = '';else if (_typeof(value) === 'object') value = JSON.stringify(value);else if (typeof value !== 'string') value = "".concat(value);
      if (value === this.serialized) return;

      /* Sanitize value before setting it */
      var sanitized = this.sanitize(value);
      if (this.input.value === sanitized) {
        return;
      }
      this.input.value = sanitized;
      var changed = fromTemplate || this.getValue() !== value;
      this.refreshValue();
      if (initial) this.is_dirty = false;else if (this.jsoneditor.options.show_errors === 'change') this.is_dirty = true;
      if (this.adjust_height) this.adjust_height(this.input);

      /* Bubble this setValue to parents if the value changed */
      this.onChange(changed);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "enable",
    value: function enable() {
      _get(_getPrototypeOf(HiddenEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable() {
      _get(_getPrototypeOf(HiddenEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      this.value = this.input.value;
      if (typeof this.value !== 'string') this.value = '';
      this.serialized = this.value;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.template = null;
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      _get(_getPrototypeOf(HiddenEditor.prototype), "destroy", this).call(this);
    }

    /**
     * This is overridden in derivative editors
     */
  }, {
    key: "sanitize",
    value: function sanitize(value) {
      return value;
    }

    /**
     * Re-calculates the value if needed
     */
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var vars;

      /* If this editor needs to be rendered by a macro template */
      if (this.template) {
        vars = this.getWatchedFieldValues();
        this.setValue(this.template(vars), false, true);
      }
      _get(_getPrototypeOf(HiddenEditor.prototype), "onWatchedFieldChange", this).call(this);
    }
  }, {
    key: "build",
    value: function build() {
      this.format = this.schema.format;
      if (!this.format && this.options.default_format) {
        this.format = this.options.default_format;
      }
      if (this.options.format) {
        this.format = this.options.format;
      }
      this.input_type = 'hidden';
      this.input = this.theme.getFormInputField(this.input_type);
      if (this.format) this.input.setAttribute('data-schemaformat', this.format);
      this.container.appendChild(this.input);

      /* Compile and store the template */
      if (this.schema.template) {
        var callback = this.expandCallbacks('template', {
          template: this.schema.template
        });
        if (typeof callback.template === 'function') this.template = callback.template;else this.template = this.jsoneditor.compileTemplate(this.schema.template, this.template_engine);
        this.refreshValue();
      } else {
        this.refreshValue();
      }
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_19__.AbstractEditor);

/***/ }),

/***/ "./src/editors/index.js":
/*!******************************!*\
  !*** ./src/editors/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   editors: () => (/* binding */ editors)
/* harmony export */ });
/* harmony import */ var _ace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ace.js */ "./src/editors/ace.js");
/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./array.js */ "./src/editors/array.js");
/* harmony import */ var _array_choices_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./array/choices.js */ "./src/editors/array/choices.js");
/* harmony import */ var _array_select2_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./array/select2.js */ "./src/editors/array/select2.js");
/* harmony import */ var _array_selectize_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./array/selectize.js */ "./src/editors/array/selectize.js");
/* harmony import */ var _autocomplete_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./autocomplete.js */ "./src/editors/autocomplete.js");
/* harmony import */ var _base64_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./base64.js */ "./src/editors/base64.js");
/* harmony import */ var _button_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./button.js */ "./src/editors/button.js");
/* harmony import */ var _checkbox_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./checkbox.js */ "./src/editors/checkbox.js");
/* harmony import */ var _choices_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./choices.js */ "./src/editors/choices.js");
/* harmony import */ var _datetime_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./datetime.js */ "./src/editors/datetime.js");
/* harmony import */ var _describedby_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./describedby.js */ "./src/editors/describedby.js");
/* harmony import */ var _enum_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./enum.js */ "./src/editors/enum.js");
/* harmony import */ var _hidden_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./hidden.js */ "./src/editors/hidden.js");
/* harmony import */ var _info_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./info.js */ "./src/editors/info.js");
/* harmony import */ var _integer_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./integer.js */ "./src/editors/integer.js");
/* harmony import */ var _ip_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./ip.js */ "./src/editors/ip.js");
/* harmony import */ var _jodit_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./jodit.js */ "./src/editors/jodit.js");
/* harmony import */ var _multiple_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./multiple.js */ "./src/editors/multiple.js");
/* harmony import */ var _multiselect_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./multiselect.js */ "./src/editors/multiselect.js");
/* harmony import */ var _null_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./null.js */ "./src/editors/null.js");
/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./number.js */ "./src/editors/number.js");
/* harmony import */ var _object_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./object.js */ "./src/editors/object.js");
/* harmony import */ var _radio_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./radio.js */ "./src/editors/radio.js");
/* harmony import */ var _sceditor_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./sceditor.js */ "./src/editors/sceditor.js");
/* harmony import */ var _select_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./select.js */ "./src/editors/select.js");
/* harmony import */ var _select2_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./select2.js */ "./src/editors/select2.js");
/* harmony import */ var _selectize_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./selectize.js */ "./src/editors/selectize.js");
/* harmony import */ var _signature_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./signature.js */ "./src/editors/signature.js");
/* harmony import */ var _simplemde_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./simplemde.js */ "./src/editors/simplemde.js");
/* harmony import */ var _starrating_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./starrating.js */ "./src/editors/starrating.js");
/* harmony import */ var _stepper_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./stepper.js */ "./src/editors/stepper.js");
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _table_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./table.js */ "./src/editors/table.js");
/* harmony import */ var _upload_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./upload.js */ "./src/editors/upload.js");
/* harmony import */ var _uuid_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./uuid.js */ "./src/editors/uuid.js");
/* harmony import */ var _colorpicker_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./colorpicker.js */ "./src/editors/colorpicker.js");
/* Internal helper function called only here so we won't export as part of class */
/* Previously the assignment to the JSONEditor.defaults.editors was done in each of the editor */
/* files but doing it this way removes each of the editors' dependency on JSONEditor */






































var editors = {
  ace: _ace_js__WEBPACK_IMPORTED_MODULE_0__.AceEditor,
  array: _array_js__WEBPACK_IMPORTED_MODULE_1__.ArrayEditor,
  arrayChoices: _array_choices_js__WEBPACK_IMPORTED_MODULE_2__.ArrayChoicesEditor,
  arraySelect2: _array_select2_js__WEBPACK_IMPORTED_MODULE_3__.ArraySelect2Editor,
  arraySelectize: _array_selectize_js__WEBPACK_IMPORTED_MODULE_4__.ArraySelectizeEditor,
  autocomplete: _autocomplete_js__WEBPACK_IMPORTED_MODULE_5__.AutocompleteEditor,
  base64: _base64_js__WEBPACK_IMPORTED_MODULE_6__.Base64Editor,
  button: _button_js__WEBPACK_IMPORTED_MODULE_7__.ButtonEditor,
  checkbox: _checkbox_js__WEBPACK_IMPORTED_MODULE_8__.CheckboxEditor,
  choices: _choices_js__WEBPACK_IMPORTED_MODULE_9__.ChoicesEditor,
  datetime: _datetime_js__WEBPACK_IMPORTED_MODULE_10__.DatetimeEditor,
  describedBy: _describedby_js__WEBPACK_IMPORTED_MODULE_11__.DescribedByEditor,
  "enum": _enum_js__WEBPACK_IMPORTED_MODULE_12__.EnumEditor,
  hidden: _hidden_js__WEBPACK_IMPORTED_MODULE_13__.HiddenEditor,
  info: _info_js__WEBPACK_IMPORTED_MODULE_14__.InfoEditor,
  integer: _integer_js__WEBPACK_IMPORTED_MODULE_15__.IntegerEditor,
  ip: _ip_js__WEBPACK_IMPORTED_MODULE_16__.IpEditor,
  jodit: _jodit_js__WEBPACK_IMPORTED_MODULE_17__.JoditEditor,
  multiple: _multiple_js__WEBPACK_IMPORTED_MODULE_18__.MultipleEditor,
  multiselect: _multiselect_js__WEBPACK_IMPORTED_MODULE_19__.MultiSelectEditor,
  "null": _null_js__WEBPACK_IMPORTED_MODULE_20__.NullEditor,
  number: _number_js__WEBPACK_IMPORTED_MODULE_21__.NumberEditor,
  object: _object_js__WEBPACK_IMPORTED_MODULE_22__.ObjectEditor,
  radio: _radio_js__WEBPACK_IMPORTED_MODULE_23__.RadioEditor,
  sceditor: _sceditor_js__WEBPACK_IMPORTED_MODULE_24__.ScEditor,
  select: _select_js__WEBPACK_IMPORTED_MODULE_25__.SelectEditor,
  select2: _select2_js__WEBPACK_IMPORTED_MODULE_26__.Select2Editor,
  selectize: _selectize_js__WEBPACK_IMPORTED_MODULE_27__.SelectizeEditor,
  signature: _signature_js__WEBPACK_IMPORTED_MODULE_28__.SignatureEditor,
  simplemde: _simplemde_js__WEBPACK_IMPORTED_MODULE_29__.SimplemdeEditor,
  starrating: _starrating_js__WEBPACK_IMPORTED_MODULE_30__.StarratingEditor,
  stepper: _stepper_js__WEBPACK_IMPORTED_MODULE_31__.StepperEditor,
  string: _string_js__WEBPACK_IMPORTED_MODULE_32__.StringEditor,
  table: _table_js__WEBPACK_IMPORTED_MODULE_33__.TableEditor,
  upload: _upload_js__WEBPACK_IMPORTED_MODULE_34__.UploadEditor,
  uuid: _uuid_js__WEBPACK_IMPORTED_MODULE_35__.UuidEditor,
  colorpicker: _colorpicker_js__WEBPACK_IMPORTED_MODULE_36__.ColorEditor
};

/***/ }),

/***/ "./src/editors/info.js":
/*!*****************************!*\
  !*** ./src/editors/info.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InfoEditor: () => (/* binding */ InfoEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _button_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./button.js */ "./src/editors/button.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* Non-Active editor for displaying text blocks in form */

var InfoEditor = /*#__PURE__*/function (_ButtonEditor) {
  function InfoEditor() {
    _classCallCheck(this, InfoEditor);
    return _callSuper(this, InfoEditor, arguments);
  }
  _inherits(InfoEditor, _ButtonEditor);
  return _createClass(InfoEditor, [{
    key: "build",
    value: function build() {
      this.options.compact = false;
      this.header = this.label = this.theme.getLabelLike(this.getTitle());
      this.description = this.theme.getDescription(this.schema.description || '');
      this.control = this.theme.getFormControl(this.label, this.description, null);
      this.container.appendChild(this.control);
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return this.translateProperty(this.schema.title);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 12;
    }
  }, {
    key: "disable",
    value: function disable() {
      return false;
    }
  }, {
    key: "enable",
    value: function enable() {
      return false;
    }
  }]);
}(_button_js__WEBPACK_IMPORTED_MODULE_16__.ButtonEditor);

/***/ }),

/***/ "./src/editors/integer.js":
/*!********************************!*\
  !*** ./src/editors/integer.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IntegerEditor: () => (/* binding */ IntegerEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.parse-int.js */ "./node_modules/core-js/modules/es.parse-int.js");
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./number.js */ "./src/editors/number.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }

















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var IntegerEditor = /*#__PURE__*/function (_NumberEditor) {
  function IntegerEditor() {
    _classCallCheck(this, IntegerEditor);
    return _callSuper(this, IntegerEditor, arguments);
  }
  _inherits(IntegerEditor, _NumberEditor);
  return _createClass(IntegerEditor, [{
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      if (!this.schema["default"] && !this.jsoneditor.options.use_default_values && this.value === '') {
        if (this.shouldBeUnset()) {
          return undefined;
        }
      } else {
        return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_18__.isInteger)(this.value) ? parseInt(this.value) : this.value;
      }
    }
  }]);
}(_number_js__WEBPACK_IMPORTED_MODULE_17__.NumberEditor);

/***/ }),

/***/ "./src/editors/ip.js":
/*!***************************!*\
  !*** ./src/editors/ip.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IpEditor: () => (/* binding */ IpEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var IpEditor = /*#__PURE__*/function (_StringEditor) {
  function IpEditor() {
    _classCallCheck(this, IpEditor);
    return _callSuper(this, IpEditor, arguments);
  }
  _inherits(IpEditor, _StringEditor);
  return _createClass(IpEditor, [{
    key: "preBuild",
    value: function preBuild() {
      _get(_getPrototypeOf(IpEditor.prototype), "preBuild", this).call(this);

      /* Create schema options object if deesn't exist */
      if (!this.schema.options) {
        this.schema.options = {};
      }

      /* Create cleave options if they don't exist */
      if (!this.schema.options.cleave) {
        switch (this.format) {
          case 'ipv6':
            this.schema.options.cleave = {
              delimiters: [':'],
              blocks: [4, 4, 4, 4, 4, 4, 4, 4],
              uppercase: true
            };
            break;
          case 'ipv4':
            this.schema.options.cleave = {
              delimiters: ['.'],
              blocks: [3, 3, 3, 3],
              numericOnly: true
            };
            break;
        }
      }

      /* Update options object */
      this.options = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.extend)(this.options, this.schema.options || {});
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_18__.StringEditor);

/***/ }),

/***/ "./src/editors/jodit.js":
/*!******************************!*\
  !*** ./src/editors/jodit.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JoditEditor: () => (/* binding */ JoditEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var JoditEditor = /*#__PURE__*/function (_StringEditor) {
  function JoditEditor() {
    _classCallCheck(this, JoditEditor);
    return _callSuper(this, JoditEditor, arguments);
  }
  _inherits(JoditEditor, _StringEditor);
  return _createClass(JoditEditor, [{
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      var res = _get(_getPrototypeOf(JoditEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
      if (res !== undefined && res.changed && this.jodit_instance) this.jodit_instance.setEditorValue(res.value);
    }
  }, {
    key: "build",
    value: function build() {
      this.options.format = 'textarea'; /* Force format into "textarea" */
      _get(_getPrototypeOf(JoditEditor.prototype), "build", this).call(this);
      this.input_type = this.schema.format; /* Restore original format */
      this.input.setAttribute('data-schemaformat', this.input_type);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.Jodit) {
        /* Get options, either global options from "this.defaults.options.jodit" or */
        /* single property options from schema "options.jodit" */
        options = this.expandCallbacks('jodit', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.extend)({}, {
          height: 300
        }, this.defaults.options.jodit || {}, this.options.jodit || {}));
        this.jodit_instance = new window.Jodit(this.input, options);
        if (this.schema.readOnly || this.schema.readonly || this.schema.template) {
          this.jodit_instance.setReadOnly(true);
        }
        this.jodit_instance.events.on('change', function () {
          _this.value = _this.jodit_instance.getEditorValue();
          _this.is_dirty = true;
          _this.onChange(true);
        });
        this.theme.afterInputReady(this.input);
      } else _get(_getPrototypeOf(JoditEditor.prototype), "afterInputReady", this).call(this); /* Library not loaded, so just treat this as a string */
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 6;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.jodit_instance) this.jodit_instance.setReadOnly(false);
      _get(_getPrototypeOf(JoditEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.jodit_instance) this.jodit_instance.setReadOnly(true);
      _get(_getPrototypeOf(JoditEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.jodit_instance) {
        this.jodit_instance.destruct();
        this.jodit_instance = null;
      }
      _get(_getPrototypeOf(JoditEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_18__.StringEditor);

/***/ }),

/***/ "./src/editors/multiple.js":
/*!*********************************!*\
  !*** ./src/editors/multiple.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultipleEditor: () => (/* binding */ MultipleEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ "./node_modules/core-js/modules/es.array.index-of.js");
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.string.starts-with.js */ "./node_modules/core-js/modules/es.string.starts-with.js");
/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _validator_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../validator.js */ "./src/validator.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* Multiple Editor (for when `type` is an array, also when `oneOf` is present) */



var MultipleEditor = /*#__PURE__*/function (_AbstractEditor) {
  function MultipleEditor() {
    _classCallCheck(this, MultipleEditor);
    return _callSuper(this, MultipleEditor, arguments);
  }
  _inherits(MultipleEditor, _AbstractEditor);
  return _createClass(MultipleEditor, [{
    key: "register",
    value: function register() {
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].unregister();
        }
        if (this.editors[this.type]) this.editors[this.type].register();
      }
      _get(_getPrototypeOf(MultipleEditor.prototype), "register", this).call(this);
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(MultipleEditor.prototype), "unregister", this).call(this);
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].unregister();
        }
      }
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      if (!this.editors[this.type]) return 4;
      return Math.max(this.editors[this.type].getNumColumns(), 4);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        if (this.editors) {
          for (var i = 0; i < this.editors.length; i++) {
            if (!this.editors[i]) continue;
            this.editors[i].enable();
          }
        }
        this.switcher.disabled = false;
        _get(_getPrototypeOf(MultipleEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      if (this.editors) {
        for (var i = 0; i < this.editors.length; i++) {
          if (!this.editors[i]) continue;
          this.editors[i].disable(alwaysDisabled);
        }
      }
      this.switcher.disabled = true;
      _get(_getPrototypeOf(MultipleEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "switchEditor",
    value: function switchEditor(i) {
      var _this = this;
      this.lastType = this.type;
      if (!this.editors[i]) {
        this.buildChildEditor(i);
      }
      var currentValue = this.getValue();
      this.type = i;
      this.register();
      this.editors.forEach(function (editor, type) {
        if (!editor) return;
        if (_this.type === type) {
          if (_this.keep_only_existing_values) {
            currentValue = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.overwriteExistingProperties)(editor.getValue(), currentValue);
          }
          if (_this.keep_values || _this["if"]) editor.setValue(currentValue, true);
          editor.container.style.display = '';
        } else {
          editor.container.style.display = 'none';
        }
      });
      this.onChange(true, false, {
        event: 'switch',
        data: {
          type: this.lastType,
          path: this.editors[i].path
        }
      });
      this.refreshValue();
      this.refreshHeaderText();
    }
  }, {
    key: "buildChildEditor",
    value: function buildChildEditor(i) {
      var _schema,
        _this2 = this;
      var type = this.types[i];
      var holder = this.theme.getChildEditorHolder();
      this.editor_holder.appendChild(holder);
      var schema;
      if (typeof type === 'string') {
        schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.extend)({}, this.schema);
        schema.type = type;
      } else {
        schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.extend)({}, this.schema, type);
        schema = this.jsoneditor.expandRefs(schema);

        /* If we need to merge `required` arrays */
        if (type && type.required && Array.isArray(type.required) && this.schema.required && Array.isArray(this.schema.required)) {
          schema.required = this.schema.required.concat(type.required);
        }
      }
      if ((_schema = schema) !== null && _schema !== void 0 && (_schema = _schema.options) !== null && _schema !== void 0 && _schema.dependencies) {
        delete schema.options.dependencies;
      }
      var editor = this.jsoneditor.getEditorClass(schema);
      this.editors[i] = this.jsoneditor.createEditor(editor, {
        jsoneditor: this.jsoneditor,
        schema: schema,
        container: holder,
        path: this.path,
        parent: this,
        required: true
      });
      this.editors[i].preBuild();
      this.editors[i].build();
      this.editors[i].postBuild();
      if (this.editors[i].header) {
        this.theme.visuallyHidden(this.editors[i].header);
      }
      this.editors[i].option = this.switcher_options[i];
      holder.addEventListener('change_header_text', function () {
        _this2.refreshHeaderText();
      });
      if (i !== this.type) holder.style.display = 'none';
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      this.types = [];
      this.type = 0;
      this.editors = [];
      this.validators = [];
      this.keep_values = true;
      if (typeof this.jsoneditor.options.keep_oneof_values !== 'undefined') this.keep_values = this.jsoneditor.options.keep_oneof_values;
      if (typeof this.options.keep_oneof_values !== 'undefined') this.keep_values = this.options.keep_oneof_values;
      this.keep_only_existing_values = false;
      if (typeof this.jsoneditor.options.keep_only_existing_values !== 'undefined') this.keep_only_existing_values = this.jsoneditor.options.keep_only_existing_values;
      if (typeof this.options.keep_only_existing_values !== 'undefined') this.keep_only_existing_values = this.options.keep_only_existing_values;
      if (this.schema.oneOf) {
        this.oneOf = true;
        this.types = this.schema.oneOf;
        delete this.schema.oneOf;
      } else if (this.schema.anyOf) {
        this.anyOf = true;
        this.types = this.schema.anyOf;
        delete this.schema.anyOf;
      } else if (this.schema["if"]) {
        this["if"] = true;
        this.ifSchema = JSON.parse(JSON.stringify(this.schema["if"]));
        this.thenSchema = {
          title: 'then'
        };
        this.elseSchema = {
          title: 'else'
        };
        this.types = [];
        if (this.schema.then) {
          (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.mergeDeep)(this.thenSchema, this.schema, this.schema.then);
        }
        if (this.schema["else"]) {
          (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.mergeDeep)(this.elseSchema, this.schema, this.schema["else"]);
        }
        this.types.push(this.thenSchema);
        this.types.push(this.elseSchema);
        this.types.forEach(function (schema) {
          delete schema["if"];
          delete schema.then;
          delete schema["else"];
        });
        delete this.schema["if"];
      } else {
        if (!this.schema.type || this.schema.type === 'any') {
          this.types = ['string', 'number', 'integer', 'boolean', 'object', 'array', 'null'];

          /* If any of these primitive types are disallowed */
          if (this.schema.disallow) {
            var disallow = this.schema.disallow;
            if (_typeof(disallow) !== 'object' || !Array.isArray(disallow)) {
              disallow = [disallow];
            }
            var allowedTypes = [];
            this.types.forEach(function (type) {
              if (!disallow.includes(type)) allowedTypes.push(type);
            });
            this.types = allowedTypes;
          }
        } else if (Array.isArray(this.schema.type)) {
          this.types = this.schema.type;
        } else {
          this.types = [this.schema.type];
        }
        delete this.schema.type;
      }
      this.display_text = this.getDisplayText(this.types);
    }
  }, {
    key: "build",
    value: function build() {
      var _this3 = this;
      var container = this.container;
      this.header = this.label = this.theme.getLabelLike(this.getTitle(), this.isRequired());
      this.switcher = this.theme.getSwitcher(this.display_text);
      this.switcher.setAttribute('id', this.formname + 'switcher');
      this.switcherLabel = this.theme.getHiddenLabel(this.formname + ' switcher');
      this.switcherLabel.setAttribute('for', this.formname + 'switcher');
      if (!this["if"]) {
        this.container.appendChild(this.header);
        container.appendChild(this.switcherLabel);
        container.appendChild(this.switcher);
      }
      this.switcher.addEventListener('change', function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this3.switchEditor(_this3.display_text.indexOf(e.currentTarget.value));
        _this3.onChange(true);
      });
      this.editor_holder = document.createElement('div');
      container.appendChild(this.editor_holder);
      var validatorOptions = {};
      if (this.jsoneditor.options.custom_validators) {
        validatorOptions.custom_validators = this.jsoneditor.options.custom_validators;
      }
      this.switcher_options = this.theme.getSwitcherOptions(this.switcher);
      this.types.forEach(function (type, i) {
        _this3.editors[i] = false;
        var schema;
        if (typeof type === 'string') {
          schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.extend)({}, _this3.schema);
          schema.type = type;
        } else {
          schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.extend)({}, _this3.schema, type);

          /* If we need to merge `required` arrays */
          if (type.required && Array.isArray(type.required) && _this3.schema.required && Array.isArray(_this3.schema.required)) {
            schema.required = _this3.schema.required.concat(type.required);
          }
        }
        _this3.validators[i] = new _validator_js__WEBPACK_IMPORTED_MODULE_33__.Validator(_this3.jsoneditor, schema, validatorOptions, _this3.defaults);
      });
      this.jsoneditor.on('change', function () {
        _this3.switchIf();
      });
      this.switchEditor(0);
    }
  }, {
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      if (this.editors[this.type]) {
        this.refreshValue();
        this.refreshHeaderText();
      }
      _get(_getPrototypeOf(MultipleEditor.prototype), "onChildEditorChange", this).call(this, editor, eventData);
    }
  }, {
    key: "refreshHeaderText",
    value: function refreshHeaderText() {
      var displayText = this.getDisplayText(this.types);
      Array.from(this.switcher_options).forEach(function (option, i) {
        option.textContent = displayText[i];
      });
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      if (!this.editors[this.type]) {
        return;
      }
      this.value = this.editors[this.type].getValue();
    }
  }, {
    key: "switchIf",
    value: function switchIf() {
      if (this.ifSchema && this.value) {
        var type = this.getIfType(this.value);
        if (this.lastType !== type) {
          this.switchEditor(type);
          this.editors[this.type].setValue(this.value, true);
        }
        this.switcher.value = this.display_text[this.type];
      }
    }
  }, {
    key: "getIfType",
    value: function getIfType(value) {
      var errors = this.jsoneditor.validator._validateSchema(this.ifSchema, value);
      return errors.length === 0 ? 0 : 1;
    }
  }, {
    key: "setValue",
    value: function setValue(val, initial) {
      var _this4 = this;
      val = this.applyConstFilter(val);

      /* Determine type by getting the first one that validates */

      var prevType = this.type;
      /* find the best match one */
      var fitTestVal = {
        match: 0,
        extra: 0,
        i: this.type
      };
      var validVal = {
        match: 0,
        i: null
      };
      this.validators.forEach(function (validator, i) {
        var fitTestResult = null;
        if (typeof _this4.anyOf !== 'undefined' && _this4.anyOf) {
          fitTestResult = validator.fitTest(val);
          if (fitTestVal.match < fitTestResult.match) {
            fitTestVal = fitTestResult;
            fitTestVal.i = i;
          } else if (fitTestVal.match === fitTestResult.match) {
            if (fitTestVal.extra > fitTestResult.extra) {
              fitTestVal = fitTestResult;
              fitTestVal.i = i;
            }
          }
        }
        if (!validator.validate(val).length && validVal.i === null) {
          validVal.i = i;
          if (fitTestResult !== null) {
            validVal.match = fitTestResult.match;
          }
        } else {
          fitTestVal = validVal;
        }
      });
      var finalI = validVal.i;
      /* if the best fit schema has more match properties, then use the best fit schema. */
      /* usually the value could be */
      if (typeof this.anyOf !== 'undefined' && this.anyOf) {
        if (validVal.match < fitTestVal.match) {
          finalI = fitTestVal.i;
        }
      }
      if (this["if"]) {
        finalI = this.getIfType(val);
      }
      if (finalI === null) {
        finalI = this.type;
      }
      this.type = finalI;
      this.switcher.value = this.display_text[finalI];
      var typeChanged = this.type !== prevType;
      if (typeChanged) {
        this.switchEditor(this.type);
        this.editors[this.type].setValue(val, initial);
      }
      if (typeof val !== 'undefined') {
        this.editors[this.type].setValue(val, initial);
      }
      this.refreshValue();
      this.onChange(typeChanged);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.editors.forEach(function (editor) {
        if (editor) editor.destroy();
      });
      if (this.editor_holder && this.editor_holder.parentNode) this.editor_holder.parentNode.removeChild(this.editor_holder);
      if (this.switcher && this.switcher.parentNode) this.switcher.parentNode.removeChild(this.switcher);
      _get(_getPrototypeOf(MultipleEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this5 = this;
      /* oneOf and anyOf error paths need to remove the oneOf[i] part before passing to child editors */
      if (this.oneOf || this.anyOf) {
        var checkPart = this.oneOf ? 'oneOf' : 'anyOf';
        this.editors.forEach(function (editor, i) {
          if (!editor) return;
          var check = "".concat(_this5.path, ".").concat(checkPart, "[").concat(i, "]");
          var filterError = function filterError(newErrors, error) {
            if (error.path.startsWith(check) || error.path === check.substr(0, error.path.length)) {
              var newError = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_34__.extend)({}, error);
              if (error.path.startsWith(check)) {
                newError.path = _this5.path + newError.path.substr(check.length);
              }
              newErrors.push(newError);
            }
            return newErrors;
          };
          editor.showValidationErrors(errors.reduce(filterError, []));
        });
      } else {
        this.editors.forEach(function (editor) {
          if (!editor) return;
          editor.showValidationErrors(errors);
        });
      }
    }
  }, {
    key: "addLinks",
    value: function addLinks() {
      // multiple editor itself don't create links
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_32__.AbstractEditor);

/***/ }),

/***/ "./src/editors/multiselect.js":
/*!************************************!*\
  !*** ./src/editors/multiselect.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiSelectEditor: () => (/* binding */ MultiSelectEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }



































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var MultiSelectEditor = /*#__PURE__*/function (_AbstractEditor) {
  function MultiSelectEditor() {
    _classCallCheck(this, MultiSelectEditor);
    return _callSuper(this, MultiSelectEditor, arguments);
  }
  _inherits(MultiSelectEditor, _AbstractEditor);
  return _createClass(MultiSelectEditor, [{
    key: "onInputChange",
    value: function onInputChange() {
      this.value = this.input.value;
      this.onChange(true);
    }
  }, {
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "register", this).call(this);
      if (!this.input) return;
      if (this.jsoneditor.options.use_name_attributes) {
        this.input.setAttribute('name', this.formname);
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "unregister", this).call(this);
      if (!this.input) return;
      this.input.removeAttribute('name');
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      var _this = this;
      var longestText = this.getTitle().length;
      Object.keys(this.select_values).forEach(function (i) {
        return longestText = Math.max(longestText, "".concat(_this.select_values[i]).length + 4);
      });
      return Math.min(12, Math.max(longestText / 7, 2));
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "preBuild", this).call(this);
      this.select_options = {};
      this.select_values = {};
      this.option_titles = [];
      this.option_keys = [];
      this.option_enum = [];
      var i;
      var itemsSchema = this.jsoneditor.expandRefs(this.schema.items || {});
      var e = itemsSchema["enum"] || [];
      var oe = itemsSchema.options ? itemsSchema.options["enum"] || [] : [];
      /* fallback to enum_titles, when options.enum is not present */
      var t = itemsSchema.options ? itemsSchema.options.enum_titles || [] : [];
      for (i = 0; i < e.length; i++) {
        /* If the sanitized value is different from the enum value, don't include it */
        if (this.sanitize(e[i]) !== e[i]) continue;
        var d = oe[i] || {};
        if (!('title' in d)) d.title = "".concat(t[i] || e[i]);
        this.option_keys.push("".concat(e[i]));
        this.option_enum.push(d);
        this.select_values["".concat(e[i])] = e[i];
      }
    }
  }, {
    key: "build",
    value: function build() {
      var _this2 = this;
      var i;
      if (!this.options.compact) this.header = this.label = this.theme.getLabelLike(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.compact) this.container.classList.add('compact');
      if (!this.schema.format && this.option_keys.length < 8 || this.schema.format === 'checkbox') {
        this.input_type = 'checkboxes';
        this.inputs = {};
        this.controls = {};
        for (i = 0; i < this.option_keys.length; i++) {
          var id = this.formname + i.toString();
          this.inputs[this.option_keys[i]] = this.theme.getCheckbox();
          this.inputs[this.option_keys[i]].id = id;
          this.select_options[this.option_keys[i]] = this.inputs[this.option_keys[i]];
          var label = this.theme.getCheckboxLabel(this.option_enum[i].title);
          label.htmlFor = id;
          if (this.option_enum[i].infoText) {
            var infoButton = this.theme.getInfoButton(this.translateProperty(this.option_enum[i].infoText));
            label.appendChild(infoButton);
          }
          this.controls['_' + this.option_keys[i]] = this.theme.getFormControl(label, this.inputs[this.option_keys[i]]);
        }
        this.control = this.theme.getMultiCheckboxHolder(this.controls, this.label, this.description, this.infoButton);
        this.inputs.controlgroup = this.inputs.controls = this.control; /* Enable error messages for checkboxes */
      } else {
        if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
        this.input_type = 'select';
        this.input = this.theme.getSelectInput(this.option_keys, true);
        this.theme.setSelectOptions(this.input, this.option_keys, this.option_enum.map(function (e) {
          return e.title;
        }));
        /* this.input.multiple = true; */
        this.input.setAttribute('multiple', 'multiple');
        this.input.size = Math.min(10, this.option_keys.length);
        for (i = 0; i < this.option_keys.length; i++) {
          this.select_options[this.option_keys[i]] = this.input.children[i];
        }
        this.control = this.theme.getFormControl(this.label, this.input, this.description, this.infoButton, this.formname);
      }
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable(true);
      }
      this.container.appendChild(this.control);
      this.multiselectChangeHandler = function (e) {
        var newValue = [];
        for (i = 0; i < _this2.option_keys.length; i++) {
          if (_this2.select_options[_this2.option_keys[i]] && (_this2.select_options[_this2.option_keys[i]].selected || _this2.select_options[_this2.option_keys[i]].checked)) newValue.push(_this2.select_values[_this2.option_keys[i]]);
        }
        _this2.updateValue(newValue);
        _this2.onChange(true);
      };
      this.control.addEventListener('change', this.multiselectChangeHandler, false);

      /* Any special formatting that needs to happen after the input is added to the dom */
      window.requestAnimationFrame(function () {
        _this2.afterInputReady();
      });
    }
  }, {
    key: "postBuild",
    value: function postBuild() {
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "postBuild", this).call(this);
      /* this.theme.afterInputReady(this.input || this.inputs); */
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      this.theme.afterInputReady(this.input || this.inputs);
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial) {
      var _this3 = this;
      value = this.applyConstFilter(value);
      value = value || [];
      if (!Array.isArray(value)) value = [value];

      /* Make sure we are dealing with an array of strings so we can check for strict equality */
      value = value.map(function (e) {
        return "".concat(e);
      });

      /* Update selected status of options */
      Object.keys(this.select_options).forEach(function (i) {
        _this3.select_options[i][_this3.input_type === 'select' ? 'selected' : 'checked'] = value.includes(i);
      });
      this.updateValue(value);
      this.onChange(true);
    }
  }, {
    key: "removeValue",
    value: function removeValue(value) {
      /* Remove from existing value(s) */
      value = [].concat(value);
      this.setValue(this.getValue().filter(function (item) {
        return !value.includes(item);
      }));
    }
  }, {
    key: "addValue",
    value: function addValue(value) {
      /* Add to existing value(s) */
      this.setValue(this.getValue().concat(value));
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      var changed = false;
      var newValue = [];
      for (var i = 0; i < value.length; i++) {
        if (!this.select_options["".concat(value[i])]) {
          changed = true;
          continue;
        }
        var sanitized = this.sanitize(this.select_values[value[i]]);
        newValue.push(sanitized);
        if (sanitized !== value[i]) changed = true;
      }
      this.value = newValue;
      return changed;
    }
  }, {
    key: "sanitize",
    value: function sanitize(value) {
      if (this.schema.items.type === 'boolean') return !!value;else if (this.schema.items.type === 'number') return 1 * value || 0;else if (this.schema.items.type === 'integer') return Math.floor(value * 1 || 0);
      return "".concat(value);
    }
  }, {
    key: "enable",
    value: function enable() {
      var _this4 = this;
      if (!this.always_disabled) {
        if (this.input) {
          this.input.disabled = false;
        } else if (this.inputs) {
          Object.keys(this.inputs).forEach(function (i) {
            return _this4.inputs[i].disabled = false;
          });
        }
        _get(_getPrototypeOf(MultiSelectEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      var _this5 = this;
      if (alwaysDisabled) this.always_disabled = true;
      if (this.input) {
        this.input.disabled = true;
      } else if (this.inputs) {
        Object.keys(this.inputs).forEach(function (i) {
          return _this5.inputs[i].disabled = true;
        });
      }
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      _get(_getPrototypeOf(MultiSelectEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "escapeRegExp",
    value: function escapeRegExp(string) {
      return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var regexPath = new RegExp("^".concat(this.escapeRegExp(this.path), "(\\.\\d+)?$"));
      var addMessage = function addMessage(messages, error) {
        if (error.path.match(regexPath)) {
          messages.push(error.message);
        }
        return messages;
      };
      var messages = errors.reduce(addMessage, []);
      if (messages.length) {
        this.theme.addInputError(this.input || this.inputs, "".concat(messages.join('. '), "."));
      } else {
        this.theme.removeInputError(this.input || this.inputs);
      }
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_35__.AbstractEditor);

/***/ }),

/***/ "./src/editors/null.js":
/*!*****************************!*\
  !*** ./src/editors/null.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NullEditor: () => (/* binding */ NullEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var NullEditor = /*#__PURE__*/function (_AbstractEditor) {
  function NullEditor() {
    _classCallCheck(this, NullEditor);
    return _callSuper(this, NullEditor, arguments);
  }
  _inherits(NullEditor, _AbstractEditor);
  return _createClass(NullEditor, [{
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      return null;
    }
  }, {
    key: "setValue",
    value: function setValue() {
      this.onChange();
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_16__.AbstractEditor);

/***/ }),

/***/ "./src/editors/number.js":
/*!*******************************!*\
  !*** ./src/editors/number.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NumberEditor: () => (/* binding */ NumberEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.parse-float.js */ "./node_modules/core-js/modules/es.parse-float.js");
/* harmony import */ var core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../utilities */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }



















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var NumberEditor = /*#__PURE__*/function (_StringEditor) {
  function NumberEditor() {
    _classCallCheck(this, NumberEditor);
    return _callSuper(this, NumberEditor, arguments);
  }
  _inherits(NumberEditor, _StringEditor);
  return _createClass(NumberEditor, [{
    key: "build",
    value: function build() {
      _get(_getPrototypeOf(NumberEditor.prototype), "build", this).call(this);
      if (typeof this.schema.minimum !== 'undefined') {
        var minimum = this.schema.minimum;
        if (typeof this.schema.exclusiveMinimum !== 'undefined') {
          minimum += 1;
        }
        this.input.setAttribute('min', minimum);
      }
      if (typeof this.schema.maximum !== 'undefined') {
        var maximum = this.schema.maximum;
        if (typeof this.schema.exclusiveMaximum !== 'undefined') {
          maximum -= 1;
        }
        this.input.setAttribute('max', maximum);
      }
      if (typeof this.schema.step !== 'undefined') {
        var step = this.schema.step || 1;
        this.input.setAttribute('step', step);
      }

      /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
      this.setInputAttributes(['maxlength', 'pattern', 'readonly', 'min', 'max', 'step']);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      if (!this.schema["default"] && !this.jsoneditor.options.use_default_values && this.value === '') {
        if (this.shouldBeUnset()) {
          this.input.value = '';
          return undefined;
        }
      } else {
        return (0,_utilities__WEBPACK_IMPORTED_MODULE_20__.isNumber)(this.value) ? parseFloat(this.value) : this.value;
      }
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_19__.StringEditor);

/***/ }),

/***/ "./src/editors/object.css.js":
/*!***********************************!*\
  !*** ./src/editors/object.css.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ".je-object__title": "display:inline-block",
  ".je-object__controls": "margin:0%200%200%2010px",
  ".je-object__container": "position:relative",
  ".je-object__property-checkbox": "margin:0;height:auto",
  ".property-selector": "width:295px;max-height:160px;padding:5px%200;overflow-y:auto;overflow-x:hidden;padding-left:5px",
  ".property-selector-input": "width:220px;margin-bottom:0;display:inline-block",
  ".json-editor-btntype-toggle": "margin:0%2010px%200%200",
  ".je-edit-json--textarea": "height:170px;width:300px;display:block"
});
/* eslint-enable */

/***/ }),

/***/ "./src/editors/object.js":
/*!*******************************!*\
  !*** ./src/editors/object.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ObjectEditor: () => (/* binding */ ObjectEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.find.js */ "./node_modules/core-js/modules/es.array.find.js");
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.array.sort.js */ "./node_modules/core-js/modules/es.array.sort.js");
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_define_properties_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.define-properties.js */ "./node_modules/core-js/modules/es.object.define-properties.js");
/* harmony import */ var core_js_modules_es_object_define_properties_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_properties_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptors.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.object.values.js */ "./node_modules/core-js/modules/es.object.values.js");
/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_35__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_36__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_37___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_37__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_38___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_38__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_39___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_39__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_40___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_40__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
/* harmony import */ var _object_css_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./object.css.js */ "./src/editors/object.css.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }









































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }



var ObjectEditor = /*#__PURE__*/function (_AbstractEditor) {
  function ObjectEditor(options, defaults, depth) {
    var _this;
    _classCallCheck(this, ObjectEditor);
    _this = _callSuper(this, ObjectEditor, [options, defaults]);
    _this.currentDepth = depth;
    return _this;
  }
  _inherits(ObjectEditor, _AbstractEditor);
  return _createClass(ObjectEditor, [{
    key: "getChildEditors",
    value: function getChildEditors() {
      return this.editors;
    }
  }, {
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(ObjectEditor.prototype), "register", this).call(this);
      if (this.editors) {
        Object.values(this.editors).forEach(function (e) {
          return e.register();
        });
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(ObjectEditor.prototype), "unregister", this).call(this);
      if (this.editors) {
        Object.values(this.editors).forEach(function (e) {
          return e.unregister();
        });
      }
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return Math.max(Math.min(12, this.maxwidth), 3);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        if (this.editjson_control) this.editjson_control.disabled = false;
        if (this.addproperty_button) this.addproperty_button.disabled = false;
        _get(_getPrototypeOf(ObjectEditor.prototype), "enable", this).call(this);
        if (this.editors) {
          Object.values(this.editors).forEach(function (e) {
            if (e.isActive() || e.isUiOnly) {
              e.enable();
            }
            if (e.optInCheckbox) {
              e.optInCheckbox.disabled = false;
            }
          });
        }
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      if (this.editjson_control) this.editjson_control.disabled = true;
      if (this.addproperty_button) this.addproperty_button.disabled = true;
      this.hideEditJSON();
      _get(_getPrototypeOf(ObjectEditor.prototype), "disable", this).call(this);
      if (this.editors) {
        Object.values(this.editors).forEach(function (e) {
          if (e.isActive() || e.isUiOnly) {
            e.disable(alwaysDisabled);
          }
          e.optInCheckbox.disabled = true;
        });
      }
    }
  }, {
    key: "layoutEditors",
    value: function layoutEditors() {
      var _this2 = this;
      var i;
      var j;
      if (!this.row_container) return;

      /* Sort editors by propertyOrder */
      this.property_order = Object.keys(this.editors);
      this.property_order = this.property_order.sort(function (a, b) {
        var ordera = _this2.editors[a].schema.propertyOrder;
        var orderb = _this2.editors[b].schema.propertyOrder;
        if (typeof ordera !== 'number') ordera = 1000;
        if (typeof orderb !== 'number') orderb = 1000;
        return ordera - orderb;
      });
      var container;
      var isCategoriesFormat = this.format === 'categories';
      var rows = [];
      var key = null;
      var editor = null;
      var row;
      if (this.format === 'grid-strict') {
        var rowIndex = 0;
        row = [];
        this.property_order.forEach(function (key) {
          var editor = _this2.editors[key];
          if (editor.property_removed) {
            return;
          }
          var width = editor.options.hidden ? 0 : editor.options.grid_columns || editor.getNumColumns();
          var offset = editor.options.hidden ? 0 : editor.options.grid_offset || 0;
          var gridBreak = editor.options.hidden ? false : editor.options.grid_break || false;
          var height = editor.options.hidden ? 0 : editor.container.offsetHeight;
          var column = {
            key: key,
            width: width,
            offset: offset,
            height: height
          };
          row.push(column);
          rows[rowIndex] = row;
          if (gridBreak) {
            rowIndex++;
            row = [];
          }
        });

        /* layout hasn't changed */
        if (this.layout === JSON.stringify(rows)) return false;
        this.layout = JSON.stringify(rows);

        /* Layout the form */
        container = document.createElement('div');
        for (i = 0; i < rows.length; i++) {
          row = this.theme.getGridRow();
          container.appendChild(row);
          for (j = 0; j < rows[i].length; j++) {
            key = rows[i][j].key;
            editor = this.editors[key];
            if (editor.options.hidden) {
              editor.container.style.display = 'none';
            } else {
              this.theme.setGridColumnSize(editor.container, rows[i][j].width, rows[i][j].offset);
            }
            row.appendChild(editor.container);
          }
        }
      } else if (this.format === 'grid') {
        this.property_order.forEach(function (key) {
          var editor = _this2.editors[key];
          if (editor.property_removed) return;
          var found = false;
          var width = editor.options.hidden ? 0 : editor.options.grid_columns || editor.getNumColumns();
          var height = editor.options.hidden ? 0 : editor.container.offsetHeight;
          /* See if the editor will fit in any of the existing rows first */
          for (var _i = 0; _i < rows.length; _i++) {
            /* If the editor will fit in the row horizontally */
            if (rows[_i].width + width <= 12) {
              /* If the editor is close to the other elements in height */
              /* i.e. Don't put a really tall editor in an otherwise short row or vice versa */
              if (!height || rows[_i].minh * 0.5 < height && rows[_i].maxh * 2 > height) {
                found = _i;
              }
            }
          }

          /* If there isn't a spot in any of the existing rows, start a new row */
          if (found === false) {
            rows.push({
              width: 0,
              minh: 999999,
              maxh: 0,
              editors: []
            });
            found = rows.length - 1;
          }
          rows[found].editors.push({
            key: key,
            /* editor: editor, */
            width: width,
            height: height
          });
          rows[found].width += width;
          rows[found].minh = Math.min(rows[found].minh, height);
          rows[found].maxh = Math.max(rows[found].maxh, height);
        });

        /* Make almost full rows width 12 */
        /* Do this by increasing all editors' sizes proprotionately */
        /* Any left over space goes to the biggest editor */
        /* Don't touch rows with a width of 6 or less */
        for (i = 0; i < rows.length; i++) {
          if (rows[i].width < 12) {
            var biggest = false;
            var newWidth = 0;
            for (j = 0; j < rows[i].editors.length; j++) {
              if (biggest === false) biggest = j;else if (rows[i].editors[j].width > rows[i].editors[biggest].width) biggest = j;
              rows[i].editors[j].width *= 12 / rows[i].width;
              rows[i].editors[j].width = Math.floor(rows[i].editors[j].width);
              newWidth += rows[i].editors[j].width;
            }
            if (newWidth < 12) rows[i].editors[biggest].width += 12 - newWidth;
            rows[i].width = 12;
          }
        }

        /* layout hasn't changed */
        if (this.layout === JSON.stringify(rows)) return false;
        this.layout = JSON.stringify(rows);

        /* Layout the form */
        container = document.createElement('div');
        for (i = 0; i < rows.length; i++) {
          row = this.theme.getGridRow();
          container.appendChild(row);
          for (j = 0; j < rows[i].editors.length; j++) {
            key = rows[i].editors[j].key;
            editor = this.editors[key];
            if (editor.options.hidden) editor.container.style.display = 'none';else this.theme.setGridColumnSize(editor.container, rows[i].editors[j].width);
            row.appendChild(editor.container);
          }
        }
        /* Normal layout */
      } else {
        container = document.createElement('div');
        if (isCategoriesFormat) {
          /* A container for properties not object nor arrays */
          var containerSimple = document.createElement('div');
          /* This will be the place to (re)build tabs and panes */
          /* tabs_holder has 2 childs, [0]: ul.nav.nav-tabs and [1]: div.tab-content */
          var newTabsHolder = this.theme.getTopTabHolder(this.translateProperty(this.schema.title));
          /* child [1] of previous, stores panes */
          var newTabPanesContainer = this.theme.getTopTabContentHolder(newTabsHolder);
          this.property_order.forEach(function (key) {
            var editor = _this2.editors[key];
            if (editor.property_removed) return;
            var aPane = _this2.theme.getTabContent();
            var isObjOrArray = editor.schema && (editor.schema.type === 'object' || editor.schema.type === 'array');
            /* mark the pane */
            aPane.isObjOrArray = isObjOrArray;
            var gridRow = _this2.theme.getGridRow();

            /* this happens with added properties, they don't have a tab */
            if (!editor.tab) {
              /* Pass the pane which holds the editor */
              if (typeof _this2.basicPane === 'undefined') {
                /* There is no basicPane yet, so aPane will be it */
                _this2.addRow(editor, newTabsHolder, aPane);
              } else {
                _this2.addRow(editor, newTabsHolder, _this2.basicPane);
              }
            }
            aPane.id = _this2.getValidId(editor.tab_text.textContent);

            /* For simple properties, add them on the same panel (Basic) */
            if (!isObjOrArray) {
              containerSimple.appendChild(gridRow);
              /* There are already some panes */
              if (newTabPanesContainer.childElementCount > 0) {
                /* If first pane is object or array, insert before a simple pane */
                if (newTabPanesContainer.firstChild.isObjOrArray) {
                  /* Append pane for simple properties */
                  aPane.appendChild(containerSimple);
                  newTabPanesContainer.insertBefore(aPane, newTabPanesContainer.firstChild);
                  /* Add "Basic" tab */
                  _this2.theme.insertBasicTopTab(editor.tab, newTabsHolder);
                  /* newTabs_holder.firstChild.insertBefore(editor.tab,newTabs_holder.firstChild.firstChild); */
                  /* Update the basicPane */
                  editor.basicPane = aPane;
                } else {
                  /* We already have a first "Basic" pane, just add the new property to it, so */
                  /* do nothing; */
                }
                /* There is no pane, so add the first (simple) pane */
              } else {
                /* Append pane for simple properties */
                aPane.appendChild(containerSimple);
                newTabPanesContainer.appendChild(aPane);
                /* Add "Basic" tab */
                /* newTabs_holder.firstChild.appendChild(editor.tab); */
                _this2.theme.addTopTab(newTabsHolder, editor.tab);
                /* Update the basicPane */
                editor.basicPane = aPane;
              }
              /* Objects and arrays earn their own panes */
            } else {
              aPane.appendChild(gridRow);
              newTabPanesContainer.appendChild(aPane);
              /* newTabs_holder.firstChild.appendChild(editor.tab); */
              _this2.theme.addTopTab(newTabsHolder, editor.tab);
            }
            if (editor.options.hidden) editor.container.style.display = 'none';else _this2.theme.setGridColumnSize(editor.container, 12);
            /* Now, add the property editor to the row */
            gridRow.appendChild(editor.container);
            /* Update the rowPane (same as this.rows[x].rowPane) */
            editor.rowPane = aPane;
          });

          /* Erase old panes */
          while (this.tabPanesContainer.firstChild) {
            this.tabPanesContainer.removeChild(this.tabPanesContainer.firstChild);
          }

          /* Erase old tabs and set the new ones */
          var parentTabsHolder = this.tabs_holder.parentNode;
          parentTabsHolder.removeChild(parentTabsHolder.firstChild);
          parentTabsHolder.appendChild(newTabsHolder);
          this.tabPanesContainer = newTabPanesContainer;
          this.tabs_holder = newTabsHolder;

          /* Activate the first tab */
          var firstTab = this.theme.getFirstTab(this.tabs_holder);
          if (firstTab) {
            (0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.trigger)(firstTab, 'click');
          }
          return;
          /* Normal layout */
        }
        this.property_order.forEach(function (key) {
          var editor = _this2.editors[key];
          if (editor.property_removed) return;
          row = _this2.theme.getGridRow();
          container.appendChild(row);
          if (editor.options.hidden) editor.container.style.display = 'none';else _this2.theme.setGridColumnSize(editor.container, 12);
          row.appendChild(editor.container);
        });
      }
      /* for grid and normal layout */
      while (this.row_container.firstChild) {
        this.row_container.removeChild(this.row_container.firstChild);
      }
      this.row_container.appendChild(container);
    }
  }, {
    key: "getPropertySchema",
    value: function getPropertySchema(key) {
      var _this3 = this;
      /* Schema declared directly in properties */
      var schema = this.schema.properties[key] || {};
      schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.extend)({}, schema);
      var matched = !!this.schema.properties[key];

      /* Any matching patternProperties should be merged in */
      if (this.schema.patternProperties) {
        Object.keys(this.schema.patternProperties).forEach(function (i) {
          var regex = new RegExp(i);
          if (regex.test(key)) {
            schema.allOf = schema.allOf || [];
            schema.allOf.push(_this3.schema.patternProperties[i]);
            matched = true;
          }
        });
      }

      /* Hasn't matched other rules, use additionalProperties schema */
      if (!matched && this.schema.additionalProperties && _typeof(this.schema.additionalProperties) === 'object') {
        schema = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.extend)({}, this.schema.additionalProperties);
      }
      return schema;
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      var _this4 = this;
      _get(_getPrototypeOf(ObjectEditor.prototype), "preBuild", this).call(this);
      this.editors = {};
      this.cached_editors = {};
      this.format = this.options.layout || this.options.object_layout || this.schema.format || this.jsoneditor.options.object_layout || 'normal';
      this.schema.properties = this.schema.properties || {};
      this.minwidth = 0;
      this.maxwidth = 0;

      /* If the object should be rendered as a table row */
      if (this.options.table_row) {
        Object.entries(this.schema.properties).forEach(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            schema = _ref2[1];
          var editor = _this4.jsoneditor.getEditorClass(schema);
          _this4.editors[key] = _this4.jsoneditor.createEditor(editor, {
            jsoneditor: _this4.jsoneditor,
            schema: schema,
            path: "".concat(_this4.path, ".").concat(key),
            parent: _this4,
            compact: true,
            required: true
          }, _this4.currentDepth + 1);
          _this4.editors[key].preBuild();
          var width = _this4.editors[key].options.hidden ? 0 : _this4.editors[key].options.grid_columns || _this4.editors[key].getNumColumns();
          _this4.minwidth += width;
          _this4.maxwidth += width;
        });
        this.no_link_holder = true;
        /* If the object should be rendered as a table */
      } else if (this.options.table) {
        /* TODO: table display format */
        throw new Error('Not supported yet');
        /* If the object should be rendered as a div */
      } else {
        if (!this.schema.defaultProperties) {
          if (this.jsoneditor.options.display_required_only || this.options.display_required_only) {
            this.schema.defaultProperties = Object.keys(this.schema.properties).filter(function (k) {
              return _this4.isRequiredObject({
                key: k,
                schema: _this4.schema.properties[k]
              });
            });
          } else {
            this.schema.defaultProperties = Object.keys(this.schema.properties);
          }
        }

        /* Increase the grid width to account for padding */
        this.maxwidth += 1;

        /* Check for array (eg. meta-schema options is an object) */
        if (Array.isArray(this.schema.defaultProperties)) {
          this.schema.defaultProperties.forEach(function (key) {
            _this4.addObjectProperty(key, true);
            if (_this4.editors[key]) {
              _this4.minwidth = Math.max(_this4.minwidth, _this4.editors[key].options.grid_columns || _this4.editors[key].getNumColumns());
              _this4.maxwidth += _this4.editors[key].options.grid_columns || _this4.editors[key].getNumColumns();
            }
          });
        }
      }

      /* Sort editors by propertyOrder */
      this.property_order = Object.keys(this.editors);
      this.property_order = this.property_order.sort(function (a, b) {
        var ordera = _this4.editors[a].schema.propertyOrder;
        var orderb = _this4.editors[b].schema.propertyOrder;
        if (typeof ordera !== 'number') ordera = 1000;
        if (typeof orderb !== 'number') orderb = 1000;
        return ordera - orderb;
      });
    }

    /* "Borrow" from arrays code */
  }, {
    key: "addTab",
    value: function addTab(idx) {
      var _this5 = this;
      var isObjOrArray = this.rows[idx].schema && (this.rows[idx].schema.type === 'object' || this.rows[idx].schema.type === 'array');
      if (this.tabs_holder) {
        this.rows[idx].tab_text = document.createElement('span');
        if (!isObjOrArray) {
          this.rows[idx].tab_text.textContent = typeof this.schema.basicCategoryTitle === 'undefined' ? 'Basic' : this.schema.basicCategoryTitle;
        } else {
          this.rows[idx].tab_text.textContent = this.rows[idx].getHeaderText();
        }
        this.rows[idx].tab = this.theme.getTopTab(this.rows[idx].tab_text, this.getValidId(this.rows[idx].tab_text.textContent));
        this.rows[idx].tab.addEventListener('click', function (e) {
          _this5.active_tab = _this5.rows[idx].tab;
          _this5.refreshTabs();
          e.preventDefault();
          e.stopPropagation();
        });
      }
    }
  }, {
    key: "addRow",
    value: function addRow(editor, tabHolder, aPane) {
      var rowsLen = this.rows.length;
      var isObjOrArray = editor.schema.type === 'object' || editor.schema.type === 'array';

      /* Add a row */
      this.rows[rowsLen] = editor;
      /* rowPane stores the editor corresponding pane to set the display style when refreshing Tabs */
      this.rows[rowsLen].rowPane = aPane;
      if (!isObjOrArray) {
        /* This is the first simple property to be added, */
        /* add a ("Basic") tab for it and save it's row number */
        if (typeof this.basicTab === 'undefined') {
          this.addTab(rowsLen);
          /* Store the index row of the first simple property added */
          this.basicTab = rowsLen;
          this.basicPane = aPane;
          this.theme.addTopTab(tabHolder, this.rows[rowsLen].tab);
        } else {
          /* Any other simple property gets the same tab (and the same pane) as the first one, */
          /* so, when 'click' event is fired from a row, it gets the correct ("Basic") tab */
          this.rows[rowsLen].tab = this.rows[this.basicTab].tab;
          this.rows[rowsLen].tab_text = this.rows[this.basicTab].tab_text;
          this.rows[rowsLen].rowPane = this.rows[this.basicTab].rowPane;
        }
      } else {
        this.addTab(rowsLen);
        this.theme.addTopTab(tabHolder, this.rows[rowsLen].tab);
      }
    }

    /* Mark the active tab and make visible the corresponding pane, hide others */
  }, {
    key: "refreshTabs",
    value: function refreshTabs(refreshHeaders) {
      var _this6 = this;
      var basicTabPresent = typeof this.basicTab !== 'undefined';
      var basicTabRefreshed = false;
      this.rows.forEach(function (row) {
        /* If it's an orphan row (some property which has been deleted), return */
        if (!row.tab || !row.rowPane || !row.rowPane.parentNode) return;
        if (basicTabPresent && row.tab === _this6.rows[_this6.basicTab].tab && basicTabRefreshed) return;
        if (refreshHeaders) {
          row.tab_text.textContent = row.getHeaderText();
        } else {
          /* All rows of simple properties point to the same tab, so refresh just once */
          if (basicTabPresent && row.tab === _this6.rows[_this6.basicTab].tab) basicTabRefreshed = true;
          if (row.tab === _this6.active_tab) {
            _this6.theme.markTabActive(row);
          } else {
            _this6.theme.markTabInactive(row);
          }
        }
      });
    }
  }, {
    key: "build",
    value: function build() {
      var _this7 = this;
      var isCategoriesFormat = this.format === 'categories';
      this.rows = [];
      this.active_tab = null;

      /* If the object should be rendered as a table row */
      if (this.options.table_row) {
        this.editor_holder = this.container;
        Object.entries(this.editors).forEach(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            key = _ref4[0],
            editor = _ref4[1];
          var holder = _this7.theme.getTableCell();
          _this7.editor_holder.appendChild(holder);
          editor.setContainer(holder);
          editor.build();
          editor.postBuild();
          editor.setOptInCheckbox(editor.header);
          editor.setValue(editor.getDefault(), true);
          if (_this7.editors[key].options.hidden) {
            holder.style.display = 'none';
          }
          if (_this7.editors[key].options.input_width) {
            holder.style.width = _this7.editors[key].options.input_width;
          }
        });
        /* If the object should be rendered as a table */
      } else if (this.options.table) {
        /* TODO: table display format */
        throw new Error('Not supported yet');
        /* If the object should be rendered as a div */
      } else {
        this.header = '';
        if (!this.options.compact) {
          this.header = document.createElement('span');
          this.header.textContent = this.getTitle();
        }
        this.title = this.theme.getHeader(this.header, this.getPathDepth());
        this.title.classList.add('je-object__title');
        this.controls = this.theme.getButtonHolder();
        this.controls.classList.add('je-object__controls');
        this.container.appendChild(this.title);
        this.container.appendChild(this.controls);
        this.container.classList.add('je-object__container');

        /* Edit JSON modal */
        this.editjson_holder = this.theme.getModal();
        this.editjson_textarea_label = this.theme.getHiddenLabel(this.translate('button_edit_json'));
        this.editjson_textarea_label.setAttribute('for', this.path + '-' + 'edit-json-textarea');
        this.editjson_textarea = this.theme.getTextareaInput();
        this.editjson_textarea.setAttribute('id', this.path + '-' + 'edit-json-textarea');
        this.editjson_textarea.setAttribute('aria-labelledby', this.path + '-' + 'edit-json-textarea');
        this.editjson_textarea.classList.add('je-edit-json--textarea');
        this.editjson_save = this.getButton('button_save', 'save', 'button_save');
        this.editjson_save.classList.add('json-editor-btntype-save');
        this.editjson_save.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this7.saveJSON();
        });
        this.editjson_copy = this.getButton('button_copy', 'copy', 'button_copy');
        this.editjson_copy.classList.add('json-editor-btntype-copy');
        this.editjson_copy.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this7.copyJSON();
        });
        this.editjson_cancel = this.getButton('button_cancel', 'cancel', 'button_cancel');
        this.editjson_cancel.classList.add('json-editor-btntype-cancel');
        this.editjson_cancel.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this7.hideEditJSON();
        });
        this.editjson_holder.appendChild(this.editjson_textarea_label);
        this.editjson_holder.appendChild(this.editjson_textarea);
        this.editjson_holder.appendChild(this.editjson_save);
        this.editjson_holder.appendChild(this.editjson_copy);
        this.editjson_holder.appendChild(this.editjson_cancel);

        /* Manage Properties modal */
        this.addproperty_holder = this.theme.getModal();
        this.addproperty_list = document.createElement('div');
        this.addproperty_list.classList.add('property-selector');
        this.addproperty_add = this.getButton('button_add', 'add', 'button_add');
        this.addproperty_add.classList.add('json-editor-btntype-add');
        this.addproperty_input = this.theme.getFormInputField('text');
        this.addproperty_input.setAttribute('placeholder', 'Property name...');
        this.addproperty_input_label = this.theme.getHiddenLabel(this.translate('button_properties'));
        this.addproperty_input_label.setAttribute('for', this.path + '-' + 'property-selector');
        this.addproperty_input.classList.add('property-selector-input');
        this.addproperty_input.setAttribute('id', this.path + '-' + 'property-selector');
        this.addproperty_input.setAttribute('aria-labelledby', this.path + '-' + 'property-selector');
        this.addproperty_add.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          if (_this7.addproperty_input.value) {
            if (_this7.editors[_this7.addproperty_input.value]) {
              window.alert('there is already a property with that name');
              return;
            }
            _this7.addObjectProperty(_this7.addproperty_input.value);
            if (_this7.editors[_this7.addproperty_input.value]) {
              _this7.editors[_this7.addproperty_input.value].disable();
            }
            var key = _this7.editors[_this7.addproperty_input.value].key;
            var type = _this7.editors[_this7.addproperty_input.value].type;
            var path = _this7.editors[_this7.addproperty_input.value].path;
            _this7.onChange(true, false, {
              event: 'add',
              data: {
                key: key,
                type: type,
                path: path
              }
            });
          }
        });
        this.addproperty_input.addEventListener('input', function (e) {
          e.target.previousSibling.previousSibling.childNodes.forEach(function (value) {
            var searchTerm = value.innerText;
            var propertyTitle = e.target.value;
            var caseSensitivePropertySearch = _this7.options.case_sensitive_property_search || _this7.jsoneditor.options.case_sensitive_property_search;
            if (!caseSensitivePropertySearch) {
              searchTerm = searchTerm.toLowerCase();
              propertyTitle = propertyTitle.toLowerCase();
            }
            if (searchTerm.includes(propertyTitle)) {
              value.style.display = '';
            } else {
              value.style.display = 'none';
            }
          });
        });
        this.addproperty_holder.appendChild(this.addproperty_list);
        this.addproperty_holder.appendChild(this.addproperty_input_label);
        this.addproperty_holder.appendChild(this.addproperty_input);
        this.addproperty_holder.appendChild(this.addproperty_add);
        var spacer = document.createElement('div');
        spacer.style.clear = 'both';
        this.addproperty_holder.appendChild(spacer);

        /* Close properties modal if clicked outside modal */
        this.onOutsideModalClickListener = this.onOutsideModalClick.bind(this);
        document.addEventListener('click', this.onOutsideModalClickListener, true);

        /* Description */
        if (this.schema.description) {
          this.description = this.theme.getDescription(this.translateProperty(this.schema.description));
          this.container.appendChild(this.description);
        }

        /* Validation error placeholder area */
        this.error_holder = document.createElement('div');
        this.container.appendChild(this.error_holder);

        /* Container for child editor area */
        this.editor_holder = this.theme.getIndentedPanel();
        this.container.appendChild(this.editor_holder);

        /* Container for rows of child editors */
        this.row_container = this.theme.getGridContainer();
        if (isCategoriesFormat) {
          this.tabs_holder = this.theme.getTopTabHolder(this.getValidId(this.translateProperty(this.schema.title)));
          this.tabPanesContainer = this.theme.getTopTabContentHolder(this.tabs_holder);
          this.editor_holder.appendChild(this.tabs_holder);
        } else {
          this.tabs_holder = this.theme.getTabHolder(this.getValidId(this.translateProperty(this.schema.title)));
          this.tabPanesContainer = this.theme.getTabContentHolder(this.tabs_holder);
          this.editor_holder.appendChild(this.row_container);
        }
        Object.values(this.editors).forEach(function (editor) {
          var aPane = _this7.theme.getTabContent();
          var holder = _this7.theme.getGridColumn();
          var isObjOrArray = !!(editor.schema && (editor.schema.type === 'object' || editor.schema.type === 'array'));
          aPane.isObjOrArray = isObjOrArray;
          if (isCategoriesFormat) {
            if (isObjOrArray) {
              var singleRowContainer = _this7.theme.getGridContainer();
              singleRowContainer.appendChild(holder);
              aPane.appendChild(singleRowContainer);
              _this7.tabPanesContainer.appendChild(aPane);
              _this7.row_container = singleRowContainer;
            } else {
              if (typeof _this7.row_container_basic === 'undefined') {
                _this7.row_container_basic = _this7.theme.getGridContainer();
                aPane.appendChild(_this7.row_container_basic);
                if (_this7.tabPanesContainer.childElementCount === 0) {
                  _this7.tabPanesContainer.appendChild(aPane);
                } else {
                  _this7.tabPanesContainer.insertBefore(aPane, _this7.tabPanesContainer.childNodes[1]);
                }
              }
              _this7.row_container_basic.appendChild(holder);
            }
            _this7.addRow(editor, _this7.tabs_holder, aPane);
            aPane.id = _this7.getValidId(editor.schema.title); /* editor.schema.path//tab_text.textContent */
          } else {
            _this7.row_container.appendChild(holder);
          }
          editor.setContainer(holder);
          editor.build();
          editor.postBuild();
          editor.setOptInCheckbox(editor.header);
        });
        if (this.rows[0]) {
          (0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.trigger)(this.rows[0].tab, 'click');
        }

        /* Show/Hide button */
        this.collapsed = false;
        this.collapse_control = this.getButton('', 'collapse', 'button_collapse');
        this.collapse_control.classList.add('json-editor-btntype-toggle');
        this.title.insertBefore(this.collapse_control, this.title.childNodes[0]);
        this.collapse_control.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          if (_this7.collapsed) {
            _this7.editor_holder.style.display = '';
            _this7.collapsed = false;
            _this7.setButtonText(_this7.collapse_control, '', 'collapse', 'button_collapse');
          } else {
            _this7.editor_holder.style.display = 'none';
            _this7.collapsed = true;
            _this7.setButtonText(_this7.collapse_control, '', 'expand', 'button_expand');
          }
        });

        /* If it should start collapsed */
        if (this.options.collapsed) {
          (0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.trigger)(this.collapse_control, 'click');
        }

        /* Collapse button disabled */
        if (this.schema.options && typeof this.schema.options.disable_collapse !== 'undefined') {
          if (this.schema.options.disable_collapse) this.collapse_control.style.display = 'none';
        } else if (this.jsoneditor.options.disable_collapse) {
          this.collapse_control.style.display = 'none';
        }

        /* Edit JSON Button */
        this.editjson_control = this.getButton('JSON', 'edit', 'button_edit_json');
        this.editjson_control.classList.add('json-editor-btntype-editjson');
        this.editjson_control.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this7.toggleEditJSON();
        });
        this.controls.appendChild(this.editjson_control);
        this.controls.insertBefore(this.editjson_holder, this.controls.childNodes[0]);

        /* Edit JSON Buttton disabled */
        if (this.schema.options && typeof this.schema.options.disable_edit_json !== 'undefined') {
          if (this.schema.options.disable_edit_json) this.editjson_control.style.display = 'none';
        } else if (this.jsoneditor.options.disable_edit_json) {
          this.editjson_control.style.display = 'none';
        }

        /* Object Properties Button */
        this.addproperty_button = this.getButton('properties', 'edit_properties', 'button_object_properties');
        this.addproperty_button.classList.add('json-editor-btntype-properties');
        this.addproperty_button.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this7.toggleAddProperty();
        });
        this.controls.appendChild(this.addproperty_button);
        this.controls.insertBefore(this.addproperty_holder, this.controls.childNodes[1]);
        this.refreshAddProperties();

        /* non required properties start deactivated */
        this.deactivateNonRequiredProperties(false);
      }

      /* Fix table cell ordering */
      if (this.options.table_row) {
        this.editor_holder = this.container;
        this.property_order.forEach(function (key) {
          _this7.editor_holder.appendChild(_this7.editors[key].container);
        });
        /* Layout object editors in grid if needed */
      } else {
        /* Initial layout */
        this.layoutEditors();
        /* Do it again now that we know the approximate heights of elements */
        this.layoutEditors();
      }
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable();
      }
    }
  }, {
    key: "deactivateNonRequiredProperties",
    value: function deactivateNonRequiredProperties(recursive) {
      var _this8 = this;
      /* the show_opt_in editor option is for backward compatibility */
      var globalOptIn = this.jsoneditor.options.show_opt_in;
      var editorOptInDefined = typeof this.options.show_opt_in !== 'undefined';
      var editorOptInEnabled = editorOptInDefined && this.options.show_opt_in === true;
      var editorOptInDisabled = editorOptInDefined && this.options.show_opt_in === false;
      if (editorOptInEnabled || !editorOptInDisabled && globalOptIn || !editorOptInDefined && globalOptIn) {
        Object.entries(this.editors).forEach(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            key = _ref6[0],
            editor = _ref6[1];
          if (!_this8.isRequiredObject(editor)) {
            _this8.editors[key].deactivate();
          }
          if (recursive && typeof _this8.editors[key].deactivateNonRequiredProperties === 'function') {
            _this8.editors[key].deactivateNonRequiredProperties(recursive);
          }
        });
      }
    }
  }, {
    key: "showEditJSON",
    value: function showEditJSON() {
      if (!this.editjson_holder) return;
      this.hideAddProperty();

      /* Position the form directly beneath the button */
      /* TODO: edge detection */
      this.editjson_holder.style.left = "".concat(this.editjson_control.offsetLeft, "px");
      this.editjson_holder.style.top = "".concat(this.editjson_control.offsetTop + this.editjson_control.offsetHeight, "px");

      /* Start the textarea with the current value */
      this.editjson_textarea.value = JSON.stringify(this.getValue(), null, 2);

      /* Disable the rest of the form while editing JSON */
      this.disable();
      this.editjson_holder.style.display = '';
      this.editjson_control.disabled = false;
      this.editing_json = true;
    }
  }, {
    key: "hideEditJSON",
    value: function hideEditJSON() {
      if (!this.editjson_holder) return;
      if (!this.editing_json) return;
      this.editjson_holder.style.display = 'none';
      this.enable();
      this.editing_json = false;
    }
  }, {
    key: "copyJSON",
    value: function copyJSON() {
      if (!this.editjson_holder) return;
      navigator.clipboard.writeText(this.editjson_textarea.value)["catch"](function (e) {
        return window.alert(e);
      });
    }
  }, {
    key: "saveJSON",
    value: function saveJSON() {
      if (!this.editjson_holder) return;
      try {
        var json = JSON.parse(this.editjson_textarea.value);
        this.setValue(json);
        this.hideEditJSON();
        this.onChange(true);
      } catch (e) {
        window.alert('invalid JSON');
        throw e;
      }
    }
  }, {
    key: "toggleEditJSON",
    value: function toggleEditJSON() {
      if (this.editing_json) this.hideEditJSON();else this.showEditJSON();
    }
  }, {
    key: "insertPropertyControlUsingPropertyOrder",
    value: function insertPropertyControlUsingPropertyOrder(property, control, container) {
      var propertyOrder;
      if (this.schema.properties[property]) {
        propertyOrder = this.schema.properties[property].propertyOrder;
      }
      if (typeof propertyOrder !== 'number') propertyOrder = 1000;
      control.propertyOrder = propertyOrder;
      for (var i = 0; i < container.childNodes.length; i++) {
        var child = container.childNodes[i];
        if (control.propertyOrder < child.propertyOrder) {
          this.addproperty_list.insertBefore(control, child);
          control = null;
          break;
        }
      }
      if (control) {
        this.addproperty_list.appendChild(control);
      }
    }
  }, {
    key: "addPropertyCheckbox",
    value: function addPropertyCheckbox(key) {
      var _this9 = this;
      var labelText;
      var checkbox = this.theme.getCheckbox();
      if (this.schema.properties[key] && this.schema.properties[key].title) {
        labelText = this.schema.properties[key].title;
      } else {
        labelText = key;
      }
      var label = this.theme.getCheckboxLabel(labelText);
      var control = this.theme.getFormControl(label, checkbox, null, null, this.path + '-' + key);
      control.style.paddingBottom = control.style.marginBottom = control.style.paddingTop = control.style.marginTop = 0;
      control.style.height = 'auto';
      /* control.style.overflowY = 'hidden'; */

      this.insertPropertyControlUsingPropertyOrder(key, control, this.addproperty_list);
      checkbox.checked = key in this.editors;
      checkbox.addEventListener('change', function () {
        if (checkbox.checked) {
          _this9.addObjectProperty(key);
        } else {
          _this9.removeObjectProperty(key);
        }
        _this9.onChange(true);
      });
      this.addproperty_checkboxes[key] = checkbox;
      return checkbox;
    }
  }, {
    key: "showAddProperty",
    value: function showAddProperty() {
      if (!this.addproperty_holder) return;
      this.hideEditJSON();

      /* Position the form directly beneath the button */
      /* TODO: edge detection */
      this.addproperty_holder.style.left = "".concat(this.addproperty_button.offsetLeft, "px");
      this.addproperty_holder.style.top = "".concat(this.addproperty_button.offsetTop + this.addproperty_button.offsetHeight, "px");

      /* Disable the rest of the form while editing JSON */
      this.disable();
      this.adding_property = true;
      this.addproperty_button.disabled = false;
      this.addproperty_holder.style.display = '';
      this.refreshAddProperties();
    }
  }, {
    key: "hideAddProperty",
    value: function hideAddProperty() {
      if (!this.addproperty_holder) return;
      if (!this.adding_property) return;
      this.addproperty_holder.style.display = 'none';
      this.enable();
      this.adding_property = false;
    }
  }, {
    key: "toggleAddProperty",
    value: function toggleAddProperty() {
      if (this.adding_property) this.hideAddProperty();else this.showAddProperty();
    }
  }, {
    key: "removeObjectProperty",
    value: function removeObjectProperty(property) {
      if (this.editors[property]) {
        var _this$editors$propert;
        // do not destroy dependent editors
        if ((_this$editors$propert = this.editors[property].schema) !== null && _this$editors$propert !== void 0 && (_this$editors$propert = _this$editors$propert.options) !== null && _this$editors$propert !== void 0 && _this$editors$propert.dependencies) {
          return;
        }
        this.editors[property].unregister();
        delete this.editors[property];
        this.refreshValue();
        this.layoutEditors();
      }
    }
  }, {
    key: "getSchemaOnMaxDepth",
    value: function getSchemaOnMaxDepth(schema) {
      return Object.keys(schema).reduce(function (acc, key) {
        switch (key) {
          case '$ref':
            return acc;
          case 'properties':
          case 'items':
            return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, {}));
          case 'additionalProperties':
          case 'propertyNames':
            return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, true));
          default:
            return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, schema[key]));
        }
      }, {});
    }
  }, {
    key: "addObjectProperty",
    value: function addObjectProperty(name, prebuildOnly) {
      /* Property is already added */
      if (this.editors[name]) return;

      /* Property was added before and is cached */
      if (this.cached_editors[name]) {
        this.editors[name] = this.cached_editors[name];
        if (prebuildOnly) return;
        this.editors[name].register();
        /* New property */
      } else {
        if (!this.canHaveAdditionalProperties() && (!this.schema.properties || !this.schema.properties[name]) && (!this.schema.patternProperties || !Object.keys(this.schema.patternProperties).find(function (i) {
          return new RegExp(i).test(name);
        }))) {
          return;
        }
        var schema = this.getPropertySchema(name);
        if (typeof schema.propertyOrder !== 'number') {
          /* if the propertyOrder undefined, then set a smart default value. */
          schema.propertyOrder = Object.keys(this.editors).length + 1000;
        }

        /* Add the property */
        var editor = this.jsoneditor.getEditorClass(schema);
        var maxDepth = this.jsoneditor.options.max_depth;
        this.editors[name] = this.jsoneditor.createEditor(editor, {
          jsoneditor: this.jsoneditor,
          schema: !!maxDepth && this.currentDepth >= maxDepth ? this.getSchemaOnMaxDepth(schema) : schema,
          path: "".concat(this.path, ".").concat(name),
          parent: this
        }, this.currentDepth + 1);
        this.editors[name].preBuild();
        if (!prebuildOnly) {
          var holder = this.theme.getChildEditorHolder();
          this.editor_holder.appendChild(holder);
          this.editors[name].setContainer(holder);
          this.editors[name].build();
          this.editors[name].postBuild();
          this.editors[name].setOptInCheckbox(editor.header);
          this.editors[name].activate();
        }
        this.cached_editors[name] = this.editors[name];
      }

      /* If we're only prebuilding the editors, don't refresh values */
      if (!prebuildOnly) {
        this.refreshValue();
        this.layoutEditors();
      }
    }
  }, {
    key: "onOutsideModalClick",
    value: function onOutsideModalClick(e) {
      var path = e.path || e.composedPath && e.composedPath();
      if (this.addproperty_holder && !this.addproperty_holder.contains(path[0]) && this.adding_property) {
        e.preventDefault();
        e.stopPropagation();
        this.toggleAddProperty();
      }
    }
  }, {
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      this.refreshValue();
      _get(_getPrototypeOf(ObjectEditor.prototype), "onChildEditorChange", this).call(this, editor, eventData);
    }
  }, {
    key: "canHaveAdditionalProperties",
    value: function canHaveAdditionalProperties() {
      // schemas have priority over options
      // local options have priority over global options
      // lastly global options are evaluated

      // If the schema additionalProperties keyword is a boolean let the keyword decide
      if (typeof this.schema.additionalProperties === 'boolean') {
        return this.schema.additionalProperties;
      }

      // If the schema additionalProperties keyword is a schema then additional properties are allowed and limited by such schema
      if (_typeof(this.schema.additionalProperties) === 'object' && this.schema.additionalProperties !== null) {
        return true;
      }

      // If the schema options no_additional_properties is a boolean let the option decide
      if (typeof this.options.no_additional_properties === 'boolean') {
        return !this.options.no_additional_properties;
      }

      // If the global options no_additional_properties is a boolean let the option decide
      if (typeof this.jsoneditor.options.no_additional_properties === 'boolean') {
        return !this.jsoneditor.options.no_additional_properties;
      }
      return true;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      Object.values(this.cached_editors).forEach(function (el) {
        return el.destroy();
      });
      if (this.editor_holder) this.editor_holder.innerHTML = '';
      if (this.title && this.title.parentNode) this.title.parentNode.removeChild(this.title);
      if (this.error_holder && this.error_holder.parentNode) this.error_holder.parentNode.removeChild(this.error_holder);
      this.editors = null;
      this.cached_editors = null;
      if (this.editor_holder && this.editor_holder.parentNode) this.editor_holder.parentNode.removeChild(this.editor_holder);
      this.editor_holder = null;
      document.removeEventListener('click', this.onOutsideModalClickListener, true);
      _get(_getPrototypeOf(ObjectEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      var result = _get(_getPrototypeOf(ObjectEditor.prototype), "getValue", this).call(this);
      var isEmpty = function isEmpty(obj) {
        return typeof obj === 'undefined' || obj === '' || obj === Object(obj) && Object.keys(obj).length === 0 && obj.constructor === Object;
      };
      if (result && (this.jsoneditor.options.remove_empty_properties || this.options.remove_empty_properties)) {
        Object.keys(result).forEach(function (key) {
          if (isEmpty(result[key])) {
            delete result[key];
          }
        });
      }
      if (result && (this.jsoneditor.options.remove_false_properties || this.options.remove_false_properties)) {
        Object.keys(result).forEach(function (key) {
          if (result[key] === false) {
            delete result[key];
          }
        });
      }
      return result;
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      var _this10 = this;
      this.value = {};
      if (!this.editors) {
        return;
      }
      Object.keys(this.editors).forEach(function (i) {
        if (_this10.editors[i].isActive()) {
          _this10.editors[i].refreshValue();
          _this10.value[i] = _this10.editors[i].getValue();
        }
      });
      Object.keys(this.editors).forEach(function (i) {
        if (_this10.editors[i].isActive()) {
          _this10.activateDependentRequired(_this10.editors[i].key);
        }
      });
      if (this.adding_property) {
        this.refreshAddProperties();
      }
    }
  }, {
    key: "activateDependentRequired",
    value: function activateDependentRequired(key) {
      var _this11 = this;
      var dependentRequired = this.getDependentRequired(key);
      dependentRequired.forEach(function (requiredProperty) {
        var dependentRequiredEditor;
        Object.entries(_this11.cached_editors).forEach(function (_ref7) {
          var _ref8 = _slicedToArray(_ref7, 2),
            i = _ref8[0],
            cachedEditor = _ref8[1];
          if (cachedEditor.key === requiredProperty) {
            dependentRequiredEditor = cachedEditor;
          }
        });
        if (dependentRequiredEditor && !dependentRequiredEditor.isActive()) {
          dependentRequiredEditor.activate();
        }
      });
    }
  }, {
    key: "getDependentRequired",
    value: function getDependentRequired(property) {
      if (this.schema.dependentRequired) {
        if ((0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.hasOwnProperty)(this.schema.dependentRequired, property)) {
          return this.schema.dependentRequired[property];
        }
      }
      return [];
    }
  }, {
    key: "refreshAddProperties",
    value: function refreshAddProperties() {
      var _this12 = this;
      if (this.options.disable_properties || this.options.disable_properties !== false && this.jsoneditor.options.disable_properties) {
        this.addproperty_button.style.display = 'none';
        return;
      }
      var canAdd = false;
      var numProps = 0;
      var showModal = false;

      /* Get number of editors */
      Object.keys(this.editors).forEach(function (i) {
        return numProps++;
      });

      /* Determine if we can add back removed properties */
      canAdd = this.canHaveAdditionalProperties() && !(typeof this.schema.maxProperties !== 'undefined' && numProps >= this.schema.maxProperties);
      if (this.addproperty_checkboxes) {
        this.addproperty_list.innerHTML = '';
      }
      this.addproperty_checkboxes = {};

      /* Check for which editors can't be removed or added back */
      Object.keys(this.cached_editors).forEach(function (i) {
        _this12.addPropertyCheckbox(i);
        if (_this12.isRequiredObject(_this12.cached_editors[i]) && i in _this12.editors) {
          _this12.addproperty_checkboxes[i].disabled = true;
        }
        if (typeof _this12.schema.minProperties !== 'undefined' && numProps <= _this12.schema.minProperties) {
          _this12.addproperty_checkboxes[i].disabled = _this12.addproperty_checkboxes[i].checked;
          if (!_this12.addproperty_checkboxes[i].checked) showModal = true;
        } else if (!(i in _this12.editors)) {
          if (!canAdd && !(0,_utilities_js__WEBPACK_IMPORTED_MODULE_42__.hasOwnProperty)(_this12.schema.properties, i)) {
            _this12.addproperty_checkboxes[i].disabled = true;
          } else {
            _this12.addproperty_checkboxes[i].disabled = false;
            showModal = true;
          }
        } else {
          showModal = true;
        }
      });
      if (this.canHaveAdditionalProperties()) {
        showModal = true;
      }

      /* Additional addproperty checkboxes not tied to a current editor */
      Object.keys(this.schema.properties).forEach(function (i) {
        if (_this12.cached_editors[i]) return;
        showModal = true;
        _this12.addPropertyCheckbox(i);
      });

      /* If no editors can be added or removed, hide the modal button */
      if (!showModal) {
        this.hideAddProperty();
        this.addproperty_button.style.display = 'none';
        /* If additional properties are disabled */
      } else if (!this.canHaveAdditionalProperties()) {
        this.addproperty_add.style.display = 'none';
        this.addproperty_input.style.display = 'none';
        /* If no new properties can be added */
      } else if (!canAdd) {
        this.addproperty_add.disabled = true;
        /* If new properties can be added */
      } else {
        this.addproperty_add.disabled = false;
      }
    }
  }, {
    key: "isRequiredObject",
    value: function isRequiredObject(editor) {
      if (!editor) {
        return;
      }
      if (typeof editor.schema.required === 'boolean') return editor.schema.required;else if (Array.isArray(this.schema.required)) return this.schema.required.includes(editor.key);else if (this.jsoneditor.options.required_by_default) return true;
      return false;
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial) {
      var _this13 = this;
      value = this.applyConstFilter(value);
      value = value || {};
      if (_typeof(value) !== 'object' || Array.isArray(value)) value = {};

      /* First, set the values for all of the defined properties */
      Object.entries(this.cached_editors).forEach(function (_ref9) {
        var _ref10 = _slicedToArray(_ref9, 2),
          i = _ref10[0],
          editor = _ref10[1];
        /* Value explicitly set */
        if (typeof value[i] !== 'undefined') {
          _this13.addObjectProperty(i);
          editor.setValue(value[i], initial);
          editor.activate();
          if (_this13.disabled) {
            editor.disable();
          }
          /* Otherwise, remove value unless this is the initial set or it's required */
        } else if (!initial && !_this13.isRequiredObject(editor)) {
          if (_this13.jsoneditor.options.show_opt_in || _this13.options.show_opt_in) {
            editor.deactivate();
          } else {
            _this13.removeObjectProperty(i);
          }
          /* Otherwise, set the value to the default */
        } else {
          editor.setValue(editor.getDefault(), initial);
        }
      });
      Object.entries(value).forEach(function (_ref11) {
        var _ref12 = _slicedToArray(_ref11, 2),
          i = _ref12[0],
          val = _ref12[1];
        if (!_this13.cached_editors[i]) {
          _this13.addObjectProperty(i);
          if (_this13.editors[i]) _this13.editors[i].setValue(val, initial, !!_this13.editors[i].template);
        }
      });
      this.refreshValue();
      this.layoutEditors();
      this.onChange();
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this14 = this;
      /* Get all the errors that pertain to this editor */
      var myErrors = [];
      var otherErrors = [];
      errors.forEach(function (error) {
        if (error.path === _this14.path) {
          myErrors.push(error);
        } else {
          otherErrors.push(error);
        }
      });

      /* Show errors for this editor */
      if (this.error_holder) {
        if (myErrors.length) {
          this.error_holder.innerHTML = '';
          this.error_holder.style.display = '';
          myErrors.forEach(function (error) {
            if (error.errorcount && error.errorcount > 1) error.message += " (".concat(error.errorcount, " errors)");
            _this14.error_holder.appendChild(_this14.theme.getErrorMessage(error.message));
          });
          /* Hide error area */
        } else {
          this.error_holder.style.display = 'none';
        }
      }

      /* Show error for the table row if this is inside a table */
      if (this.options.table_row) {
        if (myErrors.length) {
          this.theme.addTableRowError(this.container);
        } else {
          this.theme.removeTableRowError(this.container);
        }
      }

      /* Show errors for child editors */
      Object.values(this.editors).forEach(function (editor) {
        editor.showValidationErrors(otherErrors);
      });
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_41__.AbstractEditor);
ObjectEditor.rules = _object_css_js__WEBPACK_IMPORTED_MODULE_43__["default"];

/***/ }),

/***/ "./src/editors/radio.js":
/*!******************************!*\
  !*** ./src/editors/radio.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RadioEditor: () => (/* binding */ RadioEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _select_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./select.js */ "./src/editors/select.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var RadioEditor = /*#__PURE__*/function (_SelectEditor) {
  function RadioEditor() {
    _classCallCheck(this, RadioEditor);
    return _callSuper(this, RadioEditor, arguments);
  }
  _inherits(RadioEditor, _SelectEditor);
  return _createClass(RadioEditor, [{
    key: "preBuild",
    value: function preBuild() {
      _get(_getPrototypeOf(RadioEditor.prototype), "preBuild", this).call(this);
    }
  }, {
    key: "build",
    value: function build() {
      var _this = this;
      this.label = '';
      if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.compact) this.container.classList.add('compact');
      this.radioContainer = document.createElement('div');
      this.radioGroup = [];
      var radioInputEventhandler = function radioInputEventhandler(e) {
        _this.setValue(e.currentTarget.value);
        _this.onChange(true);
        _this.radioGroup.forEach(function (radio) {
          radio.checked = radio.value === _this.getValue();
        });
      };
      for (var i = 0; i < this.enum_values.length; i++) {
        /* form radio elements */
        var attributes = {
          id: "".concat(this.formname, "[").concat(i, "]"),
          value: this.enum_values[i]
        };
        if (this.jsoneditor.options.use_name_attributes) {
          attributes.name = this.formname;
        }
        this.input = this.theme.getFormRadio(attributes);

        /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
        this.setInputAttributes(['id', 'value', 'name']);
        this.input.addEventListener('change', radioInputEventhandler, false);
        this.radioGroup.push(this.input);

        /* form-label for radio elements */
        var radioLabel = this.theme.getFormRadioLabel(this.enum_display[i]);
        radioLabel.htmlFor = this.input.id;
        var control = this.theme.getFormRadioControl(radioLabel, this.input, !!(this.options.layout === 'horizontal' || this.options.compact));
        this.radioContainer.appendChild(control);
      }
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable(true);
        for (var j = 0; j < this.radioGroup.length; j++) {
          this.radioGroup[j].disabled = true;
        }
        this.radioContainer.classList.add('readonly');
      }
      var radioContainerWrapper = this.theme.getContainer();
      radioContainerWrapper.appendChild(this.radioContainer);
      radioContainerWrapper.dataset.containerFor = 'radio';
      this.input = radioContainerWrapper;
      this.control = this.theme.getFormControl(this.label, radioContainerWrapper, this.description, this.infoButton);
      this.container.appendChild(this.control);

      /* Any special formatting that needs to happen after the input is added to the dom */
      window.requestAnimationFrame(function () {
        if (_this.input.parentNode) _this.afterInputReady();
      });
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        for (var i = 0; i < this.radioGroup.length; i++) {
          this.radioGroup[i].disabled = false;
        }
        this.radioContainer.classList.remove('readonly');
        _get(_getPrototypeOf(RadioEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      for (var i = 0; i < this.radioGroup.length; i++) {
        this.radioGroup[i].disabled = true;
      }
      this.radioContainer.classList.add('readonly');
      _get(_getPrototypeOf(RadioEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.radioContainer.parentNode && this.radioContainer.parentNode.parentNode) this.radioContainer.parentNode.parentNode.removeChild(this.radioContainer.parentNode);
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      _get(_getPrototypeOf(RadioEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "setValue",
    value: function setValue(val) {
      val = this.applyConstFilter(val);
      if (typeof val !== 'string') {
        val = String(val);
      }
      for (var i = 0; i < this.radioGroup.length; i++) {
        if (this.radioGroup[i].value === val) {
          this.radioGroup[i].checked = true;
          break;
        } else {
          this.radioGroup[i].checked = false;
        }
      }
      this.value = val;
      this.onChange();
    }
  }]);
}(_select_js__WEBPACK_IMPORTED_MODULE_22__.SelectEditor);

/***/ }),

/***/ "./src/editors/sceditor.js":
/*!*********************************!*\
  !*** ./src/editors/sceditor.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScEditor: () => (/* binding */ ScEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var ScEditor = /*#__PURE__*/function (_StringEditor) {
  function ScEditor() {
    _classCallCheck(this, ScEditor);
    return _callSuper(this, ScEditor, arguments);
  }
  _inherits(ScEditor, _StringEditor);
  return _createClass(ScEditor, [{
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      var res = _get(_getPrototypeOf(ScEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
      if (res !== undefined && res.changed && this.sceditor_instance) this.sceditor_instance.val(res.value);
    }
  }, {
    key: "build",
    value: function build() {
      this.options.format = 'textarea'; /* Force format into "textarea" */
      _get(_getPrototypeOf(ScEditor.prototype), "build", this).call(this);
      this.input_type = this.schema.format; /* Restore original format */
      this.input.setAttribute('data-schemaformat', this.input_type);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      if (window.sceditor) {
        /* Get options, either global options from "this.defaults.options.sceditor" or */
        /* single property options from schema "options.sceditor" */
        var options = this.expandCallbacks('sceditor', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.extend)({}, {
          format: this.input_type,
          emoticonsEnabled: false,
          width: '100%',
          height: 300,
          readOnly: this.schema.readOnly || this.schema.readonly || this.schema.template
        }, this.defaults.options.sceditor || {}, this.options.sceditor || {}, {
          element: this.input
        }));
        var instance = window.sceditor.instance(this.input);
        if (instance === undefined) {
          window.sceditor.create(this.input, options); /* Create doesn't return instance. */
        }
        this.sceditor_instance = instance || window.sceditor.instance(this.input);

        /* Listen for changes */
        this.sceditor_instance.blur(function () {
          _this.value = _this.sceditor_instance.val();
          _this.sceditor_instance.updateOriginal();
          _this.is_dirty = true;
          _this.onChange(true);
        });
        this.theme.afterInputReady(this.input);
      } else _get(_getPrototypeOf(ScEditor.prototype), "afterInputReady", this).call(this); /* Library not loaded, so just treat this as a string */
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 6;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.sceditor_instance) this.sceditor_instance.readOnly(false);
      _get(_getPrototypeOf(ScEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.sceditor_instance) this.sceditor_instance.readOnly(true);
      _get(_getPrototypeOf(ScEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.sceditor_instance) {
        this.sceditor_instance.destroy();
        this.sceditor_instance = null;
      }
      _get(_getPrototypeOf(ScEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_18__.StringEditor);

/***/ }),

/***/ "./src/editors/select.js":
/*!*******************************!*\
  !*** ./src/editors/select.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectEditor: () => (/* binding */ SelectEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ "./node_modules/core-js/modules/es.array.index-of.js");
/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.array.sort.js */ "./node_modules/core-js/modules/es.array.sort.js");
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }































function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var SelectEditor = /*#__PURE__*/function (_AbstractEditor) {
  function SelectEditor() {
    _classCallCheck(this, SelectEditor);
    return _callSuper(this, SelectEditor, arguments);
  }
  _inherits(SelectEditor, _AbstractEditor);
  return _createClass(SelectEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      /* Sanitize value before setting it */
      var sanitized = this.typecast(value);
      var inEnum = this.enum_options.length > 0 && this.enum_values.includes(sanitized);
      var haveToUseDefaultValue = !!this.jsoneditor.options.use_default_values || typeof this.schema["default"] !== 'undefined';
      if (!this.hasPlaceholderOption && (!inEnum || initial && !this.isRequired() && !haveToUseDefaultValue)) {
        sanitized = this.enum_values[0];
      }
      if (this.value === sanitized) return;
      var selectedIndex = this.enum_values.indexOf(sanitized);
      if (inEnum && selectedIndex !== -1) {
        this.input.value = this.enum_options[selectedIndex];
      } else if (this.hasPlaceholderOption) {
        this.input.value = '_placeholder_';
      } else {
        this.input.value = sanitized;
      }
      this.value = sanitized;
      if (!initial) {
        this.is_dirty = true;
      }
      this.onChange();
      this.change();
    }
  }, {
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(SelectEditor.prototype), "register", this).call(this);
      if (!this.input) return;
      if (this.jsoneditor.options.use_name_attributes) {
        this.input.setAttribute('name', this.formname);
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(SelectEditor.prototype), "unregister", this).call(this);
      if (!this.input) return;
      this.input.removeAttribute('name');
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      if (!this.enum_options) return 3;
      var longestText = this.getTitle().length;
      for (var i = 0; i < this.enum_options.length; i++) {
        longestText = Math.max(longestText, this.enum_options[i].length + 4);
      }
      return Math.min(12, Math.max(longestText / 7, 2));
    }
  }, {
    key: "typecast",
    value: function typecast(value) {
      if (this.schema.type === 'boolean') return value === 'undefined' || value === undefined ? undefined : !!value;else if (this.schema.type === 'number') return 1 * value || 0;else if (this.schema.type === 'integer') return Math.floor(value * 1 || 0);else if (this.schema["enum"] && value === undefined) return undefined;
      return "".concat(value);
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      return this.typecast(this.value);
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      var _this$schema,
        _this$schema2,
        _this = this;
      this.input_type = 'select';
      this.enum_options = [];
      this.enum_values = [];
      this.enum_display = [];
      var i;
      var callback;
      this.hasPlaceholderOption = ((_this$schema = this.schema) === null || _this$schema === void 0 || (_this$schema = _this$schema.options) === null || _this$schema === void 0 ? void 0 : _this$schema.has_placeholder_option) || false;
      this.placeholderOptionText = ((_this$schema2 = this.schema) === null || _this$schema2 === void 0 || (_this$schema2 = _this$schema2.options) === null || _this$schema2 === void 0 ? void 0 : _this$schema2.placeholder_option_text) || ' ';

      /* Const value */
      if (this.enforceConst && this.schema["const"]) {
        var value = this.schema["const"];
        this.enum_options = ["".concat(value)];
        this.enum_display = ["".concat(this.translateProperty(value) || value)];
        this.enum_values = [this.typecast(value)];
        /* Enum options enumerated */
      } else if (this.schema["enum"]) {
        var display = this.schema.options && this.schema.options.enum_titles || [];
        this.schema["enum"].forEach(function (option, i) {
          _this.enum_options[i] = "".concat(option);
          _this.enum_display[i] = "".concat(_this.translateProperty(display[i]) || option);
          _this.enum_values[i] = _this.typecast(option);
        });
        /* Boolean */
      } else if (this.schema.type === 'boolean') {
        this.enum_display = this.schema.options && this.schema.options.enum_titles || ['true', 'false'];
        this.enum_options = ['1', ''];
        this.enum_values = [true, false];
        if (!this.isRequired()) {
          this.enum_display.unshift(' ');
          this.enum_options.unshift('undefined');
          this.enum_values.unshift(undefined);
        }
        /* Dynamic Enum */
      } else if (this.schema.enumSource) {
        this.enumSource = [];
        this.enum_display = [];
        this.enum_options = [];
        this.enum_values = [];

        /* Shortcut declaration for using a single array */
        if (!Array.isArray(this.schema.enumSource)) {
          if (this.schema.enumValue) {
            this.enumSource = [{
              source: this.schema.enumSource,
              value: this.schema.enumValue
            }];
          } else {
            this.enumSource = [{
              source: this.schema.enumSource
            }];
          }
        } else {
          for (i = 0; i < this.schema.enumSource.length; i++) {
            /* Shorthand for watched variable */
            if (typeof this.schema.enumSource[i] === 'string') {
              this.enumSource[i] = {
                source: this.schema.enumSource[i]
              };
              /* Make a copy of the schema */
            } else if (!Array.isArray(this.schema.enumSource[i])) {
              this.enumSource[i] = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_32__.extend)({}, this.schema.enumSource[i]);
            } else {
              this.enumSource[i] = this.schema.enumSource[i];
            }
          }
        }
        /* Now, enumSource is an array of sources */
        /* Walk through this array and fix up the values */
        for (i = 0; i < this.enumSource.length; i++) {
          if (this.enumSource[i].value) {
            callback = this.expandCallbacks('template', {
              template: this.enumSource[i].value
            });
            if (typeof callback.template === 'function') this.enumSource[i].value = callback.template;else this.enumSource[i].value = this.jsoneditor.compileTemplate(this.enumSource[i].value, this.template_engine);
          }
          if (this.enumSource[i].title) {
            callback = this.expandCallbacks('template', {
              template: this.enumSource[i].title
            });
            if (typeof callback.template === 'function') this.enumSource[i].title = callback.template;else this.enumSource[i].title = this.jsoneditor.compileTemplate(this.enumSource[i].title, this.template_engine);
          }
          if (this.enumSource[i].filter && this.enumSource[i].value) {
            callback = this.expandCallbacks('template', {
              template: this.enumSource[i].filter
            });
            if (typeof callback.template === 'function') this.enumSource[i].filter = callback.template;else this.enumSource[i].filter = this.jsoneditor.compileTemplate(this.enumSource[i].filter, this.template_engine);
          }
        }
        /* Other, not supported */
      } else {
        throw new Error("'select' editor requires the enum property to be set.");
      }
    }
  }, {
    key: "build",
    value: function build() {
      var _this2 = this;
      if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.compact) this.container.classList.add('compact');
      this.input = this.theme.getSelectInput(this.enum_options, false);
      this.theme.setSelectOptions(this.input, this.enum_options, this.enum_display, this.hasPlaceholderOption, this.placeholderOptionText);
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable(true);
        this.input.disabled = true;
      }

      /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
      this.setInputAttributes([]);
      this.input.addEventListener('change', function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this2.onInputChange();
      });
      this.control = this.theme.getFormControl(this.label, this.input, this.description, this.infoButton, this.formname);
      this.container.appendChild(this.control);
      this.value = this.enum_values[0];

      /* Any special formatting that needs to happen after the input is added to the dom */
      window.requestAnimationFrame(function () {
        if (_this2.input.parentNode) _this2.afterInputReady();
      });
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      this.theme.afterInputReady(this.input);
    }
  }, {
    key: "onInputChange",
    value: function onInputChange() {
      var val = this.typecast(this.input.value);
      var newVal;
      /* Invalid option, use first option instead */
      if (!this.enum_values.includes(val)) {
        newVal = this.enum_values[0];
      } else {
        newVal = this.enum_values[this.enum_values.indexOf(val)];
      }

      /* If valid hasn't changed */
      if (newVal === this.value) return;
      this.is_dirty = true;

      /* Store new value and propogate change event */
      this.value = newVal;
      this.onChange(true);
    }
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var vars;
      var j;
      var selectOptions = [];
      var selectTitles = [];

      /* If this editor uses a dynamic select box */
      if (this.enumSource) {
        vars = this.getWatchedFieldValues();
        for (var i = 0; i < this.enumSource.length; i++) {
          /* Constant values */
          if (Array.isArray(this.enumSource[i])) {
            selectOptions = selectOptions.concat(this.enumSource[i]);
            selectTitles = selectTitles.concat(this.enumSource[i]);
          } else {
            var items = [];
            /* Static list of items */
            if (Array.isArray(this.enumSource[i].source)) {
              items = this.enumSource[i].source;
              /* A watched field */
            } else {
              items = vars[this.enumSource[i].source];
            }
            if (items) {
              /* Only use a predefined part of the array */
              if (this.enumSource[i].slice) {
                items = Array.prototype.slice.apply(items, this.enumSource[i].slice);
              }
              /* Filter the items */
              if (this.enumSource[i].filter) {
                var newItems = [];
                for (j = 0; j < items.length; j++) {
                  if (this.enumSource[i].filter({
                    i: j,
                    item: items[j],
                    watched: vars
                  })) newItems.push(items[j]);
                }
                items = newItems;
              }
              var itemTitles = [];
              var itemValues = [];
              for (j = 0; j < items.length; j++) {
                var item = items[j];

                /* Rendered value */
                if (this.enumSource[i].value) {
                  itemValues[j] = this.typecast(this.enumSource[i].value({
                    i: j,
                    item: item
                  }));
                  /* Use value directly */
                } else {
                  itemValues[j] = items[j];
                }

                /* Rendered title */
                if (this.enumSource[i].title) {
                  itemTitles[j] = this.enumSource[i].title({
                    i: j,
                    item: item
                  });
                  /* Use value as the title also */
                } else {
                  itemTitles[j] = itemValues[j];
                }
              }
              if (this.enumSource[i].sort) {
                (function (itemValues, itemTitles, order) {
                  itemValues.map(function (v, i) {
                    return {
                      v: v,
                      t: itemTitles[i]
                    };
                  }).sort(function (a, b) {
                    return a.v < b.v ? -order : a.v === b.v ? 0 : order;
                  }).forEach(function (v, i) {
                    itemValues[i] = v.v;
                    itemTitles[i] = v.t;
                  });
                }).bind(null, itemValues, itemTitles, this.enumSource[i].sort === 'desc' ? 1 : -1)();
              }
              selectOptions = selectOptions.concat(itemValues);
              selectTitles = selectTitles.concat(itemTitles);
            }
          }
        }
        var prevValue = this.value;
        this.theme.setSelectOptions(this.input, selectOptions, selectTitles);
        this.enum_options = selectOptions;
        this.enum_display = selectTitles;
        this.enum_values = selectOptions;

        /* If the previous value is still in the new select options */
        /* or if global option "enum_source_value_auto_select" is true, stick with it */
        if (selectOptions.includes(prevValue) || this.jsoneditor.options.enum_source_value_auto_select !== false) {
          this.input.value = prevValue;
          this.value = prevValue;
          /* Otherwise, set the value to the first select option */
        } else {
          this.input.value = selectOptions[0];
          this.value = this.typecast(selectOptions[0] || '');
          if (this.parent && !this.watchLoop) this.parent.onChildEditorChange(this);else this.jsoneditor.onChange();
          this.jsoneditor.notifyWatchers(this.path);
        }
      }
      _get(_getPrototypeOf(SelectEditor.prototype), "onWatchedFieldChange", this).call(this);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        this.input.disabled = false;
        _get(_getPrototypeOf(SelectEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      this.input.disabled = true;
      _get(_getPrototypeOf(SelectEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      _get(_getPrototypeOf(SelectEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this3 = this;
      var showErrors = this.jsoneditor.options.show_errors;
      var changeOrInteraction = showErrors === 'change' || showErrors === 'interaction';
      var never = showErrors === 'never';
      if (never && !this.is_dirty) {
        return;
      }
      if (changeOrInteraction && !this.is_dirty) {
        return;
      }
      var addMessage = function addMessage(messages, error) {
        if (error.path === _this3.path) {
          messages.push(error.message);
        }
        return messages;
      };
      var messages = errors.reduce(addMessage, []);
      if (messages.length) {
        this.theme.addInputError(this.input, "".concat(messages.join('. '), "."));
      } else {
        this.theme.removeInputError(this.input);
      }
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_31__.AbstractEditor);

/***/ }),

/***/ "./src/editors/select2.js":
/*!********************************!*\
  !*** ./src/editors/select2.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Select2Editor: () => (/* binding */ Select2Editor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _select_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./select.js */ "./src/editors/select.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var Select2Editor = /*#__PURE__*/function (_SelectEditor) {
  function Select2Editor() {
    _classCallCheck(this, Select2Editor);
    return _callSuper(this, Select2Editor, arguments);
  }
  _inherits(Select2Editor, _SelectEditor);
  return _createClass(Select2Editor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      if (this.select2_instance) {
        if (initial) this.is_dirty = false;else if (this.jsoneditor.options.show_errors === 'change') this.is_dirty = true;
        var sanitized = this.updateValue(value); /* Sets this.value to sanitized value */

        this.input.value = sanitized;
        if (this.select2v4) this.select2_instance.val(sanitized).trigger('change');else this.select2_instance.select2('val', sanitized);
        this.onChange(true);
      } else _get(_getPrototypeOf(Select2Editor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      if (window.jQuery && window.jQuery.fn && window.jQuery.fn.select2 && !this.select2_instance) {
        /* Get options, either global options from "this.defaults.options.select2" or */
        /* single property options from schema "options.select2" */
        var options = this.expandCallbacks('select2', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.extend)({}, this.defaults.options.select2 || {}, this.options.select2 || {}));

        /* New items are allowed if option "tags" is true and type is "string" */
        this.newEnumAllowed = options.tags = !!options.tags && this.schema.type === 'string';
        this.select2_instance = window.jQuery(this.input).select2(options);
        this.select2v4 = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_21__.hasOwnProperty)(this.select2_instance.select2, 'amd');

        /* Create change handler */
        this.selectChangeHandler = function () {
          var value = _this.select2v4 ? _this.select2_instance.val() : _this.select2_instance.select2('val');
          _this.updateValue(value);
          _this.onChange(true);
        };

        /* Add event handler. */
        /* Note: Must use the "on()" method and not addEventListener() */
        this.select2_instance.on('change', this.selectChangeHandler);
        this.select2_instance.on('select2-blur', this.selectChangeHandler);
      }
      _get(_getPrototypeOf(Select2Editor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      var sanitized = this.enum_values[0];
      value = this.typecast(value || '');
      if (!this.enum_values.includes(value)) {
        if (this.newEnumAllowed) {
          sanitized = this.addNewOption(value) ? value : sanitized;
        }
      } else sanitized = value;
      this.value = sanitized;
      return sanitized;
    }
  }, {
    key: "addNewOption",
    value: function addNewOption(value) {
      var sanitized = this.typecast(value);
      var res = false;
      var optionTag;
      if (!this.enum_values.includes(sanitized) && sanitized !== '') {
        /* Add to list of valid enum values */
        this.enum_options.push("".concat(sanitized));
        this.enum_display.push("".concat(sanitized));
        this.enum_values.push(sanitized);
        /* Update Schema enum to prevent triggering error */
        /* "Value must be one of the enumerated values" */
        this.schema["enum"].push(sanitized);
        optionTag = this.input.querySelector("option[value=\"".concat(sanitized, "\"]"));
        if (optionTag) {
          /* Remove data attribute to make option tag permanent. */
          optionTag.removeAttribute('data-select2-tag');
        } else {
          this.select2_instance.append(new Option(sanitized, sanitized, false, false)).trigger('change');
        }
        res = true;
      }
      return res;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        if (this.select2_instance) {
          if (this.select2v4) this.select2_instance.prop('disabled', false);else this.select2_instance.select2('enable', true);
        }
      }
      _get(_getPrototypeOf(Select2Editor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.select2_instance) {
        if (this.select2v4) this.select2_instance.prop('disabled', true);else this.select2_instance.select2('enable', false);
      }
      _get(_getPrototypeOf(Select2Editor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.select2_instance) {
        this.select2_instance.select2('destroy');
        this.select2_instance = null;
      }
      _get(_getPrototypeOf(Select2Editor.prototype), "destroy", this).call(this);
    }
  }]);
}(_select_js__WEBPACK_IMPORTED_MODULE_20__.SelectEditor);

/***/ }),

/***/ "./src/editors/selectize.js":
/*!**********************************!*\
  !*** ./src/editors/selectize.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectizeEditor: () => (/* binding */ SelectizeEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _select_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./select.js */ "./src/editors/select.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var SelectizeEditor = /*#__PURE__*/function (_SelectEditor) {
  function SelectizeEditor() {
    _classCallCheck(this, SelectizeEditor);
    return _callSuper(this, SelectizeEditor, arguments);
  }
  _inherits(SelectizeEditor, _SelectEditor);
  return _createClass(SelectizeEditor, [{
    key: "setValue",
    value: function setValue(value, initial) {
      value = this.applyConstFilter(value);
      if (this.selectize_instance) {
        if (initial) this.is_dirty = false;else if (this.jsoneditor.options.show_errors === 'change') this.is_dirty = true;
        var sanitized = this.updateValue(value); /* Sets this.value to sanitized value */

        this.input.value = sanitized;
        this.selectize_instance.clear(true);
        this.selectize_instance.setValue(sanitized);
        this.onChange(true);
      } else _get(_getPrototypeOf(SelectizeEditor.prototype), "setValue", this).call(this, value, initial);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      if (window.jQuery && window.jQuery.fn && window.jQuery.fn.selectize && !this.selectize_instance) {
        /* Get options, either global options from "this.defaults.options.selectize" or */
        /* single property options from schema "options.selectize" */
        var options = this.expandCallbacks('selectize', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_23__.extend)({}, this.defaults.options.selectize || {}, this.options.selectize || {}));

        /* New items are allowed if option "create" is true and type is "string" */
        this.newEnumAllowed = options.create = !!options.create && this.schema.type === 'string';
        this.selectize_instance = window.jQuery(this.input).selectize(options)[0].selectize;

        /* Remove change handler set in parent class (src/multiselect.js) */
        this.control.removeEventListener('change', this.multiselectChangeHandler);

        /* Create a new change handler */
        this.multiselectChangeHandler = function (value) {
          /* var value = this.selectize_instance.getValue(true); */
          /* this.value = value; */
          _this.updateValue(value);
          _this.onChange(true);
        };

        /* Add new event handler. */
        /* Note: Must use the "on()" method and not addEventListener() */
        this.selectize_instance.on('change', this.multiselectChangeHandler);
      }
      _get(_getPrototypeOf(SelectizeEditor.prototype), "afterInputReady", this).call(this);
    }
  }, {
    key: "updateValue",
    value: function updateValue(value) {
      var sanitized = this.enum_values[0];
      value = this.typecast(value || '');
      if (!this.enum_values.includes(value)) {
        if (this.newEnumAllowed) {
          sanitized = this.addNewOption(value) ? value : sanitized;
        }
      } else sanitized = value;
      this.value = sanitized;
      return sanitized;
    }
  }, {
    key: "addNewOption",
    value: function addNewOption(value) {
      var sanitized = this.typecast(value);
      var res = false;
      if (!this.enum_values.includes(sanitized) && sanitized !== '') {
        /* Add to list of valid enum values */
        this.enum_options.push("".concat(sanitized));
        this.enum_display.push("".concat(sanitized));
        this.enum_values.push(sanitized);
        /* Update Schema enum to prevent triggering error */
        /* "Value must be one of the enumerated values" */
        this.schema["enum"].push(sanitized);

        /* Add selectize item */
        this.selectize_instance.addItem(sanitized);
        this.selectize_instance.refreshOptions(false);
        res = true;
      }
      return res;
    }
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var _this2 = this;
      _get(_getPrototypeOf(SelectizeEditor.prototype), "onWatchedFieldChange", this).call(this);
      if (this.selectize_instance) {
        this.selectize_instance.clear(true); /* Clear selection */
        this.selectize_instance.clearOptions(true); /* Remove all options */
        this.enum_options.forEach(function (value, i) {
          _this2.selectize_instance.addOption({
            value: value,
            text: _this2.enum_display[i]
          });
        });
        this.selectize_instance.addItem("".concat(this.value), true); /* Set new selection */
      }
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.selectize_instance) this.selectize_instance.unlock();
      _get(_getPrototypeOf(SelectizeEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.selectize_instance) this.selectize_instance.lock();
      _get(_getPrototypeOf(SelectizeEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.selectize_instance) {
        this.selectize_instance.destroy();
        this.selectize_instance = null;
      }
      _get(_getPrototypeOf(SelectizeEditor.prototype), "destroy", this).call(this);
    }
  }]);
}(_select_js__WEBPACK_IMPORTED_MODULE_22__.SelectEditor);

/***/ }),

/***/ "./src/editors/signature.js":
/*!**********************************!*\
  !*** ./src/editors/signature.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SignatureEditor: () => (/* binding */ SignatureEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }





















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/* This editor is using the signature pad editor from https://github.com/szimek/signature_pad */
/* Credits for the pad itself go to https://github.com/szimek */


var SignatureEditor = /*#__PURE__*/function (_StringEditor) {
  function SignatureEditor() {
    _classCallCheck(this, SignatureEditor);
    return _callSuper(this, SignatureEditor, arguments);
  }
  _inherits(SignatureEditor, _StringEditor);
  return _createClass(SignatureEditor, [{
    key: "build",
    value: function build() {
      var _this = this;
      if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      var formname = this.formname.replace(/\W/g, '');
      if (typeof SignaturePad === 'function') {
        /* Dynamically add the required CSS the first time this editor is used */
        this.input = this.theme.getFormInputField('hidden');
        this.container.appendChild(this.input);

        /* Required to keep height */
        var signatureContainer = document.createElement('div');
        signatureContainer.classList.add('signature-container');

        /* Create canvas for signature pad */
        var canvas = document.createElement('canvas');
        if (this.jsoneditor.options.use_name_attributes) {
          canvas.setAttribute('name', formname);
        }
        canvas.classList.add('signature');
        signatureContainer.appendChild(canvas);
        this.signaturePad = new window.SignaturePad(canvas);
        this.signaturePad.onEnd = function () {
          /* check if the signature is not empty before setting a value */
          if (!_this.signaturePad.isEmpty()) {
            _this.input.value = _this.signaturePad.toDataURL();
          } else {
            _this.input.value = '';
          }
          _this.is_dirty = true;
          _this.refreshValue();
          _this.watch_listener();
          _this.jsoneditor.notifyWatchers(_this.path);
          if (_this.parent) _this.parent.onChildEditorChange(_this);else _this.jsoneditor.onChange();
        };

        /* create button containers and add clear signature button */
        var buttons = document.createElement('div');
        var clearButton = document.createElement('button');
        clearButton.classList.add('tiny', 'button');
        clearButton.innerHTML = 'Clear signature';
        buttons.appendChild(clearButton);
        signatureContainer.appendChild(buttons);
        if (this.options.compact) this.container.setAttribute('class', "".concat(this.container.getAttribute('class'), " compact"));
        if (this.schema.readOnly || this.schema.readonly) {
          this.disable(true);
          Array.from(this.inputs).forEach(function (input) {
            canvas.setAttribute('readOnly', 'readOnly');
            input.disabled = true;
          });
        }
        /* add listener to the clear button. when clicked, trigger a canvas change after emptying the canvas */
        clearButton.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this.signaturePad.clear();
          /* trigger stroke end to let signaturePad update the dataURL */
          _this.signaturePad.strokeEnd();
        });
        this.control = this.theme.getFormControl(this.label, signatureContainer, this.description);
        this.container.appendChild(this.control);
        this.refreshValue();

        /* signature canvas will stretch to signatureContainer width */
        canvas.width = signatureContainer.offsetWidth;
        if (this.options && this.options.canvas_height) {
          canvas.height = this.options.canvas_height;
        } else {
          canvas.height = '300'; /* Set to default height of 300px; */
        }
      } else {
        var message = document.createElement('p');
        message.innerHTML = 'Signature pad is not available, please include SignaturePad from https://github.com/szimek/signature_pad';
        this.container.appendChild(message);
      }
    }
  }, {
    key: "setValue",
    value: function setValue(val) {
      val = this.applyConstFilter(val);
      if (typeof SignaturePad === 'function') {
        var sanitized = this.sanitize(val);
        if (this.value === sanitized) {
          return;
        }
        this.value = sanitized;
        this.input.value = this.value;
        this.signaturePad.clear();
        /* only set contents if value != '' */
        if (val && val !== '') {
          this.signaturePad.fromDataURL(val);
        }
        this.watch_listener();
        this.jsoneditor.notifyWatchers(this.path);
        return false;
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.signaturePad.off();
      delete this.signaturePad;
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_21__.StringEditor);

/***/ }),

/***/ "./src/editors/simplemde.js":
/*!**********************************!*\
  !*** ./src/editors/simplemde.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SimplemdeEditor: () => (/* binding */ SimplemdeEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_timers_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.timers.js */ "./node_modules/core-js/modules/web.timers.js");
/* harmony import */ var core_js_modules_web_timers_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_timers_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }



















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var SimplemdeEditor = /*#__PURE__*/function (_StringEditor) {
  function SimplemdeEditor() {
    _classCallCheck(this, SimplemdeEditor);
    return _callSuper(this, SimplemdeEditor, arguments);
  }
  _inherits(SimplemdeEditor, _StringEditor);
  return _createClass(SimplemdeEditor, [{
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      var res = _get(_getPrototypeOf(SimplemdeEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
      if (res !== undefined && res.changed && this.simplemde_instance) this.simplemde_instance.value(res.value);
    }
  }, {
    key: "build",
    value: function build() {
      this.options.format = 'textarea'; /* Force format into "textarea" */
      _get(_getPrototypeOf(SimplemdeEditor.prototype), "build", this).call(this);
      this.input_type = this.schema.format; /* Restore original format */
      this.input.setAttribute('data-schemaformat', this.input_type);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this = this;
      var options;
      if (window.SimpleMDE) {
        /* Get options, either global options from "this.defaults.options.simplemde" or */
        /* single property options from schema "options.simplemde" */
        options = this.expandCallbacks('simplemde', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_20__.extend)({}, {
          height: 300
        }, this.defaults.options.simplemde || {}, this.options.simplemde || {}, {
          element: this.input,
          forceSync: true
        }));
        this.simplemde_instance = new window.SimpleMDE(options);
        if (this.schema.readOnly || this.schema.readonly || this.schema.template) {
          this.simplemde_instance.codemirror.options.readOnly = true;
        }

        /* Listen for changes */
        this.simplemde_instance.codemirror.on('change', function () {
          _this.value = _this.simplemde_instance.value();
          _this.is_dirty = true;
          _this.onChange(true);
        });

        /* This will prevent SimpleMDE content from being hidden until focus in Chrome */
        /* if SimpleMDE is not visible (Like when placed inside Tabs) */
        if (options.autorefresh) {
          this.startListening(this.simplemde_instance.codemirror, this.simplemde_instance.codemirror.state.autoRefresh = {
            delay: 250
          });
        }
        this.theme.afterInputReady(this.input);
      } else _get(_getPrototypeOf(SimplemdeEditor.prototype), "afterInputReady", this).call(this); /* Library not loaded, so just treat this as a string */
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 6;
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled && this.simplemde_instance) this.simplemde_instance.codemirror.options.readOnly = false;
      _get(_getPrototypeOf(SimplemdeEditor.prototype), "enable", this).call(this);
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (this.simplemde_instance) this.simplemde_instance.codemirror.options.readOnly = true;
      _get(_getPrototypeOf(SimplemdeEditor.prototype), "disable", this).call(this, alwaysDisabled);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.simplemde_instance) {
        this.simplemde_instance.toTextArea();
        this.simplemde_instance = null;
      }
      _get(_getPrototypeOf(SimplemdeEditor.prototype), "destroy", this).call(this);
    }

    /* Ported from https://codemirror.net/addon/display/autorefresh.js */
  }, {
    key: "startListening",
    value: function startListening(cm, state) {
      var _this2 = this;
      var check = function check() {
        if (cm.display.wrapper.offsetHeight) {
          _this2.stopListening(cm, state);
          if (cm.display.lastWrapHeight !== cm.display.wrapper.clientHeight) {
            cm.refresh();
          }
        } else {
          state.timeout = window.setTimeout(check, state.delay);
        }
      };
      state.timeout = window.setTimeout(check, state.delay);
      state.hurry = function () {
        window.clearTimeout(state.timeout);
        state.timeout = window.setTimeout(check, 50);
      };
      cm.on(window, 'mouseup', state.hurry);
      cm.on(window, 'keyup', state.hurry);
    }
  }, {
    key: "stopListening",
    value: function stopListening(cm, state) {
      window.clearTimeout(state.timeout);
      cm.off(window, 'mouseup', state.hurry);
      cm.off(window, 'keyup', state.hurry);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_19__.StringEditor);

/***/ }),

/***/ "./src/editors/starrating.css.js":
/*!***************************************!*\
  !*** ./src/editors/starrating.css.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ".starrating": "direction:rtl;display:inline-block;white-space:nowrap",
  ".starrating > input": "display:none",
  ".starrating > label:before": "content:'%5C2606';margin:1px;font-size:18px;font-style:normal;font-weight:400;line-height:1;font-family:'Arial';display:inline-block",
  ".starrating > label": "color:%23888;cursor:pointer;margin:8px%200%202px%200",
  ".starrating > label.starrating-display-enabled": "margin:1px%200%200%200",
  ".starrating > input:checked ~ label": "color:%23ffca08",
  ".starrating:not(.readonly) > input:hover ~ label": "color:%23ffca08",
  ".starrating > input:checked ~ label:before": "content:'%5C2605';text-shadow:0%200%201px%20rgba(0%2C20%2C20%2C1)",
  ".starrating:not(.readonly) > input:hover ~ label:before": "content:'%5C2605';text-shadow:0%200%201px%20rgba(0%2C20%2C20%2C1)",
  ".starrating .starrating-display": "position:relative;direction:rtl;text-align:center;font-size:10px;line-height:0px"
});
/* eslint-enable */

/***/ }),

/***/ "./src/editors/starrating.js":
/*!***********************************!*\
  !*** ./src/editors/starrating.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StarratingEditor: () => (/* binding */ StarratingEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.parse-int.js */ "./node_modules/core-js/modules/es.parse-int.js");
/* harmony import */ var core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_int_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
/* harmony import */ var _starrating_css_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./starrating.css.js */ "./src/editors/starrating.css.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var StarratingEditor = /*#__PURE__*/function (_StringEditor) {
  function StarratingEditor() {
    _classCallCheck(this, StarratingEditor);
    return _callSuper(this, StarratingEditor, arguments);
  }
  _inherits(StarratingEditor, _StringEditor);
  return _createClass(StarratingEditor, [{
    key: "build",
    value: function build() {
      var _this = this;
      if (!this.options.compact) this.header = this.label = this.theme.getLabelLike(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.compact) this.container.classList.add('compact');
      this.ratingContainer = document.createElement('div');
      this.ratingContainer.classList.add('starrating');

      /* Emulate the old "rating" editor parameters */
      if (this.schema["enum"] === undefined) {
        var max = this.schema.maximum ? this.schema.maximum : 5;
        if (this.schema.exclusiveMaximum) max--;
        this.enum_values = [];
        for (var k = 0; k < max; k++) this.enum_values.push(k + 1);
      } else this.enum_values = this.schema["enum"];
      this.radioGroup = [];
      var radioInputEventhandler = function radioInputEventhandler(e) {
        e.preventDefault();
        e.stopPropagation();
        _this.setValue(e.currentTarget.value);
        _this.onChange(true);
      };
      for (var i = this.enum_values.length - 1; i > -1; i--) {
        var id = this.formname + (i + 1);

        /* form radio elements */
        var radioInput = this.theme.getFormInputField('radio');
        radioInput.name = "".concat(this.formname, "[starrating]");
        radioInput.value = this.enum_values[i];
        radioInput.id = id;
        radioInput.addEventListener('change', radioInputEventhandler, false);
        this.radioGroup.push(radioInput);

        /* form-label for radio elements */
        var radioLabel = document.createElement('label');
        radioLabel.htmlFor = id;
        radioLabel.title = this.enum_values[i];
        if (this.options.displayValue) {
          radioLabel.classList.add('starrating-display-enabled');
        }
        var radioText = this.theme.getHiddenText('label');
        radioText.textContent = i;
        radioLabel.appendChild(radioText);
        this.ratingContainer.appendChild(radioInput);
        this.ratingContainer.appendChild(radioLabel);
      }
      if (this.options.displayValue) {
        this.displayRating = document.createElement('div');
        this.displayRating.classList.add('starrating-display');
        this.displayRating.innerText = this.enum_values[0];
        this.ratingContainer.appendChild(this.displayRating);
      }
      if (this.schema.readOnly || this.schema.readonly) {
        this.disable(true);
        for (var j = 0; j < this.radioGroup.length; j++) {
          this.radioGroup[j].disabled = true;
        }
        this.ratingContainer.classList.add('readonly');
      }
      var ratingsContainerWrapper = this.theme.getContainer();
      ratingsContainerWrapper.appendChild(this.ratingContainer);
      this.input = ratingsContainerWrapper;
      this.control = this.theme.getFormControl(this.label, ratingsContainerWrapper, this.description, this.infoButton);
      this.container.appendChild(this.control);
      this.refreshValue();
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        for (var i = 0; i < this.radioGroup.length; i++) {
          this.radioGroup[i].disabled = false;
        }
        this.ratingContainer.classList.remove('readonly');
        this.disabled = false;
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      for (var i = 0; i < this.radioGroup.length; i++) {
        this.radioGroup[i].disabled = true;
      }
      this.ratingContainer.classList.add('readonly');
      this.disabled = true;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.ratingContainer.parentNode && this.ratingContainer.parentNode.parentNode) this.ratingContainer.parentNode.parentNode.removeChild(this.ratingContainer.parentNode);
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      _get(_getPrototypeOf(StarratingEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return 2;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      if (!this.dependenciesFulfilled) {
        return undefined;
      }
      if (this.schema.type === 'integer') {
        return this.value === '' ? 0 : parseInt(this.value);
      }
      return this.value;
    }
  }, {
    key: "setValue",
    value: function setValue(value) {
      value = this.applyConstFilter(value);
      this.value = value;
      for (var i = 0; i < this.radioGroup.length; i++) {
        if (this.radioGroup[i].value === "".concat(value)) {
          this.radioGroup[i].checked = true;
          this.value = value;
          if (this.options.displayValue) this.displayRating.innerHTML = this.value;
          break;
        }
      }
      _get(_getPrototypeOf(StarratingEditor.prototype), "setValue", this).call(this, this.value);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_20__.StringEditor);
StarratingEditor.rules = _starrating_css_js__WEBPACK_IMPORTED_MODULE_21__["default"];

/***/ }),

/***/ "./src/editors/stepper.js":
/*!********************************!*\
  !*** ./src/editors/stepper.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StepperEditor: () => (/* binding */ StepperEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _integer_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./integer.js */ "./src/editors/integer.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }


















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var StepperEditor = /*#__PURE__*/function (_IntegerEditor) {
  function StepperEditor() {
    _classCallCheck(this, StepperEditor);
    return _callSuper(this, StepperEditor, arguments);
  }
  _inherits(StepperEditor, _IntegerEditor);
  return _createClass(StepperEditor, [{
    key: "build",
    value: function build() {
      _get(_getPrototypeOf(StepperEditor.prototype), "build", this).call(this);
      this.input.setAttribute('type', 'number');
      if (!this.input.getAttribute('step')) {
        this.input.setAttribute('step', '1');
      }
      var stepperButtons = this.theme.getStepperButtons(this.input);
      this.control.appendChild(stepperButtons);
      this.stepperDown = this.control.querySelector('.stepper-down');
      this.stepperUp = this.control.querySelector('.stepper-up');
    }
  }, {
    key: "enable",
    value: function enable() {
      _get(_getPrototypeOf(StepperEditor.prototype), "enable", this).call(this);
      this.stepperDown.removeAttribute('disabled');
      this.stepperUp.removeAttribute('disabled');
    }
  }, {
    key: "disable",
    value: function disable() {
      _get(_getPrototypeOf(StepperEditor.prototype), "disable", this).call(this);
      this.stepperDown.setAttribute('disabled', true);
      this.stepperUp.setAttribute('disabled', true);
    }
  }]);
}(_integer_js__WEBPACK_IMPORTED_MODULE_18__.IntegerEditor);

/***/ }),

/***/ "./src/editors/string.js":
/*!*******************************!*\
  !*** ./src/editors/string.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StringEditor: () => (/* binding */ StringEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");































function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var StringEditor = /*#__PURE__*/function (_AbstractEditor) {
  function StringEditor() {
    _classCallCheck(this, StringEditor);
    return _callSuper(this, StringEditor, arguments);
  }
  _inherits(StringEditor, _AbstractEditor);
  return _createClass(StringEditor, [{
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(StringEditor.prototype), "register", this).call(this);
      if (!this.input) return;
      if (this.jsoneditor.options.use_name_attributes) {
        this.input.setAttribute('name', this.formname);
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(StringEditor.prototype), "unregister", this).call(this);
      if (!this.input) return;
      this.input.removeAttribute('name');
      this.input.removeAttribute('aria-label');
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      if (this.template && !fromTemplate) return;
      if (!this.shouldBeUnset() && (value === null || typeof value === 'undefined')) value = '';else if (_typeof(value) === 'object') value = JSON.stringify(value);else if (!this.shouldBeUnset() && typeof value !== 'string') value = "".concat(value);
      if (value === this.serialized) return;

      /* Sanitize value before setting it */
      var sanitized = this.sanitize(value);
      if (this.input.value === sanitized) return;
      this.setValueToInputField(sanitized);
      if (this.format === 'range') {
        var output = this.control.querySelector('output');
        if (output) {
          output.value = sanitized;
        }
      }
      var changed = fromTemplate || this.getValue() !== value;
      this.refreshValue();
      if (initial) this.is_dirty = false;else if (this.jsoneditor.options.show_errors === 'change') this.is_dirty = true;
      if (this.adjust_height) this.adjust_height(this.input);

      /* Bubble this setValue to parents if the value changed */
      if (changed) {
        this.onChange(true, fromTemplate);
      }

      /* Return object with changed state and sanitized value for use in editors that extend this */
      return {
        changed: changed,
        value: sanitized
      };
    }
  }, {
    key: "setValueToInputField",
    value: function setValueToInputField(value) {
      this.input.value = value === undefined ? '' : value;
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      var min = Math.ceil(Math.max(this.getTitle().length, this.schema.maxLength || 0, this.schema.minLength || 0) / 5);
      var num;
      if (this.input_type === 'textarea') num = 6;else if (['text', 'email'].includes(this.input_type)) num = 4;else num = 2;
      return Math.min(12, Math.max(min, num));
    }
  }, {
    key: "build",
    value: function build() {
      var _this = this,
        _this$options$prompt_;
      if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      this.format = this.schema.format;
      if (!this.format && this.schema.media && this.schema.media.type) {
        this.format = this.schema.media.type.replace(/(^(application|text)\/(x-)?(script\.)?)|(-source$)/g, '');
      }
      if (!this.format && this.options.default_format) {
        this.format = this.options.default_format;
      }
      if (this.options.format) {
        this.format = this.options.format;
      }

      /* Specific format */
      if (this.format) {
        /* Text Area */
        if (this.format === 'textarea') {
          this.input_type = 'textarea';
          this.input = this.theme.getTextareaInput();
          /* Range Input */
        } else if (this.format === 'range') {
          this.input_type = 'range';
          var min = this.schema.minimum || 0;
          var max = this.schema.maximum || Math.max(100, min + 1);
          var step = 1;
          if (this.schema.multipleOf) {
            if (min % this.schema.multipleOf) min = Math.ceil(min / this.schema.multipleOf) * this.schema.multipleOf;
            if (max % this.schema.multipleOf) max = Math.floor(max / this.schema.multipleOf) * this.schema.multipleOf;
            step = this.schema.multipleOf;
          }
          this.input = this.theme.getRangeInput(min, max, step, this.description, this.formname);
          this.input.setAttribute('id', this.formname);
          /* HTML5 Input type */
        } else {
          this.input_type = 'text';
          if (['button', 'checkbox', 'color', 'date', 'datetime-local', 'email', 'file', 'hidden', 'image', 'month', 'number', 'password', 'radio', 'reset', 'search', 'submit', 'tel', 'text', 'time', 'url', 'week'].includes(this.format)) {
            this.input_type = this.format;
          }
          this.input = this.theme.getFormInputField(this.input_type);
        }
        /* Normal text input */
      } else {
        this.input_type = 'text';
        this.input = this.theme.getFormInputField(this.input_type);
      }

      /* minLength, maxLength, and pattern */
      if (typeof this.schema.maxLength !== 'undefined') this.input.setAttribute('maxlength', this.schema.maxLength);
      if (typeof this.schema.pattern !== 'undefined') this.input.setAttribute('pattern', this.schema.pattern);else if (typeof this.schema.minLength !== 'undefined') this.input.setAttribute('pattern', ".{".concat(this.schema.minLength, ",}"));
      if (this.options.compact) {
        this.container.classList.add('compact');
      } else if (this.options.input_width) this.input.style.width = this.options.input_width;
      if (this.schema.readOnly || this.schema.readonly || this.schema.template) {
        this.disable(true);
        this.input.setAttribute('readonly', 'true');
      }

      /* Set custom attributes on input element. Parameter is array of protected keys. Empty array if none. */
      this.setInputAttributes(['maxlength', 'pattern', 'readonly', 'min', 'max', 'step']);
      this.input.addEventListener('change', function (e) {
        e.preventDefault();
        e.stopPropagation();

        /* Don't allow changing if this field is a template */
        if (_this.schema.template) {
          e.currentTarget.value = _this.value;
          return;
        }
        var val = e.currentTarget.value;

        /* sanitize value */
        var sanitized = _this.sanitize(val);
        if (val !== sanitized) {
          e.currentTarget.value = sanitized;
        }
        _this.is_dirty = true;
        _this.refreshValue();
        _this.onChange(true);
      });
      if (this.options.input_height) this.input.style.height = this.options.input_height;
      if (this.options.expand_height) {
        this.adjust_height = function (el) {
          if (!el) return;
          var i;
          var ch = el.offsetHeight;
          /* Input too short */
          if (el.offsetHeight < el.scrollHeight) {
            i = 0;
            while (el.offsetHeight < el.scrollHeight + 3) {
              if (i > 100) break;
              i++;
              ch++;
              el.style.height = "".concat(ch, "px");
            }
          } else {
            i = 0;
            while (el.offsetHeight >= el.scrollHeight + 3) {
              if (i > 100) break;
              i++;
              ch--;
              el.style.height = "".concat(ch, "px");
            }
            el.style.height = "".concat(ch + 1, "px");
          }
        };
        this.input.addEventListener('keyup', function (e) {
          _this.adjust_height(e.currentTarget);
        });
        this.input.addEventListener('change', function (e) {
          _this.adjust_height(e.currentTarget);
        });
        this.adjust_height();
      }
      var promptPasteMaxLengthReached = (_this$options$prompt_ = this.options.prompt_paste_max_length_reached) !== null && _this$options$prompt_ !== void 0 ? _this$options$prompt_ : this.jsoneditor.options.prompt_paste_max_length_reached;
      var hasMaxLength = typeof this.schema.maxLength !== 'undefined';
      if (promptPasteMaxLengthReached && hasMaxLength) {
        this.input.addEventListener('paste', function (event) {
          var paste = (event.clipboardData || window.clipboardData).getData('text');
          var length = paste.length + _this.input.value.length;
          if (length > _this.schema.maxLength) {
            alert(_this.translate('paste_max_length_reached', [_this.schema.maxLength]));
          }
        });
      }
      if (this.format) this.input.setAttribute('data-schemaformat', this.format);
      var input = this.input;
      if (this.format === 'range') {
        input = this.theme.getRangeControl(this.input, this.theme.getRangeOutput(this.input, this.schema["default"] || Math.max(this.schema.minimum || 0, 0)));
      }
      this.control = this.theme.getFormControl(this.label, input, this.description, this.infoButton, this.formname);
      this.container.appendChild(this.control);

      /* Any special formatting that needs to happen after the input is added to the dom */
      window.requestAnimationFrame(function () {
        /* Skip in case the input is only a temporary editor, */
        /* otherwise, in the case of an ace_editor creation, */
        /* it will generate an error trying to append it to the missing parentNode */
        if (_this.input.parentNode) _this.afterInputReady();
        if (_this.adjust_height) _this.adjust_height(_this.input);
        if (_this.format === 'range') {
          var output = _this.control.querySelector('output');
          output.value = _this.input.value;
        }
      });

      /* Compile and store the template */
      if (this.schema.template) {
        var callback = this.expandCallbacks('template', {
          template: this.schema.template
        });
        if (typeof callback.template === 'function') this.template = callback.template;else this.template = this.jsoneditor.compileTemplate(this.schema.template, this.template_engine);
        this.refreshValue();
      } else {
        this.refreshValue();
      }
    }
  }, {
    key: "setupCleave",
    value: function setupCleave(el) {
      /* Enable cleave.js support if library is loaded and config is available */
      var options = this.expandCallbacks('cleave', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_32__.extend)({}, this.defaults.options.cleave || {}, this.options.cleave || {}));
      if (_typeof(options) === 'object' && Object.keys(options).length > 0) {
        this.cleave_instance = new window.Cleave(el, options);
      }
    }
  }, {
    key: "setupImask",
    value: function setupImask(el) {
      /* Enable imask.js support if library is loaded and config is available */
      var options = this.expandCallbacks('imask', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_32__.extend)({}, this.defaults.options.imask || {}, this.options.imask || {}));
      if (_typeof(options) === 'object' && Object.keys(options).length > 0) {
        this.imask_instance = window.IMask(el, this.ajustIMaskOptions(options));
      }
    }
  }, {
    key: "ajustIMaskOptions",
    value: function ajustIMaskOptions(obj) {
      var _this2 = this;
      /* iMask config format is not JSON friendly, so function and regex based mask */
      /* properties have to be adjusted from string to the correct format */
      Object.keys(obj).forEach(function (prop) {
        if (obj[prop] === Object(obj[prop])) obj[prop] = _this2.ajustIMaskOptions(obj[prop]);else if (prop === 'mask') {
          if (obj[prop].substr(0, 6) === 'regex:') {
            var regExMatch = obj[prop].match(/^regex:\/(.*)\/([gimsuy]*)$/);
            if (regExMatch !== null) {
              try {
                obj[prop] = new RegExp(regExMatch[1], regExMatch[2]);
              } catch (e) {}
            }
          } else obj[prop] = _this2.getGlobalPropertyFromString(obj[prop]);
        }
      });
      return obj;
    }
  }, {
    key: "getGlobalPropertyFromString",
    value: function getGlobalPropertyFromString(strValue) {
      if (!strValue.includes('.')) {
        if (typeof window[strValue] !== 'undefined') {
          return window[strValue];
        }
      } else {
        var arrParts = strValue.split('.');
        var obj = arrParts[0];
        var prop = arrParts[1];
        if (typeof window[obj] !== 'undefined' && typeof window[obj][prop] !== 'undefined') {
          return window[obj][prop];
        }
      }
      /* just a string */
      return strValue;
    }
  }, {
    key: "shouldBeUnset",
    value: function shouldBeUnset() {
      return !this.jsoneditor.options.use_default_values && !this.is_dirty;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      var hasValueSet = !!(this.input && this.input.value);
      if (this.shouldBeUnset() && !hasValueSet) {
        return undefined;
      }
      if (this.imask_instance && this.dependenciesFulfilled && this.options.imask.returnUnmasked) {
        return this.imask_instance.unmaskedValue;
      }
      return _get(_getPrototypeOf(StringEditor.prototype), "getValue", this).call(this);
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        this.input.disabled = false;
        _get(_getPrototypeOf(StringEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      this.input.disabled = true;
      _get(_getPrototypeOf(StringEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      this.theme.afterInputReady(this.input);
      if (window.Cleave && !this.cleave_instance) this.setupCleave(this.input);else if (window.IMask && !this.imask_instance) this.setupImask(this.input);
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      if (!this.input) {
        return;
      }
      this.value = this.input.value;
      if (typeof this.value !== 'string' && !this.shouldBeUnset()) this.value = '';
      this.serialized = this.value;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.cleave_instance) this.cleave_instance.destroy();
      if (this.imask_instance) this.imask_instance.destroy();
      this.template = null;
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      if (this.label && this.label.parentNode) this.label.parentNode.removeChild(this.label);
      if (this.description && this.description.parentNode) this.description.parentNode.removeChild(this.description);
      _get(_getPrototypeOf(StringEditor.prototype), "destroy", this).call(this);
    }

    /**
     * This is overridden in derivative editors
     */
  }, {
    key: "sanitize",
    value: function sanitize(value) {
      return value;
    }

    /**
     * Re-calculates the value if needed
     */
  }, {
    key: "onWatchedFieldChange",
    value: function onWatchedFieldChange() {
      var vars;

      /* If this editor needs to be rendered by a macro template */
      if (this.template) {
        vars = this.getWatchedFieldValues();
        this.setValue(this.template(vars), false, true);
      }
      _get(_getPrototypeOf(StringEditor.prototype), "onWatchedFieldChange", this).call(this);
    }
  }, {
    key: "showValidationErrors",
    value: function showValidationErrors(errors) {
      var _this3 = this;
      if (this.jsoneditor.options.show_errors === 'always') {} else if (!this.is_dirty && this.previous_error_setting === this.jsoneditor.options.show_errors) return;
      this.previous_error_setting = this.jsoneditor.options.show_errors;
      var addMessage = function addMessage(messages, error) {
        if (error.path === _this3.path) {
          messages.push(error.message);
        }
        return messages;
      };
      var messages = errors.reduce(addMessage, []);
      if (messages.length) {
        this.theme.addInputError(this.input, "".concat(messages.join('. '), "."));
      } else {
        this.theme.removeInputError(this.input);
      }
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_31__.AbstractEditor);

/***/ }),

/***/ "./src/editors/table.js":
/*!******************************!*\
  !*** ./src/editors/table.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TableEditor: () => (/* binding */ TableEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.array.some.js */ "./node_modules/core-js/modules/es.array.some.js");
/* harmony import */ var core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_some_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.date.to-json.js */ "./node_modules/core-js/modules/es.date.to-json.js");
/* harmony import */ var core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_json_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./array.js */ "./src/editors/array.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }




























function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var TableEditor = /*#__PURE__*/function (_ArrayEditor) {
  function TableEditor() {
    _classCallCheck(this, TableEditor);
    return _callSuper(this, TableEditor, arguments);
  }
  _inherits(TableEditor, _ArrayEditor);
  return _createClass(TableEditor, [{
    key: "register",
    value: function register() {
      _get(_getPrototypeOf(TableEditor.prototype), "register", this).call(this);
      if (this.rows) {
        for (var i = 0; i < this.rows.length; i++) {
          this.rows[i].register();
        }
      }
    }
  }, {
    key: "unregister",
    value: function unregister() {
      _get(_getPrototypeOf(TableEditor.prototype), "unregister", this).call(this);
      if (this.rows) {
        for (var i = 0; i < this.rows.length; i++) {
          this.rows[i].unregister();
        }
      }
    }
  }, {
    key: "getNumColumns",
    value: function getNumColumns() {
      return Math.max(Math.min(12, this.width), 3);
    }
  }, {
    key: "preBuild",
    value: function preBuild() {
      var itemSchema = this.jsoneditor.expandRefs(this.schema.items || {});
      this.item_title = itemSchema.title || 'row';
      this.item_default = itemSchema["default"] || null;
      this.item_has_child_editors = itemSchema.properties || itemSchema.items;
      this.width = 12;
      this.array_controls_top = this.options.array_controls_top || this.jsoneditor.options.array_controls_top;
      _get(_getPrototypeOf(TableEditor.prototype), "preBuild", this).call(this);
    }
  }, {
    key: "build",
    value: function build() {
      this.tableContainer = this.theme.getTableContainer();
      this.table = this.theme.getTable();
      this.tableContainer.appendChild(this.table);
      this.container.appendChild(this.tableContainer);
      this.thead = this.theme.getTableHead();
      this.table.appendChild(this.thead);
      this.header_row = this.theme.getTableRow();
      this.thead.appendChild(this.header_row);
      this.row_holder = this.theme.getTableBody();
      this.table.appendChild(this.row_holder);

      /* Determine the default value of array element */
      var tmp = this.getElementEditor(0, true);
      this.item_default = tmp.getDefault();
      this.width = tmp.getNumColumns() + 2;
      if (!this.options.compact) {
        this.header = document.createElement('span');
        this.header.textContent = this.getTitle();
        this.title = this.theme.getHeader(this.header, this.getPathDepth());
        this.container.appendChild(this.title);
        if (this.options.infoText) {
          this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
          this.container.appendChild(this.infoButton);
        }
        this.title_controls = this.theme.getHeaderButtonHolder();
        this.title.appendChild(this.title_controls);
        if (this.schema.description) {
          this.description = this.theme.getDescription(this.translateProperty(this.schema.description));
          this.container.appendChild(this.description);
        }
        this.panel = this.theme.getIndentedPanel();
        this.container.appendChild(this.panel);
        this.error_holder = document.createElement('div');
        this.panel.appendChild(this.error_holder);
      } else {
        this.panel = document.createElement('div');
        this.container.appendChild(this.panel);
      }
      this.panel.appendChild(this.tableContainer);
      this.controls = this.theme.getButtonHolder();
      if (this.array_controls_top) {
        this.title.appendChild(this.controls);
      } else {
        this.panel.appendChild(this.controls);
      }
      if (this.item_has_child_editors) {
        var ce = tmp.getChildEditors();
        var order = tmp.property_order || Object.keys(ce);
        for (var i = 0; i < order.length; i++) {
          var th = this.theme.getTableHeaderCell(ce[order[i]].getTitle());
          if (ce[order[i]].options.hidden) th.style.display = 'none';
          this.header_row.appendChild(th);
        }
      } else {
        this.header_row.appendChild(this.theme.getTableHeaderCell(this.item_title));
      }
      tmp.destroy();
      this.row_holder.innerHTML = '';

      /* Row Controls column */
      this.controls_header_cell = this.theme.getTableHeaderCell(this.translate('table_controls'));
      this.controls_header_cell.setAttribute('aria-hidden', 'true');
      this.controls_header_cell.style.visibility = 'hidden';
      this.header_row.appendChild(this.controls_header_cell);

      /* Add controls */
      this.addControls();
    }
  }, {
    key: "onChildEditorChange",
    value: function onChildEditorChange(editor, eventData) {
      this.refreshValue();
      _get(_getPrototypeOf(TableEditor.prototype), "onChildEditorChange", this).call(this, editor, eventData);
    }
  }, {
    key: "getItemDefault",
    value: function getItemDefault() {
      return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_29__.extend)({}, {
        "default": this.item_default
      })["default"];
    }
  }, {
    key: "getItemTitle",
    value: function getItemTitle() {
      return this.item_title;
    }
  }, {
    key: "getElementEditor",
    value: function getElementEditor(i, ignore) {
      var schemaCopy = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_29__.extend)({}, this.schema.items);
      var editor = this.jsoneditor.getEditorClass(schemaCopy, this.jsoneditor);
      var row = this.row_holder.appendChild(this.theme.getTableRow());
      var holder = row;
      if (!this.item_has_child_editors) {
        holder = this.theme.getTableCell();
        row.appendChild(holder);
      }
      var ret = this.jsoneditor.createEditor(editor, {
        jsoneditor: this.jsoneditor,
        schema: schemaCopy,
        container: holder,
        path: "".concat(this.path, ".").concat(i),
        parent: this,
        compact: true,
        table_row: true
      });
      ret.preBuild();
      if (!ignore) {
        ret.build();
        ret.postBuild();
        ret.controls_cell = row.appendChild(this.theme.getTableCell());
        ret.row = row;
        ret.table_controls = this.theme.getButtonHolder();
        ret.controls_cell.appendChild(ret.table_controls);
        ret.table_controls.style.margin = 0;
        ret.table_controls.style.padding = 0;
      }
      return ret;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.innerHTML = '';
      if (this.checkParent(this.title)) this.title.parentNode.removeChild(this.title);
      if (this.checkParent(this.description)) this.description.parentNode.removeChild(this.description);
      if (this.checkParent(this.row_holder)) this.row_holder.parentNode.removeChild(this.row_holder);
      if (this.checkParent(this.table)) this.table.parentNode.removeChild(this.table);
      if (this.checkParent(this.panel)) this.panel.parentNode.removeChild(this.panel);
      this.rows = this.title = this.description = this.row_holder = this.table = this.panel = null;
      _get(_getPrototypeOf(TableEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "ensureArraySize",
    value: function ensureArraySize(value) {
      if (!Array.isArray(value)) value = [value];
      if (this.schema.minItems) {
        while (value.length < this.schema.minItems) {
          value.push(this.getItemDefault());
        }
      }
      if (this.schema.maxItems && value.length > this.schema.maxItems) {
        value = value.slice(0, this.schema.maxItems);
      }
      return value;
    }
  }, {
    key: "setValue",
    value: function setValue() {
      var _this = this;
      var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var initial = arguments.length > 1 ? arguments[1] : undefined;
      value = this.applyConstFilter(value);

      /* Make sure value has between minItems and maxItems items in it */
      value = this.ensureArraySize(value);
      var serialized = JSON.stringify(value);
      if (serialized === this.serialized) return;
      var numrowsChanged = false;
      value.forEach(function (val, i) {
        if (_this.rows[i]) {
          /* TODO: don't set the row's value if it hasn't changed */
          _this.rows[i].setValue(val);
        } else {
          _this.addRow(val);
          numrowsChanged = true;
        }
      });
      for (var j = value.length; j < this.rows.length; j++) {
        var holder = this.rows[j].container;
        if (!this.item_has_child_editors) {
          this.rows[j].row.parentNode.removeChild(this.rows[j].row);
        }
        this.rows[j].destroy();
        if (holder.parentNode) holder.parentNode.removeChild(holder);
        this.rows[j] = null;
        numrowsChanged = true;
      }
      this.rows = this.rows.slice(0, value.length);
      this.refreshValue();
      if (numrowsChanged || initial) this.refreshRowButtons();
      this.onChange();
      /* TODO: sortable */
    }
  }, {
    key: "refreshRowButtons",
    value: function refreshRowButtons() {
      var _this2 = this;
      /* If we currently have minItems items in the array */
      var minItems = this.schema.minItems && this.schema.minItems >= this.rows.length;
      /* If we currently have maxItems items in the array */
      var maxItems = this.schema.maxItems && this.schema.maxItems <= this.rows.length;
      var needRowButtons = [];
      this.rows.forEach(function (editor, i) {
        if (editor.delete_button) {
          /* Hide the delete button if we have minItems items */
          var display = !minItems;
          _this2.setButtonState(editor.delete_button, display);
          needRowButtons.push(display);
        }
        if (editor.copy_button) {
          /* Hide the copy button if we have maxItems items */
          var _display = !maxItems;
          _this2.setButtonState(editor.copy_button, _display);
          needRowButtons.push(_display);
        }
        if (editor.moveup_button) {
          /* Hide the moveup button for the first row */
          var _display2 = i !== 0;
          _this2.setButtonState(editor.moveup_button, _display2);
          needRowButtons.push(_display2);
        }
        if (editor.movedown_button) {
          /* Hide the movedown button for the last row */
          var _display3 = i !== _this2.rows.length - 1;
          _this2.setButtonState(editor.movedown_button, _display3);
          needRowButtons.push(_display3);
        }
      });
      var need = needRowButtons.some(function (e) {
        return e;
      });
      /* Show/hide controls column in table */
      this.rows.forEach(function (editor) {
        return _this2.setButtonState(editor.controls_cell, need);
      });
      this.setButtonState(this.controls_header_cell, need);
      this.setButtonState(this.table, this.value.length);

      /* If there are maxItems items in the array, or configured to hide the add_row_button button, hide the button beneath the rows */
      var display1 = !(maxItems || this.hide_add_button);
      this.setButtonState(this.add_row_button, display1);

      /* If there are minItems items in the array, or configured to hide the delete_last_row button, hide the button beneath the rows */
      var display2 = !(!this.value.length || minItems || this.hide_delete_last_row_buttons);
      this.setButtonState(this.delete_last_row_button, display2);

      /* If there are minItems items in the array, or configured to hide the remove_all_rows_button button, hide the button beneath the rows */
      var display3 = !(this.value.length <= 1 || minItems || this.hide_delete_all_rows_buttons);
      this.setButtonState(this.remove_all_rows_button, display3);
      var controlsNeeded = display1 || display2 || display3;
      this.setButtonState(this.controls, controlsNeeded);
    }
  }, {
    key: "refreshValue",
    value: function refreshValue() {
      var _this3 = this;
      this.value = [];
      this.rows.forEach(function (editor, i) {
        /* Get the value for this editor */
        _this3.value[i] = editor.getValue();
      });
      this.serialized = JSON.stringify(this.value);
    }
  }, {
    key: "addRow",
    value: function addRow(value) {
      var i = this.rows.length;
      this.rows[i] = this.getElementEditor(i);
      var controlsHolder = this.rows[i].table_controls;

      /* Buttons to delete row, copy row, move row up, and move row down */
      if (!this.hide_delete_buttons) {
        this.rows[i].delete_button = this._createDeleteButton(i, controlsHolder);
      }
      if (this.show_copy_button) {
        this.rows[i].copy_button = this._createCopyButton(i, controlsHolder);
      }
      if (!this.hide_move_buttons) {
        this.rows[i].moveup_button = this._createMoveUpButton(i, controlsHolder);
      }
      if (!this.hide_move_buttons) {
        this.rows[i].movedown_button = this._createMoveDownButton(i, controlsHolder);
      }
      this._supportDragDrop(this.rows[i].row);
      if (typeof value !== 'undefined') this.rows[i].setValue(value);
      return this.rows[i];
    }
  }, {
    key: "_createDeleteButton",
    value: function _createDeleteButton(i, holder) {
      var _this4 = this;
      var button = this.getButton('', 'delete', 'button_delete_row_title_short');
      button.classList.add('delete', 'json-editor-btntype-delete');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this4.askConfirmation()) {
          return false;
        }
        var j = e.currentTarget.getAttribute('data-i') * 1;
        var value = _this4.getValue();
        var rows = _this4.getValue();
        var editorValue = rows[j];
        value.splice(j, 1);
        _this4.setValue(value);
        _this4.onChange(true);
        _this4.jsoneditor.trigger('deleteRow', editorValue);
      });
      holder.appendChild(button);
      return button;
    }
  }, {
    key: "_createCopyButton",
    value: function _createCopyButton(i, holder) {
      var _this5 = this;
      var button = this.getButton('', 'copy', 'button_copy_row_title_short');
      var schema = this.schema;
      button.classList.add('copy', 'json-editor-btntype-copy');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var j = e.currentTarget.getAttribute('data-i') * 1;
        var value = _this5.getValue();
        var newValue = value[j];

        /* On copy, recreate uuid if needed. */
        if (schema.items.type === 'string' && schema.items.format === 'uuid') {
          newValue = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_29__.generateUUID)();
        } else if (schema.items.type === 'object' && schema.items.properties) {
          value.forEach(function (row, i) {
            if (j === i) {
              for (var _i = 0, _Object$keys = Object.keys(row); _i < _Object$keys.length; _i++) {
                var key = _Object$keys[_i];
                if (schema.items.properties && schema.items.properties[key] && schema.items.properties[key].format === 'uuid') {
                  newValue = Object.assign({}, value[j]);
                  newValue[key] = (0,_utilities_js__WEBPACK_IMPORTED_MODULE_29__.generateUUID)();
                }
              }
            }
          });
        }
        value.splice(j + 1, 0, newValue);
        _this5.setValue(value);
        _this5.onChange(true);
        _this5.jsoneditor.trigger('copyRow', _this5.rows[j + 1]);
      });
      holder.appendChild(button);
      return button;
    }
  }, {
    key: "_createMoveUpButton",
    value: function _createMoveUpButton(i, holder) {
      var _this6 = this;
      var button = this.getButton('', 'moveup', 'button_move_up_title');
      button.classList.add('moveup', 'json-editor-btntype-move');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var j = e.currentTarget.getAttribute('data-i') * 1;
        var value = _this6.getValue();
        value.splice(j - 1, 0, value.splice(j, 1)[0]);
        _this6.setValue(value);
        _this6.onChange(true);
        _this6.jsoneditor.trigger('moveRow', _this6.rows[j - 1]);
      });
      holder.appendChild(button);
      return button;
    }
  }, {
    key: "_createMoveDownButton",
    value: function _createMoveDownButton(i, holder) {
      var _this7 = this;
      var button = this.getButton('', 'movedown', 'button_move_down_title');
      button.classList.add('movedown', 'json-editor-btntype-move');
      button.setAttribute('data-i', i);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var j = e.currentTarget.getAttribute('data-i') * 1;
        var value = _this7.getValue();
        value.splice(j + 1, 0, value.splice(j, 1)[0]);
        _this7.setValue(value);
        _this7.onChange(true);
        _this7.jsoneditor.trigger('moveRow', _this7.rows[j + 1]);
      });
      holder.appendChild(button);
      return button;
    }
  }, {
    key: "_supportDragDrop",
    value: function _supportDragDrop(tab) {
      var _this8 = this;
      (0,_array_js__WEBPACK_IMPORTED_MODULE_28__.supportDragDrop)(tab, function (i, j) {
        var rows = _this8.getValue();
        var tmp = rows[i];
        rows.splice(i, 1);
        rows.splice(j, 0, tmp);
        _this8.setValue(rows);
        _this8.onChange(true);
        _this8.jsoneditor.trigger('moveRow', _this8.rows[j]);
      }, {
        useTrigger: true
      });
    }
  }, {
    key: "addControls",
    value: function addControls() {
      var _this9 = this;
      this.collapsed = false;
      this.toggle_button = this._createToggleButton();
      if (this.title_controls) {
        this.title.insertBefore(this.toggle_button, this.title.childNodes[0]);
        this.toggle_button.addEventListener('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          _this9.setButtonState(_this9.panel, _this9.collapsed);
          if (_this9.collapsed) {
            _this9.collapsed = false;
            _this9.setButtonText(e.currentTarget, '', 'collapse', 'button_collapse');
          } else {
            _this9.collapsed = true;
            _this9.setButtonText(e.currentTarget, '', 'expand', 'button_expand');
          }
        });

        /* If it should start collapsed */
        if (this.options.collapsed) {
          (0,_utilities_js__WEBPACK_IMPORTED_MODULE_29__.trigger)(this.toggle_button, 'click');
        }

        /* Collapse button disabled */
        if (this.schema.options && typeof this.schema.options.disable_collapse !== 'undefined') {
          if (this.schema.options.disable_collapse) this.toggle_button.style.display = 'none';
        } else if (this.jsoneditor.options.disable_collapse) {
          this.toggle_button.style.display = 'none';
        }
      }

      /* Add "new row" and "delete last" buttons below editor */
      this.add_row_button = this._createAddRowButton();
      this.delete_last_row_button = this._createDeleteLastRowButton();
      this.remove_all_rows_button = this._createRemoveAllRowsButton();
    }
  }, {
    key: "_createToggleButton",
    value: function _createToggleButton() {
      var button = this.getButton('', 'collapse', 'button_collapse');
      button.classList.add('json-editor-btntype-toggle');
      return button;
    }
  }, {
    key: "_createAddRowButton",
    value: function _createAddRowButton() {
      var _this10 = this;
      var button = this.getButton(this.getItemTitle(), 'add', 'button_add_row_title', [this.getItemTitle()]);
      button.classList.add('json-editor-btntype-add');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var editor = _this10.addRow();
        _this10.refreshValue();
        _this10.refreshRowButtons();
        _this10.onChange(true);
        _this10.jsoneditor.trigger('addRow', editor);
      });
      this.controls.appendChild(button);
      return button;
    }
  }, {
    key: "_createDeleteLastRowButton",
    value: function _createDeleteLastRowButton() {
      var _this11 = this;
      var button = this.getButton('button_delete_last', 'subtract', 'button_delete_last_title', [this.getItemTitle()]);
      button.classList.add('json-editor-btntype-deletelast');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this11.askConfirmation()) {
          return false;
        }
        var rows = _this11.getValue();
        var editorValue = rows.pop();
        _this11.setValue(rows);
        _this11.onChange(true);
        _this11.jsoneditor.trigger('deleteRow', editorValue);
      });
      this.controls.appendChild(button);
      return button;
    }
  }, {
    key: "_createRemoveAllRowsButton",
    value: function _createRemoveAllRowsButton() {
      var _this12 = this;
      var button = this.getButton('button_delete_all', 'delete', 'button_delete_all_title');
      button.classList.add('json-editor-btntype-deleteall');
      button.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        if (!_this12.askConfirmation()) {
          return false;
        }
        var values = _this12.getValue();
        _this12.setValue([]);
        _this12.onChange(true);
        _this12.jsoneditor.trigger('deleteAllRows', values);
      });
      this.controls.appendChild(button);
      return button;
    }
  }]);
}(_array_js__WEBPACK_IMPORTED_MODULE_28__.ArrayEditor);

/***/ }),

/***/ "./src/editors/upload.js":
/*!*******************************!*\
  !*** ./src/editors/upload.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UploadEditor: () => (/* binding */ UploadEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ "./node_modules/core-js/modules/es.array.for-each.js");
/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.number.to-fixed.js */ "./node_modules/core-js/modules/es.number.to-fixed.js");
/* harmony import */ var core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.parse-float.js */ "./node_modules/core-js/modules/es.parse-float.js");
/* harmony import */ var core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_parse_float_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
/* harmony import */ var core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_constructor_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../editor.js */ "./src/editor.js");
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }






























function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var UploadEditor = /*#__PURE__*/function (_AbstractEditor) {
  function UploadEditor() {
    _classCallCheck(this, UploadEditor);
    return _callSuper(this, UploadEditor, arguments);
  }
  _inherits(UploadEditor, _AbstractEditor);
  return _createClass(UploadEditor, [{
    key: "getNumColumns",
    value: function getNumColumns() {
      return 4;
    }
  }, {
    key: "build",
    value: function build() {
      var _this = this;
      if (!this.options.compact) this.header = this.label = this.theme.getFormInputLabel(this.getTitle(), this.isRequired());
      if (this.schema.description) this.description = this.theme.getFormInputDescription(this.translateProperty(this.schema.description));
      if (this.options.infoText) this.infoButton = this.theme.getInfoButton(this.translateProperty(this.options.infoText));
      if (this.options.hidden) this.container.style.display = 'none';

      /* Editor options */
      this.options = this.expandCallbacks('upload', (0,_utilities_js__WEBPACK_IMPORTED_MODULE_31__.extend)({}, {
        title: 'Browse',
        icon: '',
        auto_upload: false,
        /* Trigger file upload button automatically */
        hide_input: false,
        /* Hide the Browse button and name display (Only works if 'enable_drag_drop' is true) */
        enable_drag_drop: false,
        /* Enable Drag&Drop uploading */
        drop_zone_text: 'Drag & Drop file here',
        /* Text displayed in dropzone box */
        drop_zone_top: false,
        /* Position of dropzone. true=before button input, false=after button input */
        alt_drop_zone: '',
        /* Alternate DropZone DOM selector (Can be created inside another property) */
        mime_type: '',
        /* If set, restricts to mime type(s). Can be either a string or an array */
        max_upload_size: 0,
        /* Maximum file size allowed. 0 = no limit */
        upload_handler: function upload_handler(jseditor, type, file, cbs) {
          /* Default dummy test upload handler */
          window.alert("No upload_handler defined for \"".concat(jseditor.path, "\". You must create your own handler to enable upload to server"));
        }
      }, this.defaults.options.upload || {}, this.options.upload || {}));
      this.options.mime_type = this.options.mime_type ? [].concat(this.options.mime_type) : [];

      /* Input that holds the base64 string */
      this.input = this.theme.getFormInputField('hidden');
      this.container.appendChild(this.input);

      /* Don't show uploader if this is readonly */
      if (!this.schema.readOnly && !this.schema.readonly) {
        if (typeof this.options.upload_handler !== 'function') throw new Error('Upload handler required for upload editor');

        /* File uploader */
        this.uploader = this.theme.getFormInputField('file');
        this.uploader.style.display = 'none';
        if (this.options.mime_type.length) this.uploader.setAttribute('accept', this.options.mime_type);
        if (!(this.options.enable_drag_drop === true && this.options.hide_input === true)) {
          /* Pass click to this.uploader element */
          this.clickHandler = function (e) {
            _this.uploader.dispatchEvent(new window.MouseEvent('click', {
              view: window,
              bubbles: true,
              cancelable: false
            }));
          };

          /* Browse button */
          this.browseButton = this.getButton(this.options.title, this.options.icon, this.options.title);
          this.browseButton.addEventListener('click', this.clickHandler);

          /* Display field */
          this.fileDisplay = this.theme.getFormInputField('input');
          this.fileDisplay.setAttribute('readonly', true);
          this.fileDisplay.value = 'No file selected.';
          this.fileDisplay.addEventListener('dblclick', this.clickHandler);
          this.fileUploadGroup = this.theme.getInputGroup(this.fileDisplay, [this.browseButton]);
          if (!this.fileUploadGroup) {
            /* Themes that doesn't support input grouping */
            this.fileUploadGroup = document.createElement('div');
            this.fileUploadGroup.appendChild(this.fileDisplay);
            this.fileUploadGroup.appendChild(this.browseButton);
          }
        }

        /* Drag&Drop upload enabled */
        if (this.options.enable_drag_drop === true) {
          /* Alternate DropZone defined */
          if (this.options.alt_drop_zone !== '') {
            this.altDropZone = document.querySelector(this.options.alt_drop_zone);
            if (this.altDropZone) this.dropZone = this.altDropZone;else throw new Error("Error: alt_drop_zone selector \"".concat(this.options.alt_drop_zone, "\" not found!"));
          } else this.dropZone = this.theme.getDropZone(this.options.drop_zone_text);
          if (this.dropZone) {
            this.dropZone.classList.add('upload-dropzone');
            this.dropZone.addEventListener('dblclick', this.clickHandler);
          }
        }

        /* Triggered after file have been selected */
        this.uploadHandler = function (e) {
          e.preventDefault();
          e.stopPropagation();
          var files = e.target.files || e.dataTransfer.files;
          if (files && files.length) {
            if (_this.options.max_upload_size !== 0 && files[0].size > _this.options.max_upload_size) {
              _this.theme.addInputError(_this.uploader, "".concat(_this.translate('upload_max_size'), " ").concat(_this.options.max_upload_size));
            } else if (_this.options.mime_type.length !== 0 && !_this.isValidMimeType(files[0].type, _this.options.mime_type)) {
              _this.theme.addInputError(_this.uploader, "".concat(_this.translate('upload_wrong_file_format'), " ").concat(_this.options.mime_type.toString()));
            } else {
              if (_this.fileDisplay) _this.fileDisplay.value = files[0].name;
              var fr = new window.FileReader();
              fr.onload = function (evt) {
                _this.preview_value = evt.target.result;
                _this.refreshPreview(files);
                _this.onChange(true);
                fr = null;
              };
              fr.readAsDataURL(files[0]);
            }
          }
        };
        this.uploader.addEventListener('change', this.uploadHandler);

        /* Drag&Drop Event Handler */
        this.dragHandler = function (e) {
          var files = e.dataTransfer.items || e.dataTransfer.files;
          var validType = files && files.length && (_this.options.mime_type.length === 0 || _this.isValidMimeType(files[0].type, _this.options.mime_type));
          var validZone = e.currentTarget.classList && e.currentTarget.classList.contains('upload-dropzone') && validType;
          switch ((e.currentTarget === window ? 'w_' : 'e_') + e.type) {
            case 'w_drop':
            case 'w_dragover':
              /* prevent default browser action if dropped outside dropzone */
              if (!validZone) e.dataTransfer.dropEffect = 'none';
              break;
            case 'e_dragenter':
              {
                if (validZone) {
                  _this.dropZone.classList.add('valid-dropzone');
                  e.dataTransfer.dropEffect = 'copy';
                } else _this.dropZone.classList.add('invalid-dropzone');
                break;
              }
            case 'e_dragover':
              {
                if (validZone) e.dataTransfer.dropEffect = 'copy';
                break;
              }
            case 'e_dragleave':
              _this.dropZone.classList.remove('valid-dropzone', 'invalid-dropzone');
              break;
            case 'e_drop':
              {
                _this.dropZone.classList.remove('valid-dropzone', 'invalid-dropzone');
                if (validZone) _this.uploadHandler(e);
                break;
              }
          }
          if (!validZone) e.preventDefault();
        };

        /* Set Drag'n'Drop handlers */
        if (this.options.enable_drag_drop === true) {
          ['dragover', 'drop'].forEach(function (ev) {
            window.addEventListener(ev, _this.dragHandler, true);
          });
          ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(function (ev) {
            _this.dropZone.addEventListener(ev, _this.dragHandler, true);
          });
        }
      }
      this.preview = document.createElement('div');
      this.control = this.input.controlgroup = this.theme.getFormControl(this.label, this.uploader || this.input, this.description, this.infoButton);
      if (this.uploader) this.uploader.controlgroup = this.control;
      var inputNode = this.uploader || this.input;
      var elements = document.createElement('div');
      if (this.dropZone && !this.altDropZone && this.options.drop_zone_top === true) elements.appendChild(this.dropZone);
      if (this.fileUploadGroup) elements.appendChild(this.fileUploadGroup);
      if (this.dropZone && !this.altDropZone && this.options.drop_zone_top !== true) elements.appendChild(this.dropZone);
      elements.appendChild(this.preview);
      inputNode.parentNode.insertBefore(elements, inputNode.nextSibling);
      this.container.appendChild(this.control);

      /* Any special formatting that needs to happen after the input is added to the dom */
      window.requestAnimationFrame(function () {
        _this.afterInputReady();
      });
    }
  }, {
    key: "afterInputReady",
    value: function afterInputReady() {
      var _this2 = this;
      if (this.value) {
        var img = document.createElement('img');
        img.style.maxWidth = '100%';
        img.style.maxHeight = '100px';
        img.onload = function (event) {
          _this2.preview.appendChild(img);
        };
        img.onerror = function (error) {
          // eslint-disable-next-line no-console
          console.error('upload error', error, error.currentTarget);
        };
        img.src = this.container.querySelector('a').href;
      }
      this.theme.afterInputReady(this.input);
    }
  }, {
    key: "refreshPreview",
    value: function refreshPreview(files) {
      var _this3 = this;
      if (this.last_preview === this.preview_value) return;
      this.last_preview = this.preview_value;
      this.preview.innerHTML = '';
      if (!this.preview_value) return;
      var file = files[0];

      /* mime type extracted from file data. More exact than the one in the file object */
      var mime = this.preview_value.match(/^data:([^;,]+)[;,]/);
      file.mimeType = mime ? mime[1] : 'unknown';
      if (file.size > 0) {
        /* Format bytes as KB/MB etc. with 2 decimals */
        var i = Math.floor(Math.log(file.size) / Math.log(1024));
        file.formattedSize = "".concat(parseFloat((file.size / Math.pow(1024, i)).toFixed(2)), " ").concat(['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'][i]);
      } else file.formattedSize = '0 Bytes';
      var uploadButton = this.getButton('button_upload', 'upload', 'button_upload');
      uploadButton.addEventListener('click', function (event) {
        event.preventDefault();
        uploadButton.setAttribute('disabled', 'disabled');
        _this3.theme.removeInputError(_this3.uploader);
        if (_this3.theme.getProgressBar) {
          _this3.progressBar = _this3.theme.getProgressBar();
          _this3.preview.appendChild(_this3.progressBar);
        }
        _this3.options.upload_handler(_this3.path, file, {
          success: function success(url) {
            _this3.setValue(url);
            if (_this3.parent) _this3.parent.onChildEditorChange(_this3);else _this3.jsoneditor.onChange();
            if (_this3.progressBar) _this3.preview.removeChild(_this3.progressBar);
            uploadButton.removeAttribute('disabled');
          },
          failure: function failure(error) {
            _this3.theme.addInputError(_this3.uploader, error);
            if (_this3.progressBar) _this3.preview.removeChild(_this3.progressBar);
            uploadButton.removeAttribute('disabled');
          },
          updateProgress: function updateProgress(progress) {
            if (_this3.progressBar) {
              if (progress) _this3.theme.updateProgressBar(_this3.progressBar, progress);else _this3.theme.updateProgressBarUnknown(_this3.progressBar);
            }
          }
        });
      });
      this.preview.appendChild(this.theme.getUploadPreview(file, uploadButton, this.preview_value));
      if (this.options.auto_upload) {
        uploadButton.dispatchEvent(new window.MouseEvent('click'));
        uploadButton.parentNode.removeChild(uploadButton);
      }
    }
  }, {
    key: "enable",
    value: function enable() {
      if (!this.always_disabled) {
        if (this.uploader) this.uploader.disabled = false;
        _get(_getPrototypeOf(UploadEditor.prototype), "enable", this).call(this);
      }
    }
  }, {
    key: "disable",
    value: function disable(alwaysDisabled) {
      if (alwaysDisabled) this.always_disabled = true;
      if (this.uploader) this.uploader.disabled = true;
      _get(_getPrototypeOf(UploadEditor.prototype), "disable", this).call(this);
    }
  }, {
    key: "setValue",
    value: function setValue(val) {
      val = this.applyConstFilter(val);
      if (this.value !== val) {
        this.value = val;
        this.input.value = this.value;
        this.onChange();
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var _this4 = this;
      /* Remove Drag'n'Drop handlers */
      if (this.options.enable_drag_drop === true) {
        ['dragover', 'drop'].forEach(function (ev) {
          window.removeEventListener(ev, _this4.dragHandler, true);
        });
        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(function (ev) {
          _this4.dropZone.removeEventListener(ev, _this4.dragHandler, true);
        });
        this.dropZone.removeEventListener('dblclick', this.clickHandler);
        if (this.dropZone && this.dropZone.parentNode) this.dropZone.parentNode.removeChild(this.dropZone);
      }
      if (this.uploader && this.uploader.parentNode) {
        this.uploader.removeEventListener('change', this.uploadHandler);
        this.uploader.parentNode.removeChild(this.uploader);
      }
      if (this.browseButton && this.browseButton.parentNode) {
        this.browseButton.removeEventListener('click', this.clickHandler);
        this.browseButton.parentNode.removeChild(this.browseButton);
      }
      if (this.fileDisplay && this.fileDisplay.parentNode) {
        this.fileDisplay.removeEventListener('dblclick', this.clickHandler);
        this.fileDisplay.parentNode.removeChild(this.fileDisplay);
      }
      if (this.fileUploadGroup && this.fileUploadGroup.parentNode) this.fileUploadGroup.parentNode.removeChild(this.fileUploadGroup);
      if (this.preview && this.preview.parentNode) this.preview.parentNode.removeChild(this.preview);
      if (this.header && this.header.parentNode) this.header.parentNode.removeChild(this.header);
      if (this.input && this.input.parentNode) this.input.parentNode.removeChild(this.input);
      _get(_getPrototypeOf(UploadEditor.prototype), "destroy", this).call(this);
    }
  }, {
    key: "isValidMimeType",
    value: function isValidMimeType(mimeType, mimeTypesList) {
      return mimeTypesList.reduce(function (a, v) {
        return a || new RegExp(v.replace(/\*/g, '.*'), 'gi').test(mimeType);
      }, false);
    }
  }]);
}(_editor_js__WEBPACK_IMPORTED_MODULE_30__.AbstractEditor);

/***/ }),

/***/ "./src/editors/uuid.js":
/*!*****************************!*\
  !*** ./src/editors/uuid.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UuidEditor: () => (/* binding */ UuidEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.reflect.get.js */ "./node_modules/core-js/modules/es.reflect.get.js");
/* harmony import */ var core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_get_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _utilities_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utilities.js */ "./src/utilities.js");
/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./string.js */ "./src/editors/string.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }



















function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }


var UuidEditor = /*#__PURE__*/function (_StringEditor) {
  function UuidEditor() {
    _classCallCheck(this, UuidEditor);
    return _callSuper(this, UuidEditor, arguments);
  }
  _inherits(UuidEditor, _StringEditor);
  return _createClass(UuidEditor, [{
    key: "preBuild",
    value: function preBuild() {
      _get(_getPrototypeOf(UuidEditor.prototype), "preBuild", this).call(this);

      /* Use Schema "default" for setting autogenerated uuid */
      this.schema["default"] = this.uuid = this.getUuid();

      /* Set cleave options if no existing options is present */
      if (!this.schema.options) this.schema.options = {};
      if (!this.schema.options.cleave) {
        this.schema.options.cleave = {
          delimiters: ['-'],
          blocks: [8, 4, 4, 4, 12]
        };
      }
    }
  }, {
    key: "build",
    value: function build() {
      _get(_getPrototypeOf(UuidEditor.prototype), "build", this).call(this);
      /* Set field to readonly */
      this.disable(true);
      this.input.setAttribute('readonly', 'true');
    }
  }, {
    key: "sanitize",
    value: function sanitize(value) {
      if (!this.testUuid(value)) value = this.uuid;
      return value;
    }
  }, {
    key: "setValue",
    value: function setValue(value, initial, fromTemplate) {
      value = this.applyConstFilter(value);
      if (!this.testUuid(value)) value = this.uuid;
      this.uuid = value;
      _get(_getPrototypeOf(UuidEditor.prototype), "setValue", this).call(this, value, initial, fromTemplate);
    }
  }, {
    key: "getUuid",
    value: function getUuid() {
      return (0,_utilities_js__WEBPACK_IMPORTED_MODULE_19__.generateUUID)();
    }
  }, {
    key: "testUuid",
    value: function testUuid(value) {
      return /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(value);
    }
  }]);
}(_string_js__WEBPACK_IMPORTED_MODULE_20__.StringEditor);

/***/ }),

/***/ "./src/iconlib.js":
/*!************************!*\
  !*** ./src/iconlib.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractIconLib: () => (/* binding */ AbstractIconLib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.is-array.js */ "./node_modules/core-js/modules/es.array.is-array.js");
/* harmony import */ var core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_is_array_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.date.to-string.js */ "./node_modules/core-js/modules/es.date.to-string.js");
/* harmony import */ var core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_string_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_17__);


















function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var defaultMapping = {
  collapse: '',
  expand: '',
  "delete": '',
  edit: '',
  add: '',
  cancel: '',
  save: '',
  moveup: '',
  movedown: ''
};
var AbstractIconLib = /*#__PURE__*/function () {
  function AbstractIconLib() {
    var iconPrefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var mapping = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : defaultMapping;
    _classCallCheck(this, AbstractIconLib);
    this.mapping = mapping;
    this.icon_prefix = iconPrefix;
  }
  return _createClass(AbstractIconLib, [{
    key: "getIconClass",
    value: function getIconClass(key) {
      return this.mapping[key] ? this.icon_prefix + this.mapping[key] : this.icon_prefix + key;
    }
  }, {
    key: "getIcon",
    value: function getIcon(key) {
      var _i$classList;
      var iconclass = this.getIconClass(key);
      if (!iconclass) return null;
      var i = document.createElement('i');
      (_i$classList = i.classList).add.apply(_i$classList, _toConsumableArray(iconclass.split(' ')));
      return i;
    }
  }]);
}();

/***/ }),

/***/ "./src/iconlibs/bootstrap.js":
/*!***********************************!*\
  !*** ./src/iconlibs/bootstrap.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   bootstrapIconlib: () => (/* binding */ bootstrapIconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _iconlib_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../iconlib.js */ "./src/iconlib.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var iconPrefix = 'bi bi-';
var mapping = {
  collapse: 'chevron-down',
  expand: 'chevron-right',
  "delete": 'trash',
  edit: 'pencil',
  add: 'plus',
  subtract: 'dash',
  cancel: 'x-circle',
  save: 'save',
  moveup: 'arrow-up',
  moveright: 'arrow-right',
  movedown: 'arrow-down',
  moveleft: 'arrow-left',
  copy: 'clipboard',
  clear: 'x-circle',
  time: 'clock',
  calendar: 'calendar',
  edit_properties: 'list-ul'
};
var bootstrapIconlib = /*#__PURE__*/function (_AbstractIconLib) {
  function bootstrapIconlib() {
    _classCallCheck(this, bootstrapIconlib);
    return _callSuper(this, bootstrapIconlib, [iconPrefix, mapping]);
  }
  _inherits(bootstrapIconlib, _AbstractIconLib);
  return _createClass(bootstrapIconlib);
}(_iconlib_js__WEBPACK_IMPORTED_MODULE_16__.AbstractIconLib);

/***/ }),

/***/ "./src/iconlibs/bootstrap3.js":
/*!************************************!*\
  !*** ./src/iconlibs/bootstrap3.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   bootstrap3Iconlib: () => (/* binding */ bootstrap3Iconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _iconlib_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../iconlib.js */ "./src/iconlib.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var iconPrefix = 'glyphicon glyphicon-';
var mapping = {
  collapse: 'chevron-down',
  expand: 'chevron-right',
  "delete": 'trash',
  edit: 'pencil',
  add: 'plus',
  subtract: 'minus',
  cancel: 'floppy-remove',
  save: 'floppy-saved',
  moveup: 'arrow-up',
  moveright: 'arrow-right',
  movedown: 'arrow-down',
  moveleft: 'arrow-left',
  copy: 'copy',
  clear: 'remove-circle',
  time: 'time',
  calendar: 'calendar',
  edit_properties: 'list'
};
var bootstrap3Iconlib = /*#__PURE__*/function (_AbstractIconLib) {
  function bootstrap3Iconlib() {
    _classCallCheck(this, bootstrap3Iconlib);
    return _callSuper(this, bootstrap3Iconlib, [iconPrefix, mapping]);
  }
  _inherits(bootstrap3Iconlib, _AbstractIconLib);
  return _createClass(bootstrap3Iconlib);
}(_iconlib_js__WEBPACK_IMPORTED_MODULE_16__.AbstractIconLib);

/***/ }),

/***/ "./src/iconlibs/fontawesome3.js":
/*!**************************************!*\
  !*** ./src/iconlibs/fontawesome3.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fontawesome3Iconlib: () => (/* binding */ fontawesome3Iconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _iconlib_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../iconlib.js */ "./src/iconlib.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var iconPrefix = 'icon-';
var mapping = {
  collapse: 'chevron-down',
  expand: 'chevron-right',
  "delete": 'trash',
  edit: 'pencil',
  add: 'plus',
  subtract: 'minus',
  cancel: 'ban-circle',
  save: 'save',
  moveup: 'arrow-up',
  moveright: 'arrow-right',
  movedown: 'arrow-down',
  moveleft: 'arrow-left',
  copy: 'copy',
  clear: 'remove-circle',
  time: 'time',
  calendar: 'calendar',
  edit_properties: 'list'
};
var fontawesome3Iconlib = /*#__PURE__*/function (_AbstractIconLib) {
  function fontawesome3Iconlib() {
    _classCallCheck(this, fontawesome3Iconlib);
    return _callSuper(this, fontawesome3Iconlib, [iconPrefix, mapping]);
  }
  _inherits(fontawesome3Iconlib, _AbstractIconLib);
  return _createClass(fontawesome3Iconlib);
}(_iconlib_js__WEBPACK_IMPORTED_MODULE_16__.AbstractIconLib);

/***/ }),

/***/ "./src/iconlibs/fontawesome4.js":
/*!**************************************!*\
  !*** ./src/iconlibs/fontawesome4.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fontawesome4Iconlib: () => (/* binding */ fontawesome4Iconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _iconlib_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../iconlib.js */ "./src/iconlib.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var iconPrefix = 'fa fa-';
var mapping = {
  collapse: 'caret-square-o-down',
  expand: 'caret-square-o-right',
  "delete": 'times',
  edit: 'pencil',
  add: 'plus',
  subtract: 'minus',
  cancel: 'ban',
  save: 'save',
  moveup: 'arrow-up',
  moveright: 'arrow-right',
  movedown: 'arrow-down',
  moveleft: 'arrow-left',
  copy: 'files-o',
  clear: 'times-circle-o',
  time: 'clock-o',
  calendar: 'calendar',
  edit_properties: 'list'
};
var fontawesome4Iconlib = /*#__PURE__*/function (_AbstractIconLib) {
  function fontawesome4Iconlib() {
    _classCallCheck(this, fontawesome4Iconlib);
    return _callSuper(this, fontawesome4Iconlib, [iconPrefix, mapping]);
  }
  _inherits(fontawesome4Iconlib, _AbstractIconLib);
  return _createClass(fontawesome4Iconlib);
}(_iconlib_js__WEBPACK_IMPORTED_MODULE_16__.AbstractIconLib);

/***/ }),

/***/ "./src/iconlibs/fontawesome5.js":
/*!**************************************!*\
  !*** ./src/iconlibs/fontawesome5.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fontawesome5Iconlib: () => (/* binding */ fontawesome5Iconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
/* harmony import */ var core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_date_to_primitive_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.bind.js */ "./node_modules/core-js/modules/es.function.bind.js");
/* harmony import */ var core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_bind_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.create.js */ "./node_modules/core-js/modules/es.object.create.js");
/* harmony import */ var core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_create_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.define-property.js */ "./node_modules/core-js/modules/es.object.define-property.js");
/* harmony import */ var core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_define_property_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_prototype_of_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.object.set-prototype-of.js */ "./node_modules/core-js/modules/es.object.set-prototype-of.js");
/* harmony import */ var core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_set_prototype_of_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.reflect.construct.js */ "./node_modules/core-js/modules/es.reflect.construct.js");
/* harmony import */ var core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _iconlib_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../iconlib.js */ "./src/iconlib.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
















function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var iconPrefix = 'fas fa-';
var mapping = {
  collapse: 'caret-down',
  expand: 'caret-right',
  "delete": 'trash',
  edit: 'pen',
  add: 'plus',
  subtract: 'minus',
  cancel: 'ban',
  save: 'save',
  moveup: 'arrow-up',
  moveright: 'arrow-right',
  movedown: 'arrow-down',
  moveleft: 'arrow-left',
  copy: 'copy',
  clear: 'times-circle',
  time: 'clock',
  calendar: 'calendar',
  edit_properties: 'list'
};
var fontawesome5Iconlib = /*#__PURE__*/function (_AbstractIconLib) {
  function fontawesome5Iconlib() {
    _classCallCheck(this, fontawesome5Iconlib);
    return _callSuper(this, fontawesome5Iconlib, [iconPrefix, mapping]);
  }
  _inherits(fontawesome5Iconlib, _AbstractIconLib);
  return _createClass(fontawesome5Iconlib);
}(_iconlib_js__WEBPACK_IMPORTED_MODULE_16__.AbstractIconLib);

/***/ }),

/***/ "./src/iconlibs/index.js":
/*!*******************************!*\
  !*** ./src/iconlibs/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   iconlibs: () => (/* binding */ iconlibs)
/* harmony export */ });
/* harmony import */ var _bootstrap3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bootstrap3.js */ "./src/iconlibs/bootstrap3.js");
/* harmony import */ var _fontawesome3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fontawesome3.js */ "./src/iconlibs/fontawesome3.js");
/* harmony import */ var _fontawesome4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fontawesome4.js */ "./src/iconlibs/fontawesome4.js");
/* harmony import */ var _fontawesome5_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./fontawesome5.js */ "./src/iconlibs/fontawesome5.js");
/* harmony import */ var _jqueryui_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./jqueryui.js */ "./src/iconlibs/jqueryui.js");
/* harmony import */ var _openiconic_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./openiconic.js */ "./src/iconlibs/openiconic.js");
/* harmony import */ var _spectre_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./spectre.js */ "./src/iconlibs/spectre.js");
/* harmony import */ var _bootstrap__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./bootstrap */ "./src/iconlibs/bootstrap.js");
// import  { bootstrap2Iconlib } from  './bootstrap2.js'




// import  { foundation2Iconlib } from  './foundation2.js'
// import  { foundation3Iconlib } from  './foundation3.js'

// import  { materialiconsIconlib } from  './materialicons.js'



var iconlibs = {
  // bootstrap2: bootstrap2Iconlib,
  bootstrap: _bootstrap__WEBPACK_IMPORTED_MODULE_7__.bootstrapIconlib,
  bootstrap3: _bootstrap3_js__WEBPACK_IMPORTED_MODULE_0__.bootstrap3Iconlib,
  fontawesome3: _fontawesome3_js__WEBPACK_IMPORTED_MODULE_1__.fontawesome3Iconlib,
  fontawesome4: _fontawesome4_js__WEBPACK_IMPORTED_MODULE_2__.fontawesome4Iconlib,
  fontawesome5: _fontawesome5_js__WEBPACK_IMPORTED_MODULE_3__.fontawesome5Iconlib,
  // foundation2: foundation2Iconlib,
  // foundation3: foundation3Iconlib,
  jqueryui: _jqueryui_js__WEBPACK_IMPORTED_MODULE_4__.jqueryuiIconlib,
  // materialicons: materialiconsIconlib,
  openiconic: _openiconic_js__WEBPACK_IMPORTED_MODULE_5__.openiconicIconlib,
  spectre: _spectre_js__WEBPACK_IMPORTED_MODULE_6__.spectreIconlib
};

/***/ }),

/***/ "./src/iconlibs/jqueryui.js":
/*!**********************************!*\
  !*** ./src/iconlibs/jqueryui.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   jqueryuiIconlib: () => (/* binding */ jqueryuiIconlib)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator.js */ "./node_modules/core-js/modules/es.symbol.iterator.js");
/* harmony import */ var core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
/* harmony import */ var core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_to_primitive_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_