<?php

namespace Drupal\pci_sri\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\pci_sri\Entity\Sri;

/**
 * SRI form.
 */
class SriForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state): array {

    $form = parent::form($form, $form_state);

    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $this->entity->label(),
      '#required' => TRUE,
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $this->entity->id(),
      '#machine_name' => [
        'exists' => [Sri::class, 'load'],
      ],
      '#disabled' => !$this->entity->isNew(),
    ];

    $form['status'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enabled'),
      '#default_value' => $this->entity->status(),
    ];

    $form['js_file_path'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Javascript File Path'),
      '#default_value' => $this->entity->get('js_file_path'),
      '#required' => TRUE,
    ];

    $form['sri_hash'] = [
      '#type' => 'textfield',
      '#title' => $this->t('SRI Hash'),
      '#maxlength' => 255,
      '#default_value' => $this->entity->get('sri_hash'),
      '#attributes' => [
        'style' => 'width: 100%;',
      ],
    ];

    $form['cross_origin'] = [
      '#type' => 'select',
      '#title' => $this->t('Cross-Origin'),
      '#options' => [
        'anonymous' => $this->t('anonymous'),
        'use-credentials' => $this->t('use-credentials'),
      ],
      '#default_value' => $this->entity->get('cross_origin') ?? 'anonymous',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state): int {
    $result = parent::save($form, $form_state);
    $message_args = ['%label' => $this->entity->label()];
    $this->messenger()->addStatus(
      match($result) {
        \SAVED_NEW => $this->t('Created new example %label.', $message_args),
        \SAVED_UPDATED => $this->t('Updated example %label.', $message_args),
      }
    );
    $form_state->setRedirectUrl($this->entity->toUrl('collection'));
    return $result;
  }

}
