<?php

namespace Drupal\pci_sri\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\pci_sri\SriInterface;

/**
 * Defines the SRI entity type.
 *
 * @ConfigEntityType(
 *   id = "sri",
 *   label = @Translation("SRI"),
 *   label_collection = @Translation("SRIs"),
 *   label_singular = @Translation("SRI"),
 *   label_plural = @Translation("SRIs"),
 *   label_count = @PluralTranslation(
 *     singular = "@count SRI",
 *     plural = "@count SRIs",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\pci_sri\SriListBuilder",
 *     "form" = {
 *       "add" = "Drupal\pci_sri\Form\SriForm",
 *       "edit" = "Drupal\pci_sri\Form\SriForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "sri",
 *   admin_permission = "administer sri",
 *   links = {
 *     "collection" = "/admin/structure/sri",
 *     "add-form" = "/admin/structure/sri/add",
 *     "edit-form" = "/admin/structure/sri/{sri}",
 *     "delete-form" = "/admin/structure/sri/{sri}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "js_file_path",
 *     "sri_hash",
 *     "cross_origin"
 *
 *   },
 * )
 */
final class Sri extends ConfigEntityBase implements SriInterface {

  /**
   * The SRI ID.
   */
  protected string $id;

  /**
   * The Javascript file name.
   */
  protected string $label;

  /**
   * The Javascript file path.
   */
  protected string $js_file_path;

  /**
   * The SRI hash.
   */
  protected string $sri_hash;

  /**
   * The cross-origin.
   */
  protected string $cross_origin;

}
