<?php

declare(strict_types=1);

namespace Drupal\pci_sri;

use Drupal\Core\DrupalKernelInterface;
use Drupal\Core\Extension\ExtensionDiscovery;

/**
 * Provides a service which wraps the Drupal extension discovery class.
 */
class PciSriExtensionDiscovery {

  /**
   * The extension discovery object.
   *
   * @var \Drupal\Core\Extension\ExtensionDiscovery
   */
  protected $extensionDiscovery;

  /**
   * Constructs a new PciSriExtensionDiscovery object.
   *
   * @param \Drupal\Core\DrupalKernelInterface $kernel
   *   The Drupal kernel.
   */
  public function __construct(DrupalKernelInterface $kernel) {
    $app_root = $kernel->getAppRoot();
    $this->extensionDiscovery = new ExtensionDiscovery($app_root);
  }

  /**
   * Discovers available extensions of a given type.
   *
   * @param string $type
   *   The type of extension to discover.
   * @param bool $include_tests
   *   Whether to include test modules.
   *
   * @return \Drupal\Core\Extension\Extension[]
   *   An associative array of Extension objects, keyed by extension name.
   */
  public function scan(string $type, bool $include_tests = FALSE): array {
    return $this->extensionDiscovery->scan($type, $include_tests);
  }

}
