<?php

namespace Drupal\pdb\Discovery;

use Drupal\Core\Extension\Discovery\RecursiveExtensionFilterCallback;

/**
 * {@inheritdoc}
 *
 * Extends to provide custom whitelist and blacklist.
 */
class PdbRecursiveExtensionFilterCallback extends RecursiveExtensionFilterCallback {

  /**
   * {@inheritdoc}
   */
  protected array $allowedExtensionTypes = [
    'components',
    'src',
  ];

  /**
   * {@inheritdoc}
   */
  protected array $skippedFolders = [
    // Object-oriented code subdirectories.
    'lib',
    'vendor',
    // Front-end.
    'assets',
    'css',
    'files',
    'images',
    'js',
    'misc',
    'templates',
    // Legacy subdirectories.
    'includes',
    // Test subdirectories.
    'fixtures',
    // @todo ./tests/Drupal should be ./tests/src/Drupal
    'Drupal',
  ];

}
