# PDF Forge

**Machine name:** `pdf_forge`  
**Description:** Forges PDFs from Drupal render arrays using Dompdf (pure PHP).  

## Overview

PDF Forge is a Drupal module that converts Drupal render arrays into high-quality PDF documents using the [Dompdf](https://github.com/dompdf/dompdf) library (pure PHP, no external binaries required).

It includes:

- **Settings UI** to configure default font, page size, orientation, and remote asset permissions.
- **Demo hub page** with:
  - **Basic demo** — minimal render array → PDF for sanity checks.
  - **Advanced demo** — includes header/footer HTML, page margins, pagination, and an embedded SVG logo.

## Features

- Converts any Drupal render array into a PDF.
- Supports HTML, inline CSS, and remote assets (with allowlist).
- Customizable headers and footers with independent height settings.
- Page size and orientation settings (e.g., A4, Letter, Portrait, Landscape).
- Pagination support with configurable placement.
- Pure PHP solution — no need for external PDF software.

## Requirements

- Drupal 10 or later  
- PHP 8.1+  
- [dompdf/dompdf](https://github.com/dompdf/dompdf) library (installed via Composer)

## Installation

1. Install the module via Composer:

   ```bash
   composer require drupal/pdf_forge
   ```

2. Enable the module:

   ```bash
   drush en pdf_forge
   ```

3. (Optional) Configure settings at:  
   `/admin/config/development/pdf-forge/settings`

## Usage

### Rendering a PDF from a render array
```php
/** @var \Drupal\pdf_forge\Service\PdfForgeInterface $pdf_forge */
$pdf_forge = \Drupal::service('pdf_forge.forge');

$build = [
  '#markup' => '<p>Hello PDF world!</p>',
];

$response = $pdf_forge->render($build, [
  'title' => 'example',
  'page_size' => 'A4',
  'orientation' => 'portrait',
]);

return $response; // Symfony Response object with PDF output
```

### Demo pages
- **Demo hub:** `/admin/config/development/pdf-forge/demo`
- **Basic demo:** `/admin/config/development/pdf-forge-demos/demo/basic`
- **Advanced demo:** `/admin/config/development/pdf-forge-demos/demo/advanced`

## Configuration

- **Default font** — Font family Dompdf should use when none is specified.
- **Allow remote assets** — Enable loading CSS/images from external hosts.
- **Remote allowlist** — List of allowed hostnames (one per line).
- **Default page size/orientation** — Used when not overridden per render.

## Development Notes

- The module defines a `PdfForgeInterface` for easy dependency injection and testability.
- Header/footer HTML is inserted with fixed positioning; ensure your `header_height_mm` and `footer_height_mm` values match your actual content height.
- All public assets use `public://` paths by default; stream-wrapper URIs are resolved to `file://` before rendering.

## License

This project is licensed under the GPL-2.0 or later. See the LICENSE file for details.

## Maintainers:

**Sohaib Mahtab**  
- [Drupal.org Profile](https://www.drupal.org/u/smahtab)