<?php

namespace Drupal\pdf_metadata\Provider;

/**
 * Interface for PDF metadata providers.
 */
interface PdfMetadataProviderInterface {

  /**
   * Get the provider name/label.
   *
   * @return string
   *   The human-readable name of the provider.
   */
  public function getLabel(): string;

  /**
   * Get the provider ID/machine name.
   *
   * @return string
   *   The machine name of the provider.
   */
  public function getId(): string;

  /**
   * Check if the provider is available on this system.
   *
   * @return bool
   *   TRUE if the provider can be used, FALSE otherwise.
   */
  public function isAvailable(): bool;

  /**
   * Get availability error message if provider is not available.
   *
   * @return string
   *   Error message explaining why provider is not available.
   */
  public function getAvailabilityError(): string;

  /**
   * Write metadata to a PDF file.
   *
   * @param string $file_path
   *   The real path to the PDF file.
   * @param array $metadata
   *   Array containing metadata keys: title, author, subject, keywords.
   *
   * @return bool
   *   TRUE on success, FALSE on failure.
   *
   * @throws \Exception
   *   On critical errors.
   */
  public function writeMetadata(string $file_path, array $metadata): bool;

  /**
   * Get the last error message from the provider.
   *
   * @return string
   *   The error message, or empty string if no error.
   */
  public function getLastError(): string;

}
