# PDF Node Export

**PDF Node Export** is a lightweight contributed module for Drupal 9/10/11 that enables you to export full node content (including Paragraphs) into a downloadable PDF using the [mPDF](https://mpdf.github.io) library.

---

## 🚀 Features

- Exports full rendered node content to PDF
- Supports nodes built using Paragraphs
- Simple URL-based export: `/node/[nid]/export-pdf`
- Translation-ready
- Compatible with Drupal 10 and 11

---

## 📦 Installation

1. **Install the module** in your Drupal instance:
   - Place the module in `modules/custom/pdf_node_export`

2. **Install the required mPDF library** via Composer:

   ```bash
   composer require mpdf/mpdf
   ```

3. **Enable the module** via UI or Drush:

   ```bash
   drush en pdf_node_export
   ```

---

## 🔗 Usage

To export any node as a PDF, visit:

```
/node/[nid]/export-pdf
```

Replace `[nid]` with the actual node ID.

---

## 💡 Tips

- Create a custom view mode (e.g., `pdf`) to control what fields are shown in the PDF.
- Apply custom CSS styles using mPDF's HTML/CSS rendering support.
- Extend functionality to add a download button directly to the node view.

---

## ✅ Requirements

- Drupal 10 or 11
- PHP 7.4+
- [mPDF](https://github.com/mpdf/mpdf) library

---

## 🧑‍💻 Maintainers

Developed and maintained by Nikhilesh Paul.

Pull requests and feature suggestions are welcome!
