<?php

namespace Drupal\pdf_node_export\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;
use Drupal\node\Entity\Node;

class PdfExportController extends ControllerBase {

  /**
   * Export a node as PDF.
   */
  public function export($node) {
    $node = Node::load($node);
    if (!$node) {
      throw new \Symfony\Component\HttpKernel\Exception\NotFoundHttpException();
    }

    // Render the full node content, including paragraphs.
    $view_builder = \Drupal::entityTypeManager()->getViewBuilder('node');
    $render_array = $view_builder->view($node, 'full');
    $html = \Drupal::service('renderer')->renderRoot($render_array);

    // Load mPDF.
    $mpdf = new \Mpdf\Mpdf();
    $mpdf->WriteHTML($html);

    return new Response(
      $mpdf->Output('', 'S'),
      200,
      [
        'Content-Type' => 'application/pdf',
        'Content-Disposition' => 'inline; filename="' . $node->id() . '.pdf"',
      ]
    );
  }
}
