# PDF Sanitizer

## Introduction

The PDF Sanitizer module automatically sanitizes uploaded PDF files by removing potentially malicious content, such as JavaScript actions. This helps enhance the security of your Drupal site by ensuring that only clean PDF files are stored and served.

## Requirements

This module requires **Ghostscript** to be installed and accessible on your server's command line. Ghostscript is a suite of software for interpreting PostScript and PDF files.

### Installing Ghostscript

**Linux (Debian/Ubuntu):**
```bash
sudo apt-get update
sudo apt-get install ghostscript
```

**Linux (RHEL/CentOS/Fedora):**
```bash
sudo yum install ghostscript
# or for Fedora
sudo dnf install ghostscript
```

**macOS (using Homebrew):**
```bash
brew install ghostscript
```

**Windows:**
Download the installer from the official Ghostscript website: [https://www.ghostscript.com/download/gsdnld.html](https://www.ghostscript.com/download/gsdnld.html)
Ensure that Ghostscript is added to your system's PATH environment variable during installation, or manually add it.

**DDEV (if using DDEV for local development):**
Ghostscript is usually available by default in DDEV containers. You can verify its presence by running:
```bash
ddev exec which gs
```
If it's not available, you might need to add a custom Dockerfile to your DDEV setup to install it.

## Installation

1.  Place the `pdf_sanitizer` module in your `modules/custom` directory.
2.  Enable the module using Drush:
    ```bash
    drush en pdf_sanitizer -y
    ```
    Or enable it through the Drupal admin interface (`/admin/modules`).

## Configuration

There are currently no configuration options for this module. PDF sanitization is automatically applied to all uploaded PDF files.

## Usage

Once enabled, the module will automatically sanitize any PDF file uploaded through Drupal's standard file upload mechanisms (e.g., file fields, media library). The original uploaded file will be replaced by its sanitized version.

## Troubleshooting

*   **"PDF sanitization failed: ... Could not open the file ..."**: This usually indicates a permissions issue.
    *   Ensure the `public://` files directory and its subdirectories (e.g., `public://sanitized_pdfs`) are writable by the web server.
    *   Verify Ghostscript has the necessary permissions to read the input file and write the output file in the temporary directory (`/tmp` within the container for DDEV).
*   **"Device 'pdfwrite' requires an output file but no file was specified."**: This indicates an issue with how Ghostscript is being called. Ensure Ghostscript is correctly installed and its path is accessible.
*   **Check Ghostscript installation**: Run `gs -v` on your server's command line (or `ddev exec gs -v` in DDEV) to confirm Ghostscript is installed and working.
*   **Check Drupal logs**: Detailed error messages from the sanitization process are logged in Drupal's recent log messages (`/admin/reports/dblog`). Look for messages from the `pdf_sanitizer` channel.

## Maintainers

*   [Stadoom]
