<?php

namespace Drupal\pdf_sanitizer;

use Symfony\Component\Process\Process;

/**
 * Factory for creating Symfony Process objects.
 *
 * This factory provides a centralized way to create Symfony Process objects,
 * allowing for easier mocking in tests and consistent process creation logic.
 */
class ProcessFactory {

  /**
   * Creates a new Symfony Process object.
   *
   * @param string|array $command
   *   The command to run. This can be a single command string (e.g., 'ls -la')
   *   or an array of command arguments (e.g., ['ls', '-la']). When a string
   *   is provided, it is parsed by the shell. When an array is provided,
   *   the arguments are passed directly to the command without shell
   *   interpretation.
   * @param string|null $cwd
   *   The working directory for the process. If NULL, the current working
   *   directory of the PHP script will be used.
   *
   * @return \Symfony\Component\Process\Process
   *   A new Process object configured with the given command and working
   *   directory.
   */
  public function create($command, ?string $cwd = NULL): Process {
    return new Process($command, $cwd);
  }

}
