<?php

namespace Drupal\pdf_services\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Provides a filter form for accessibility reports.
 */
class AccessibilityFilterForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'pdf_services_accessibility_filter_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $default_status = 'all') {
    $form['#method'] = 'get';
    $form['#cache'] = ['max-age' => 0];

    // Remove the default form action since we want to submit to the same page.
    $form['#action'] = \Drupal::request()->getRequestUri();

    $form['status'] = [
      '#type' => 'select',
      '#title' => $this->t('Accessibility Status'),
      '#options' => [
        'all' => $this->t('All'),
        'passes' => $this->t('Passes'),
        'fails' => $this->t('Needs Review'),
      ],
      '#default_value' => $default_status,
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Filter'),
    ];

    // Remove the Form API fields that should not be in a GET form
    $form_state->setProgrammed(FALSE);
    $form_state->setProcessInput(FALSE);
    $form_state->setSubmitted();
    $form['form_build_id']['#access'] = FALSE;
    $form['form_token']['#access'] = FALSE;
    $form['form_id']['#access'] = FALSE;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // This is a GET form, so the parameters will be in the URL
    // Nothing needs to be done here as the form action is the current page
  }
}
