<?php

namespace Drupal\pdf_services\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Form for filtering PDF Services queue.
 */
class QueueFilterForm extends FormBase {

  /**
   * The request stack.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * Constructs a QueueFilterForm object.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $request_stack
   *   The request stack.
   */
  public function __construct(RequestStack $request_stack) {
    $this->requestStack = $request_stack;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('request_stack')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'pdf_services_queue_filter_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $current_request = $this->requestStack->getCurrentRequest();

    // Get current filter values from URL
    $status_filter = $current_request->query->get('status', 'all');

    $form['status'] = [
      '#type' => 'select',
      '#title' => $this->t('Status'),
      '#options' => [
        'all' => $this->t('All'),
        'pending' => $this->t('Pending'),
        'processing' => $this->t('Processing'),
        'completed' => $this->t('Completed'),
        'failed' => $this->t('Failed'),
      ],
      '#default_value' => $status_filter,
    ];

    $form['actions'] = [
      '#type' => 'actions',
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Filter'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $query = [];

    // Add the status filter if it's not "all"
    $status = $form_state->getValue('status');
    if ($status != 'all') {
      $query['status'] = $status;
    }

    // Redirect to the same page with query parameters
    $form_state->setRedirect('pdf_services.queue_status', [], [
      'query' => $query,
    ]);
  }
}
