<?php

namespace Drupal\pdf_services;

use Drupal\views\EntityViewsData;

/**
 * Provides Views data for PDF accessibility results.
 */
class PdfAccessibilityResultViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();
    $data_table = 'pdf_accessibility_result';

    // Add relationship to file entity
    $data[$data_table]['file'] = [
      'title' => $this->t('File'),
      'help' => $this->t('The file entity this accessibility result is for.'),
      'relationship' => [
        'base' => 'file_managed',
        'base field' => 'fid',
        'field' => 'fid',
        'id' => 'standard',
        'label' => $this->t('File'),
      ],
    ];

    // Add fields specific to accessibility results
    $data[$data_table]['passes'] = [
      'title' => $this->t('Passes Accessibility'),
      'help' => $this->t('Whether the PDF passes accessibility checks.'),
      'field' => [
        'id' => 'boolean',
        'click sortable' => TRUE,
      ],
      'filter' => [
        'id' => 'boolean',
        'label' => $this->t('Passes Accessibility'),
        'type' => 'yes-no',
      ],
      'sort' => [
        'id' => 'standard',
      ],
    ];

    // Add the report field with custom formatter
    $data[$data_table]['report'] = [
      'title' => $this->t('Accessibility Report'),
      'help' => $this->t('The detailed accessibility check results.'),
      'field' => [
        'id' => 'pdf_accessibility_report',
        'click sortable' => FALSE,
      ],
      'filter' => [
        'id' => 'string',
      ],
    ];

    // Add created timestamp
    $data[$data_table]['created'] = [
      'title' => $this->t('Created'),
      'help' => $this->t('When the accessibility check was performed.'),
      'field' => [
        'id' => 'date',
        'click sortable' => TRUE,
      ],
      'sort' => [
        'id' => 'date',
      ],
      'filter' => [
        'id' => 'date',
      ],
    ];

    // Add custom computed fields
    $data[$data_table]['issues_count'] = [
      'title' => $this->t('Number of Issues'),
      'help' => $this->t('Total number of accessibility issues found.'),
      'field' => [
        'id' => 'pdf_accessibility_issues_count',
        'click sortable' => TRUE,
      ],
      'sort' => [
        'id' => 'numeric',
      ],
      'filter' => [
        'id' => 'numeric',
      ],
    ];

    // Add file metadata from relationship
    $data[$data_table]['filename'] = [
      'title' => $this->t('Filename'),
      'help' => $this->t('The name of the PDF file.'),
      'field' => [
        'id' => 'field',
        'click sortable' => TRUE,
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'relationship' => [
        'base' => 'file_managed',
        'base field' => 'filename',
        'field' => 'fid',
        'id' => 'standard',
      ],
    ];

    // Add the reverse relationship from files to accessibility results
    $data['file_managed']['pdf_accessibility_result'] = [
      'title' => $this->t('PDF Accessibility Result'),
      'help' => $this->t('The accessibility check results for this file.'),
      'relationship' => [
        'base' => 'pdf_accessibility_result',
        'base field' => 'fid',
        'field' => 'fid',
        'id' => 'standard',
        'label' => $this->t('PDF Accessibility Result'),
      ],
    ];

    // Add standard fields for pdf_accessibility_result table
    $data['pdf_accessibility_result']['passes'] = [
      'title' => $this->t('Passes Accessibility'),
      'help' => $this->t('Whether the PDF passes accessibility checks.'),
      'field' => [
        'id' => 'boolean',
        'click sortable' => TRUE,
      ],
      'filter' => [
        'id' => 'boolean',
        'label' => $this->t('Passes Accessibility'),
        'type' => 'yes-no',
      ],
      'sort' => [
        'id' => 'standard',
      ],
    ];

    $data['pdf_accessibility_result']['created'] = [
      'title' => $this->t('Check Date'),
      'help' => $this->t('When the accessibility check was performed.'),
      'field' => [
        'id' => 'date',
      ],
      'sort' => [
        'id' => 'date',
      ],
      'filter' => [
        'id' => 'date',
      ],
    ];

    return $data;
  }

}
