<?php

namespace Drupal\pdf_services;

use Drupal\views\EntityViewsData;

/**
 * Provides Views data for PDF analysis results.
 */
class PdfAnalysisResultViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    // Add the reverse relationship from files to analysis results
    $data['file_managed']['pdf_analysis_result'] = [
      'title' => $this->t('PDF Analysis Result'),
      'help' => $this->t('The analysis results for this file.'),
      'relationship' => [
        'base' => 'pdf_analysis_result',
        'base field' => 'fid',
        'field' => 'fid',
        'id' => 'standard',
        'label' => $this->t('PDF Analysis Result'),
      ],
    ];

    // Add boolean fields
    $boolean_fields = ['is_linearized', 'is_tagged', 'is_encrypted'];
    foreach ($boolean_fields as $field) {
      $data['pdf_analysis_result'][$field] = [
        'title' => $this->t(ucfirst(str_replace('is_', '', $field))),
        'help' => $this->t('Whether the PDF is @type.', ['@type' => str_replace('is_', '', $field)]),
        'field' => [
          'id' => 'boolean',
          'click sortable' => TRUE,
        ],
        'filter' => [
          'id' => 'boolean',
          'label' => $this->t(ucfirst(str_replace('is_', '', $field))),
          'type' => 'yes-no',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ];
    }

    // Add numeric fields
    $numeric_fields = [
      'file_size' => 'File Size (bytes)',
      'page_count' => 'Number of Pages',
      'avg_page_bytes' => 'Average Page Size',
    ];
    foreach ($numeric_fields as $field => $title) {
      $data['pdf_analysis_result'][$field] = [
        'title' => $this->t($title),
        'help' => $this->t('The @field of the PDF.', ['@field' => strtolower($title)]),
        'field' => [
          'id' => 'numeric',
          'click sortable' => TRUE,
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ];
    }

    // Add timestamp field
    $data['pdf_analysis_result']['timestamp'] = [
      'title' => $this->t('Analysis Date'),
      'help' => $this->t('When the PDF was analyzed.'),
      'field' => [
        'id' => 'date',
      ],
      'sort' => [
        'id' => 'date',
      ],
      'filter' => [
        'id' => 'date',
      ],
    ];

    return $data;
  }

}
