<?php

namespace Drupal\pdf_services\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to count accessibility issues from the report.
 *
 * @ViewsField("pdf_accessibility_issues_count")
 */
class PdfAccessibilityIssuesCount extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $entity = $values->_entity;
    $report = json_decode($entity->get('report')->value, TRUE);

    if (!$report || empty($report['summary'])) {
      return 0;
    }

    $summary = $report['summary'];

    // Count failed and manual check items
    $total_issues = ($summary['Failed'] ?? 0) +
                   ($summary['Failed manually'] ?? 0) +
                   ($summary['Needs manual check'] ?? 0);

    return $this->sanitizeValue($total_issues);
  }

}
