/**
 * @file
 * JavaScript for PDF Accessibility report.
 */
(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.pdfAccessibilityReport = {
    attach: function (context, settings) {
      // Main toggle for all passed items
      once('pdf-toggle', '.accessibility-summary .stat-item.passed', context).forEach(function(element) {
        $(element).on('click', function () {
          const $report = $(this).closest('.pdf-accessibility-report');
          $report.toggleClass('show-passed');

          // Update section toggles to match the main toggle state
          if ($report.hasClass('show-passed')) {
            $('.section-passed-toggle', $report).text('Hide passed');
          } else {
            $('.section-passed-toggle', $report).text('Show passed');
          }
        });
      });

      // Add section toggles and counters
      once('section-toggle', '.report-section', context).forEach(function(section) {
        const $section = $(section);
        const passedCount = $section.find('.rule-item.status-passed').length;

        // Only add toggle if there are passed items in this section
        if (passedCount > 0) {
          // Add passed count
          $section.find('h4').append('<span class="section-passed-count">(' + passedCount + ' passed)</span>');

          // Add section toggle
          $section.find('h4').append('<span class="section-passed-toggle">Show passed</span>');

          // Handle section toggle
          $section.find('.section-passed-toggle').on('click', function(e) {
            e.stopPropagation();
            const $report = $section.closest('.pdf-accessibility-report');

            // If we're showing just this section
            if (!$report.hasClass('show-passed')) {
              // Show just this section's passed items
              $section.find('.rule-item.status-passed').toggle();

              // Update this section's toggle text
              const isShowing = $section.find('.rule-item.status-passed').is(':visible');
              $(this).text(isShowing ? 'Hide passed' : 'Show passed');
            } else {
              // If global show is on, toggle it off and show only this section
              $report.removeClass('show-passed');
              $section.find('.rule-item.status-passed').show();
              $(this).text('Hide passed');

              // Hide other sections' passed items
              $report.find('.report-section').not($section).find('.rule-item.status-passed').hide();
              $report.find('.report-section').not($section).find('.section-passed-toggle').text('Show passed');
            }
          });
        }
      });
    }
  };
})(jQuery, Drupal, once);
