/**
 * @file
 * JavaScript behaviors for PDF Services field configuration form.
 */

(function ($, Drupal, drupalSettings) {
  'use strict';

  /**
   * Behaviors for PDF services field config form.
   */
  Drupal.behaviors.pdfServicesFieldForm = {
    attach: function (context, settings) {
      // Get the properties checkbox - use the correct ID
      const propertiesCheckbox = $('#edit-pdf-services-check-properties', context);

      if (propertiesCheckbox.length === 0) {
        return; // Exit if checkbox not found
      }

      // Only run once per element
      once('pdf-services-field-logic', propertiesCheckbox.get(0), context).forEach(function (elem) {
        const $propertiesCheckbox = $(elem);

        // Find compression select - try multiple possible selectors
        let $compressionElement = $('#edit-pdf-services-optimization-compression-level', context);
        if ($compressionElement.length === 0) {
          $compressionElement = $('select[name="pdf_services[optimization][compression_level]"]', context);
        }

        if ($compressionElement.length === 0) {
          return; // Exit if compression select not found
        }

        // Function to handle compression level change
        function handleCompressionChange() {
          const compressionValue = $compressionElement.val();
          const $formItem = $propertiesCheckbox.closest('.js-form-item-pdf-services-analysis-check-properties');

          // If user selects any compression other than NONE, ensure properties are checked
          if (compressionValue && compressionValue !== 'NONE') {
            $propertiesCheckbox.prop('checked', true);
            // Add visual indicator instead of disabling
            $formItem.addClass('pdf-services-required');

            // Add a description if it doesn't exist
            if ($formItem.find('.pdf-services-required-message').length === 0) {
              const $description = $formItem.find('.form-item__description');
              if ($description.length > 0) {
                $description.append(' <span class="pdf-services-required-message"><strong>Required when compression is enabled.</strong></span>');
              }
            }
          } else {
            // If user selects NONE, remove visual indicator
            $formItem.removeClass('pdf-services-required');
            $formItem.find('.pdf-services-required-message').remove();
          }
        }

        // Function to handle properties checkbox change
        function handlePropertiesChange() {
          const isChecked = $propertiesCheckbox.prop('checked');
          const compressionValue = $compressionElement.val();

          // If properties is unchecked, reset compression to NONE
          if (!isChecked) {
            $compressionElement.val('NONE');
            handleCompressionChange(); // Update visual state
          }
          // If trying to uncheck while compression is active, prevent it and show message
          else if (!isChecked && compressionValue && compressionValue !== 'NONE') {
            // This shouldn't happen due to the auto-reset above, but just in case
            $propertiesCheckbox.prop('checked', true);
            // Could add a user-facing alert here if needed
          }
        }

        // Add change handlers
        $compressionElement.on('change', handleCompressionChange);
        $propertiesCheckbox.on('change', handlePropertiesChange);

        // Run on initial load
        handleCompressionChange();
      });

    }
  };
})(jQuery, Drupal, drupalSettings);
