<?php

namespace Drupal\pdf_services\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the PDF analysis result entity.
 *
 * @ContentEntityType(
 *   id = "pdf_analysis_result",
 *   label = @Translation("PDF Analysis Result"),
 *   base_table = "pdf_analysis_result",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid"
 *   },
 *   handlers = {
 *     "views_data" = "Drupal\pdf_services\PdfAnalysisResultViewsData",
 *     "access" = "Drupal\Core\Entity\EntityAccessControlHandler",
 *     "storage" = "Drupal\Core\Entity\Sql\SqlContentEntityStorage",
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *   }
 * )
 */
class PdfAnalysisResult extends ContentEntityBase {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['fid'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('File'))
      ->setDescription(t('The file this analysis result is for.'))
      ->setSetting('target_type', 'file')
      ->setRequired(TRUE)
      ->setDisplayOptions('view', [
        'label' => 'hidden',
        'type' => 'file',
        'weight' => 0,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE);

    $fields['timestamp'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Analyzed'))
      ->setDescription(t('When the PDF was analyzed.'))
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'timestamp',
        'weight' => 1,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['is_linearized'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Linearized'))
      ->setDescription(t('Whether the PDF is linearized.'))
      ->setDefaultValue(FALSE)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'boolean',
        'weight' => 2,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['is_tagged'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Tagged'))
      ->setDescription(t('Whether the PDF is tagged.'))
      ->setDefaultValue(FALSE)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'boolean',
        'weight' => 3,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['is_encrypted'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Encrypted'))
      ->setDescription(t('Whether the PDF is encrypted.'))
      ->setDefaultValue(FALSE)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'boolean',
        'weight' => 4,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['file_size'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('File Size'))
      ->setDescription(t('File size in bytes.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_integer',
        'weight' => 5,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['page_count'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Pages'))
      ->setDescription(t('Number of pages in the PDF.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_integer',
        'weight' => 6,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['avg_page_bytes'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Average Page Size'))
      ->setDescription(t('Average bytes per page.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_integer',
        'weight' => 7,
      ])
      ->setDisplayConfigurable('view', TRUE);

      $fields['original_size'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Original Size'))
      ->setDescription(t('Original file size before compression in bytes.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_integer',
        'weight' => 8,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['compressed_size'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Compressed Size'))
      ->setDescription(t('Compressed file size in bytes.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_integer',
        'weight' => 9,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['compression_ratio'] = BaseFieldDefinition::create('float')
      ->setLabel(t('Compression Ratio'))
      ->setDescription(t('Compression ratio as a percentage.'))
      ->setDefaultValue(0)
      ->setDisplayOptions('view', [
        'label' => 'inline',
        'type' => 'number_decimal',
        'settings' => [
          'precision' => 2,
          'scale' => 2,
        ],
        'weight' => 10,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['results'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('Analysis Results'))
      ->setDescription(t('The complete analysis results in JSON format.'))
      ->setRequired(TRUE)
      ->setDisplayOptions('view', [
        'type' => 'string',
        'weight' => 8,
      ])
      ->setDisplayConfigurable('view', TRUE);

    return $fields;
  }

}
