# PDF Services Templates

This directory contains Twig templates used by the PDF Services module:

## PDF Embed Templates

- **pdf-services-adobe-embed.html.twig**: Used for rendering PDF files with the Adobe PDF Embed API.
- **pdf-services-file-link.html.twig**: Used for rendering non-PDF files as download links.

## Overriding Templates

You can override these templates in your theme by copying them to your theme's templates directory:

```
yourtheme/templates/pdf-services-adobe-embed.html.twig
yourtheme/templates/pdf-services-file-link.html.twig
```

### File Link Template Variables

The `pdf-services-file-link.html.twig` template receives the following variables:

- `file_url`: The URL of the file to be downloaded
- `file_name`: The name of the file

### Adobe PDF Embed Template Variables

The `pdf-services-adobe-embed.html.twig` template receives the following variables:

- `div_id`: ID for the container element
- `file_url`: URL of the PDF file
- `file_name`: Name of the PDF file
- `embed_mode`: Embedding mode (FULL_WINDOW, SIZED_CONTAINER, IN_LINE, etc.)
- And various other configuration options for the PDF viewer
