<?php

namespace Drupal\pelias_field\Service;

/**
 * Interface for Pelias Field services.
 */
interface PeliasFieldInterface {

  /**
   * Perform an autocomplete search.
   *
   * @param string $text
   *   The text to search for.
   * @param array $options
   *   Optional parameters:
   *   - max_suggestions: Maximum number of suggestions to return.
   *   - focus_point: Array with 'lat' and 'lon' keys to bias results.
   *   - boundary_country: ISO country code to restrict results.
   *   - sources: Array of data sources to query.
   *   - layers: Array of place types to search for.
   *
   * @return array
   *   Array of GeoJSON features.
   */
  public function autocomplete(string $text, array $options = []): array;

  /**
   * Perform a search.
   *
   * @param string $text
   *   The text to search for.
   * @param array $options
   *   Optional parameters (same as autocomplete).
   *
   * @return array
   *   Array of GeoJSON features.
   */
  public function search(string $text, array $options = []): array;

  /**
   * Perform a reverse geocode.
   *
   * @param float $lat
   *   The latitude.
   * @param float $lon
   *   The longitude.
   * @param array $options
   *   Optional parameters:
   *   - max_results: Maximum number of results to return.
   *   - sources: Array of data sources to query.
   *   - layers: Array of place types to search for.
   *
   * @return array
   *   Array of GeoJSON features.
   */
  public function reverse(float $lat, float $lon, array $options = []): array;

}
