<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\Plugin\Field\FieldWidget\NumberWidget;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'per_domain_number' widget.
 */
#[FieldWidget(
  id: 'per_domain_number',
  label: new TranslatableMarkup('Number field [All domain values]'),
  field_types: [
    'per_domain_integer',
    'per_domain_decimal',
    'per_domain_float',
  ],
)]
class PerDomainNumberWidget extends NumberWidget {
  use PerDomainFieldWidgetTrait;

}
