<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\Plugin\Field\FieldWidget\BooleanCheckboxWidget;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'per_domain_boolean_checkbox' widget.
 */
#[FieldWidget(
  id: 'per_domain_boolean_checkbox',
  label: new TranslatableMarkup('Single on/off checkbox [All domain values]'),
  field_types: ['per_domain_boolean'],
  multiple_values: TRUE,
)]
class PerDomainBooleanCheckboxWidget extends BooleanCheckboxWidget {
  use PerDomainFieldWidgetTrait;

}
