<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Defines the 'per_domain_boolean_field_exposed' entity field type.
 */
#[FieldType(
  id: "per_domain_boolean_field_exposed",
  label: new TranslatableMarkup("Boolean [Per-domain, exposed]"),
  description: new TranslatableMarkup("Field to store a true or false value. Stores a value per-domain, exposing all domain values on the front-end."),
  default_widget: "per_domain_boolean_checkbox_exposed",
  default_formatter: "per_domain_boolean_formatter_exposed"
)]
class PerDomainBooleanFieldExposed extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = [];
    $properties['value'] = DataDefinition::create('any')
      ->setLabel(t('Boolean per domain'))
      ->setRequired(FALSE);

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $columns = [
      'value' => [
        'type' => 'blob',
        'size' => 'big',
        'serialize' => TRUE,
        'not null' => FALSE,
        'description' => 'Serialized array of domain IDs and their boolean status.',
      ],
    ];

    return [
      'columns' => $columns,
      'indexes' => [],
      'foreign keys' => [],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $value = $this->get('value')->getValue();
    return $value === NULL || (is_array($value) && empty($value));
  }

  /**
   * {@inheritdoc}
   */
  public function preSave() {
    $value = $this->get('value')->getValue();
    if (!is_array($value)) {
      $this->set('value', []);
    }
  }

}
