<?php

namespace Drupal\per_domain_fields\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\per_domain_fields\LoadsDomainsTrait;
use Drupal\per_domain_fields\Plugin\DataType\PerDomainTypedDataInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Shared code for per-domain field widgets.
 */
trait PerDomainFieldWidgetTrait {
  use LoadsDomainsTrait;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->entityTypeManager = $container->get('entity_type.manager');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $main_property = 'value';

    $sub_elements = $element;

    foreach ($this->loadDomains() as $domain) {
      if (!$items[$delta] || !$items[$delta]->get($main_property) instanceof PerDomainTypedDataInterface) {
        continue;
      }

      $items[$delta]->get($main_property)->setActiveDomainId($domain->id());
      $sub_element = parent::formElement($items, $delta, $element, $form, $form_state);
      $items[$delta]->get($main_property)->unsetActiveDomainId();

      if (isset($sub_element[$main_property])) {
        $sub_element = $sub_element[$main_property];
      }

      if (isset($sub_element['#title'])) {
        $sub_element['#title'] .= ' (' . $domain->label() . ')';
      }

      $sub_elements[$domain->id()] = $sub_element;
    }

    $sub_elements['#type'] = 'details';
    $sub_elements['#open'] = TRUE;
    $sub_elements['#tree'] = TRUE;
    return [$main_property => $sub_elements];
  }

}
