# Per-Domain Fields

Provides field types that store a different value for each domain. On edit forms
widgets are duplicated so all domain values may be entered at the same time. In
other contexts, per-domain fields transparently operate on the value for the
active domain only. As such, in most cases, no code change is needed. Per-domain
field types are a drop-in replacement for the field types they shadow.

Under-the-hood, the way this works is a field type's ordinary database columns
are converted to serialized blobs. The Typed Data for each such property is
overridden in order to hide this fact from other parts of the system.

## Requirements

- Drupal 10.4 or 11
- PHP 8.1 or higher
- Domain module version 2.0.0 or higher

## Installation

Install as you would normally install a contributed Drupal module. See
[installing modules](https://www.drupal.org/node/895232) for further information.

## Development

This project uses Moshe Weitzman's [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib) for local development.

To get set up:

* Install docker
* Install [ddev](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/)
* Run `ddev start`
* Run `ddev poser`
* Run `ddev symlink-project`
* Run `ddev exec "cd web/core && yarn install"`

See [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib) instructions for running tests and more information.
